/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.sun.enterprise.util.JarEntrySource;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class JarAccess {
    public static final String MANIFEST = "META-INF/MANIFEST.MF";
    static final char SEPARATOR = File.separatorChar;
    private File jarName;
    private File dirName;
    private String beanName;
    private String[] fileNames;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$util$JarAccess != null ? class$com$sun$enterprise$util$JarAccess : (class$com$sun$enterprise$util$JarAccess = JarAccess.class$("com.sun.enterprise.util.JarAccess")));
    static /* synthetic */ Class class$com$sun$enterprise$util$JarAccess;

    static void addEntry(ZipOutputStream zos, JarEntrySource source) throws IOException {
        String name = source.getName();
        if (name.equals("") || name.equals(".")) {
            return;
        }
        ZipEntry e10 = new ZipEntry(name);
        e10.setTime(source.getTime());
        boolean markOnly = source.isMarkOnly();
        if (markOnly) {
            e10.setMethod(0);
            e10.setSize(0L);
            e10.setCrc(0L);
        }
        zos.putNextEntry(e10);
        if (!markOnly) {
            byte[] buf = new byte[1024];
            int len = 0;
            BufferedInputStream is = new BufferedInputStream(source.getInputStream());
            while (len != -1) {
                try {
                    len = ((InputStream)is).read(buf, 0, buf.length);
                }
                catch (EOFException eOFException) {
                    break;
                }
                if (len == -1) continue;
                zos.write(buf, 0, len);
            }
            ((InputStream)is).close();
        }
        zos.closeEntry();
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public static void create(OutputStream out, File baseDir, String[] ejbNames, String[] files) throws IOException {
        int start = 0;
        if (ejbNames != null) {
            start = 1;
        }
        JarEntrySource[] data = new JarEntrySource[files.length + start];
        if (ejbNames != null) {
            data[0] = JarAccess.makeManifestEntry(ejbNames);
        }
        int i2 = 0;
        while (i2 < files.length) {
            data[i2 + start] = new JarEntrySource(JarAccess.entryName(files[i2]), new File(baseDir, files[i2]));
            ++i2;
        }
        JarAccess.create(out, data);
    }

    public static void create(OutputStream out, JarEntrySource[] entries) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(out);
        int i2 = 0;
        while (i2 < entries.length) {
            try {
                JarAccess.addEntry(zos, entries[i2]);
            }
            catch (Exception ex2) {
                ex2.printStackTrace();
                throw new IOException("Invalid JAR entry: " + entries[i2].getName());
            }
            ++i2;
        }
        zos.close();
    }

    public static void create(OutputStream out, String[] files) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(out);
        int i2 = 0;
        while (i2 < files.length) {
            JarAccess.addEntry(zos, new JarEntrySource(new File(files[i2])));
            ++i2;
        }
        zos.close();
    }

    private static String entryName(String name) {
        if ((name = name.replace(File.separatorChar, '/')).startsWith("/")) {
            name = name.substring(1);
        } else if (name.startsWith("./")) {
            name = name.substring(2);
        }
        return name;
    }

    protected static void error(String s2) {
        System.err.println(s2);
    }

    public static void extract(InputStream in, String[] files) throws IOException {
        ZipEntry e10;
        ZipInputStream zis = new ZipInputStream(in);
        block0: while ((e10 = zis.getNextEntry()) != null) {
            if (files == null) {
                JarAccess.extractFile(zis, e10);
                continue;
            }
            String name = e10.getName().replace('/', File.separatorChar);
            int i2 = 0;
            while (i2 < files.length) {
                if (name.startsWith(files[i2])) {
                    JarAccess.extractFile(zis, e10);
                    continue block0;
                }
                ++i2;
            }
        }
    }

    public static Vector extract(InputStream in, String[] files, String directory) throws IOException {
        ZipEntry e10;
        Vector<File> extractedFiles = new Vector<File>();
        ZipInputStream zis = new ZipInputStream(in);
        block0: while ((e10 = zis.getNextEntry()) != null) {
            if (files == null) {
                File extractedFile = JarAccess.extractFile(zis, e10, directory);
                extractedFiles.addElement(extractedFile);
                continue;
            }
            String name = e10.getName().replace('/', File.separatorChar);
            int i2 = 0;
            while (i2 < files.length) {
                if (name.startsWith(files[i2])) {
                    File extractedFile = JarAccess.extractFile(zis, e10, directory);
                    extractedFiles.addElement(extractedFile);
                    continue block0;
                }
                ++i2;
            }
        }
        return extractedFiles;
    }

    private static void extractFile(ZipInputStream zis, ZipEntry e10) throws IOException {
        File f2 = new File(e10.getName().replace('/', File.separatorChar));
        if (e10.isDirectory()) {
            if (!f2.exists() && !f2.mkdirs() || !f2.isDirectory()) {
                throw new IOException(String.valueOf(String.valueOf(f2)) + ": could not create directory");
            }
        } else {
            int len;
            File d10;
            if (!(f2.getParent() == null || ((d10 = new File(f2.getParent())).exists() || d10.mkdirs()) && d10.isDirectory())) {
                throw new IOException(String.valueOf(String.valueOf(d10)) + ": could not create directory");
            }
            FileOutputStream os = new FileOutputStream(f2);
            byte[] b10 = new byte[512];
            while ((len = zis.read(b10, 0, b10.length)) != -1) {
                ((OutputStream)os).write(b10, 0, len);
            }
            zis.closeEntry();
            ((OutputStream)os).close();
        }
    }

    private static File extractFile(ZipInputStream zis, ZipEntry e10, String dir) throws IOException {
        File f2 = new File(String.valueOf(dir) + File.separatorChar + e10.getName().replace('/', File.separatorChar));
        if (e10.isDirectory()) {
            if (!f2.exists() && !f2.mkdirs() || !f2.isDirectory()) {
                throw new IOException(String.valueOf(String.valueOf(f2)) + ": could not create directory");
            }
        } else {
            int len;
            File d10;
            if (!(f2.getParent() == null || ((d10 = new File(f2.getParent())).exists() || d10.mkdirs()) && d10.isDirectory())) {
                throw new IOException(String.valueOf(String.valueOf(d10)) + ": could not create directory");
            }
            FileOutputStream os = new FileOutputStream(f2);
            byte[] b10 = new byte[512];
            while ((len = zis.read(b10, 0, b10.length)) != -1) {
                ((OutputStream)os).write(b10, 0, len);
            }
            zis.closeEntry();
            ((OutputStream)os).close();
        }
        return f2;
    }

    private static void list(InputStream in, String[] files) throws IOException {
        ZipEntry e10;
        ZipInputStream zis = new ZipInputStream(in);
        block0: while ((e10 = zis.getNextEntry()) != null) {
            String name = e10.getName().replace('/', File.separatorChar);
            zis.closeEntry();
            if (files == null) {
                JarAccess.printEntry(e10);
                continue;
            }
            int i2 = 0;
            while (i2 < files.length) {
                if (name.startsWith(files[i2])) {
                    JarAccess.printEntry(e10);
                    continue block0;
                }
                ++i2;
            }
        }
    }

    public static JarEntrySource makeManifestEntry(String[] ejbNames) {
        StringBuffer s2 = new StringBuffer("Manifest-Version: 1.0\n");
        s2.append("\n");
        int i2 = 0;
        while (i2 < ejbNames.length) {
            s2.append("Name: " + ejbNames[i2] + "\n");
            s2.append("Enterprise-Bean: True\n");
            s2.append("\n");
            ++i2;
        }
        return new JarEntrySource(MANIFEST, new ByteArrayInputStream(s2.toString().getBytes()));
    }

    protected static void output(String s2) {
        System.err.println(s2);
    }

    private boolean parseArgs(String[] args) {
        int l2 = args.length;
        int i2 = 0;
        while (i2 < l2) {
            if (args[i2].equals("-bean")) {
                if (i2 + 1 >= l2) {
                    JarAccess.error(localStrings.getLocalString("jaraccess.bean.option", ""));
                    return false;
                }
                this.beanName = args[i2 + 1];
                ++i2;
            } else {
                if (!args[i2].equals("-dir")) break;
                if (i2 + 1 >= l2) {
                    JarAccess.error(localStrings.getLocalString("jaraccess.dir.option", ""));
                    return false;
                }
                this.dirName = new File(args[i2 + 1]);
                ++i2;
            }
            ++i2;
        }
        if (i2 + 1 >= l2) {
            JarAccess.error(localStrings.getLocalString("jaraccess.num.args", ""));
            return false;
        }
        this.jarName = new File(args[i2]);
        this.fileNames = new String[l2 - ++i2];
        int j2 = 0;
        while (j2 < l2 - i2) {
            this.fileNames[j2] = args[j2 + i2];
            ++j2;
        }
        return true;
    }

    private void printArgs() {
        System.err.println("jarName: " + this.jarName);
        System.err.println("dirName: " + this.dirName);
        System.err.println("beanName: " + this.beanName);
        System.err.println("fileNames: " + this.fileNames);
        if (this.fileNames != null) {
            int i2 = 0;
            while (i2 < this.fileNames.length) {
                System.err.println("fileNames[" + i2 + "]: " + this.fileNames[i2]);
                ++i2;
            }
        }
    }

    private static void printEntry(ZipEntry e10) throws IOException {
        JarAccess.output(e10.getName());
    }
}

