/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.sun.enterprise.log.Log;
import com.sun.enterprise.util.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.Util;
import javax.rmi.PortableRemoteObject;
import org.omg.CORBA.ORB;

public class ORBManager {
    private static final boolean debug = false;
    private static final String poaOrbClass = "com.sun.enterprise.iiop.POAEJBORB";
    private static final String poaOrbSingletonClass = "com.sun.corba.ee.internal.corba.ORBSingleton";
    private static final String initHost = "org.omg.CORBA.ORBInitialHost";
    private static final String OMG_ORB_INIT_PORT_PROPERTY = "org.omg.CORBA.ORBInitialPort";
    private static final String DEFAULT_ORB_INIT_PORT = "1050";
    private static final String CONFIG_DIR = "config";
    private static final String J2EE_ORB_CONFIG_FILE_NAME = "orb.properties";
    private static final String J2EE_ORB_CONFIG_PORT_NAME = "port";
    private static final String NATIVE_LIB_DIR = "nativelib";
    private static ORB orb = null;
    private static int orbPort = -1;
    private static InitialContext initialContext = null;
    private static Hashtable orbs = new Hashtable();
    private static boolean librariesLoaded = false;

    private static void checkDelegateProps() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String utilDelegate = System.getProperty("javax.rmi.CORBA.UtilClass");
                if (utilDelegate == null || utilDelegate.equals("")) {
                    System.setProperty("javax.rmi.CORBA.UtilClass", "com.sun.corba.ee.internal.POA.JavaxRmiCorbaUtil");
                    System.setProperty("javax.rmi.CORBA.StubClass", "com.sun.corba.ee.internal.javax.rmi.CORBA.StubDelegateImpl");
                    System.setProperty("javax.rmi.CORBA.PortableRemoteObjectClass", "com.sun.corba.ee.internal.javax.rmi.PortableRemoteObject");
                }
                return null;
            }
        });
    }

    private static synchronized ORB createORB(String[] args, Properties props) {
        ORB neworb = null;
        Properties orbInitProperties = new Properties();
        System.setProperty("org.omg.CORBA.ORBSingletonClass", poaOrbSingletonClass);
        try {
            if (props == null) {
                ((Hashtable)orbInitProperties).put("com.sun.corba.ee.CosTransactions.ORBJTSClass", "com.sun.jts.CosTransactions.DefaultTransactionService");
            } else {
                ((Hashtable)orbInitProperties).putAll(props);
            }
            ((Hashtable)orbInitProperties).put("org.omg.CORBA.ORBClass", poaOrbClass);
            ((Hashtable)orbInitProperties).put("org.omg.CORBA.ORBSingletonClass", poaOrbSingletonClass);
            ORBManager.setORBInitialPort(orbInitProperties);
            neworb = ORB.init(args, orbInitProperties);
        }
        catch (Exception ex2) {
            Log.err.println(ex2);
        }
        return neworb;
    }

    public static Tie exportObject(Remote remote) throws RemoteException {
        PortableRemoteObject.exportObject(remote);
        Tie servantsTie = Util.getTie(remote);
        servantsTie.orb(ORBManager.getORB());
        return servantsTie;
    }

    public static ORB getORB() {
        if (orb == null) {
            ORBManager.init(null, null);
        }
        return orb;
    }

    public static ORB getORBForHost(String hostName) {
        if (!librariesLoaded) {
            ORBManager.loadSharedLibraries();
            librariesLoaded = true;
        }
        if (hostName == null || hostName.equals("")) {
            return ORBManager.getORB();
        }
        ORB hostOrb = (ORB)orbs.get(hostName);
        if (hostOrb == null) {
            Properties props = new Properties();
            props.setProperty(initHost, hostName);
            hostOrb = ORBManager.createORB(null, props);
            orbs.put(hostName, hostOrb);
        }
        return hostOrb;
    }

    public static int getORBInitialPort() {
        if (orb == null) {
            ORBManager.init(null, null);
        }
        return orbPort;
    }

    public static synchronized void init(String[] args, Properties props) {
        if (orb != null) {
            return;
        }
        if (!librariesLoaded) {
            ORBManager.loadSharedLibraries();
            librariesLoaded = true;
        }
        orb = ORBManager.createORB(args, props);
    }

    private static synchronized void loadSharedLibraries() {
        ORBManager.checkDelegateProps();
        String path = FileUtil.getAbsolutePath(NATIVE_LIB_DIR);
        String[] files = new File(path).list();
        if (files == null) {
            return;
        }
        int i2 = 0;
        while (i2 < files.length) {
            try {
                System.load(String.valueOf(path) + File.separator + files[i2]);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                System.err.println("Cannot load library " + files[i2]);
            }
            ++i2;
        }
    }

    public static void removeORBForHost(String hostName) {
        ORB removedOrb = (ORB)orbs.remove(hostName);
    }

    private static void setORBInitialPort(Properties props) {
        String orbInitialPort = System.getProperty(OMG_ORB_INIT_PORT_PROPERTY);
        if (orbInitialPort == null) {
            try {
                File orbConfigFile = new File(FileUtil.getAbsolutePath(CONFIG_DIR + File.separator + J2EE_ORB_CONFIG_FILE_NAME));
                FileInputStream fis = new FileInputStream(orbConfigFile);
                Properties orbConfig = new Properties();
                orbConfig.load(fis);
                orbInitialPort = orbConfig.getProperty(J2EE_ORB_CONFIG_PORT_NAME);
                fis.close();
            }
            catch (Exception orbConfigFile) {
                // empty catch block
            }
            if (orbInitialPort == null) {
                orbInitialPort = DEFAULT_ORB_INIT_PORT;
            }
            System.setProperty(OMG_ORB_INIT_PORT_PROPERTY, orbInitialPort);
        }
        props.setProperty(OMG_ORB_INIT_PORT_PROPERTY, orbInitialPort);
        orbPort = new Integer(orbInitialPort);
    }
}

