/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.CoordinatorLogPool;
import com.sun.jts.CosTransactions.CoordinatorLogSection;
import com.sun.jts.CosTransactions.ErrorLog;
import com.sun.jts.CosTransactions.Log;
import com.sun.jts.CosTransactions.LogFile;
import com.sun.jts.CosTransactions.LogLSN;
import com.sun.jts.CosTransactions.LogUpcallTarget;
import com.sun.jts.CosTransactions.SectionPool;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;

class CoordinatorLog
implements LogUpcallTarget {
    private static final int LOG_DEF_KEY_TRIGGER = 100;
    private static final int LOG_THRESHOLD = 10000;
    private static final int STRING_TO_REF_RETRIES = 20;
    private static LogFile logFile;
    private static Log log;
    private static Hashtable activeLogs;
    private static Hashtable keypointLogs;
    private static int tranCount;
    private static int keypointTrigger;
    private static boolean keypointInProgress;
    private static java.lang.Object keypointLock;
    private static java.lang.Object keypointStateLock;
    private Hashtable sectionMapping = null;
    private boolean rewriteRequired = false;
    private boolean writeDone = false;
    Long localTID = null;
    private ByteArrayOutputStream byteOutput = new ByteArrayOutputStream(2000);
    private DataOutputStream dataOutput = new DataOutputStream(this.byteOutput);

    static {
        block2: {
            logFile = null;
            log = null;
            activeLogs = new Hashtable();
            keypointLogs = new Hashtable();
            tranCount = 0;
            keypointTrigger = 100;
            keypointInProgress = false;
            keypointLock = new java.lang.Object();
            keypointStateLock = new java.lang.Object();
            String keypointCountEnv = Configuration.getPropertyValue("com.sun.jts.keypointCount");
            keypointTrigger = 100;
            if (keypointCountEnv == null) break block2;
            try {
                keypointTrigger = Integer.parseInt(keypointCountEnv);
            }
            catch (Throwable throwable) {}
        }
    }

    CoordinatorLog() {
        this.sectionMapping = new Hashtable();
    }

    CoordinatorLog(Long localTID) {
        this.localTID = localTID;
        if (localTID != 0L) {
            CoordinatorLog.addLog(localTID, this);
        }
    }

    synchronized boolean addData(java.lang.Object sectionObj, byte[] data) {
        boolean result = true;
        if (sectionObj != null) {
            CoordinatorLogSection section = (CoordinatorLogSection)sectionObj;
            section.unwrittenEmpty = false;
            if (section.unwrittenData == null) {
                section.unwrittenData = new Vector(4, 4);
            }
            byte[] dataCopy = new byte[data.length];
            System.arraycopy(data, 0, dataCopy, 0, data.length);
            section.unwrittenData.addElement(dataCopy);
        } else {
            result = false;
        }
        return result;
    }

    private static synchronized boolean addLog(Long localTID, CoordinatorLog clog) {
        boolean result = true;
        activeLogs.put(localTID, clog);
        return result;
    }

    synchronized boolean addObject(java.lang.Object sectionObj, Object obj) {
        boolean result = true;
        if (sectionObj != null) {
            CoordinatorLogSection section = (CoordinatorLogSection)sectionObj;
            section.unwrittenEmpty = false;
            if (section.unwrittenObjects == null) {
                section.unwrittenObjects = new Vector(10, 10);
            }
            String objRefStr = null;
            try {
                objRefStr = Configuration.getORB().object_to_string(obj);
                section.unwrittenObjects.addElement(objRefStr);
            }
            catch (Throwable throwable) {
                result = false;
            }
        } else {
            result = false;
        }
        return result;
    }

    synchronized java.lang.Object createSection(String sectionName) {
        CoordinatorLogSection result = null;
        result = (CoordinatorLogSection)this.sectionMapping.get(sectionName);
        if (result == null) {
            int nameLength = sectionName.length();
            result = SectionPool.getCoordinatorLogSection(sectionName);
            if (result != null) {
                this.sectionMapping.put(sectionName, result);
            }
        }
        return result;
    }

    void dump() {
        if (this.sectionMapping != null) {
            Enumeration sections = this.sectionMapping.elements();
            while (sections.hasMoreElements()) {
                Enumeration data;
                java.lang.Object object;
                Enumeration objects;
                CoordinatorLogSection section = (CoordinatorLogSection)sections.nextElement();
                if (section.writtenObjects != null) {
                    objects = section.writtenObjects.elements();
                    while (objects.hasMoreElements()) {
                        object = (String)objects.nextElement();
                    }
                }
                if (section.unwrittenObjects != null) {
                    objects = section.unwrittenObjects.elements();
                    while (objects.hasMoreElements()) {
                        object = (String)objects.nextElement();
                    }
                }
                if (section.writtenData != null) {
                    data = section.writtenData.elements();
                    while (data.hasMoreElements()) {
                        object = (byte[])data.nextElement();
                    }
                }
                if (section.unwrittenData == null) continue;
                data = section.unwrittenData.elements();
                while (data.hasMoreElements()) {
                    object = (byte[])data.nextElement();
                }
            }
        }
    }

    static void dumpClass() {
        log.dump();
        logFile.dump();
    }

    public synchronized void finalize() {
        if (this.sectionMapping != null) {
            Enumeration sections = this.sectionMapping.elements();
            int sz = this.sectionMapping.size();
            while (sz-- > 0) {
                CoordinatorLogSection section = (CoordinatorLogSection)sections.nextElement();
                section.reUse();
            }
            this.sectionMapping.clear();
            this.sectionMapping = null;
        }
    }

    static synchronized void finalizeAll() {
        boolean deleteFile = false;
        java.lang.Object object = keypointStateLock;
        synchronized (object) {
            if (activeLogs != null) {
                if (activeLogs.size() == 0) {
                    deleteFile = true;
                }
                activeLogs.clear();
                activeLogs = null;
            }
            if (logFile != null) {
                logFile.close(deleteFile);
            }
            logFile = null;
            if (keypointLogs != null) {
                keypointLogs.clear();
            }
            keypointLogs = null;
        }
        keypointStateLock = null;
        keypointLock = null;
    }

    private boolean formatLogRecords(boolean forced) throws IOException {
        CoordinatorLog.openLog();
        if (logFile == null) {
            return false;
        }
        boolean result = false;
        java.lang.Object object = keypointLock;
        synchronized (object) {
            CoordinatorLog coordinatorLog = this;
            synchronized (coordinatorLog) {
                this.byteOutput.reset();
                this.dataOutput.writeLong(this.localTID);
                this.dataOutput.writeShort(this.sectionMapping.size());
                Enumeration sections = this.sectionMapping.elements();
                int sz = this.sectionMapping.size();
                while (sz-- > 0) {
                    this.formatSection((CoordinatorLogSection)sections.nextElement(), this.rewriteRequired, this.dataOutput);
                }
                result = logFile.write(forced ? 1 : 0, this.byteOutput.toByteArray(), this.rewriteRequired ? 3 : 0, null);
                this.rewriteRequired = false;
                this.writeDone = true;
            }
        }
        return result;
    }

    private void formatSection(CoordinatorLogSection section, boolean rewrite, DataOutputStream dataOutput) throws IOException {
        if (section.unwrittenEmpty && (!rewrite || section.writtenEmpty)) {
            dataOutput.writeShort(0);
            return;
        }
        dataOutput.writeShort(section.sectionName.length());
        int unwrittenObjectsSize = 0;
        int writtenObjectsSize = 0;
        if (section.unwrittenObjects != null) {
            unwrittenObjectsSize = section.unwrittenObjects.size();
        }
        if (rewrite && section.writtenObjects != null) {
            writtenObjectsSize = section.writtenObjects.size();
        }
        dataOutput.writeShort(unwrittenObjectsSize + writtenObjectsSize);
        int unwrittenDataSize = 0;
        int writtenDataSize = 0;
        if (section.unwrittenData != null) {
            unwrittenDataSize = section.unwrittenData.size();
        }
        if (rewrite && section.writtenData != null) {
            writtenDataSize = section.writtenData.size();
        }
        dataOutput.writeShort(unwrittenDataSize + writtenDataSize);
        dataOutput.writeBytes(section.sectionName);
        int i2 = 0;
        while (i2 < writtenObjectsSize) {
            String objRefStr = (String)section.writtenObjects.elementAt(i2);
            dataOutput.writeShort(objRefStr.length());
            dataOutput.writeBytes(objRefStr);
            ++i2;
        }
        int i3 = 0;
        while (i3 < unwrittenObjectsSize) {
            String objRefStr = (String)section.unwrittenObjects.elementAt(i3);
            dataOutput.writeShort(objRefStr.length());
            dataOutput.writeBytes(objRefStr);
            if (section.writtenObjects == null) {
                section.writtenObjects = new Vector(unwrittenObjectsSize, 10);
            }
            section.writtenObjects.addElement(objRefStr);
            ++i3;
        }
        if (unwrittenObjectsSize > 0) {
            section.unwrittenObjects.removeAllElements();
        }
        int i4 = 0;
        while (i4 < writtenDataSize) {
            byte[] dataItem = (byte[])section.writtenData.elementAt(i4);
            dataOutput.writeShort(dataItem.length);
            dataOutput.write(dataItem);
            ++i4;
        }
        int i5 = 0;
        while (i5 < unwrittenDataSize) {
            byte[] dataItem = (byte[])section.unwrittenData.elementAt(i5);
            dataOutput.writeShort(dataItem.length);
            dataOutput.write(dataItem);
            if (section.writtenData == null) {
                section.writtenData = new Vector(unwrittenDataSize, 4);
            }
            section.writtenData.addElement(dataItem);
            ++i5;
        }
        if (unwrittenDataSize > 0) {
            section.unwrittenData.removeAllElements();
        }
        section.unwrittenEmpty = true;
        section.writtenEmpty = false;
    }

    byte[][] getData(java.lang.Object sectionObj) {
        byte[][] result = null;
        if (sectionObj != null) {
            CoordinatorLogSection section = (CoordinatorLogSection)sectionObj;
            int unwrittenSize = 0;
            if (section.unwrittenData != null) {
                unwrittenSize = section.unwrittenData.size();
            }
            int writtenSize = 0;
            if (section.writtenData != null) {
                writtenSize = section.writtenData.size();
            }
            result = new byte[unwrittenSize + writtenSize][];
            if (unwrittenSize > 0) {
                section.unwrittenData.copyInto((java.lang.Object[])result);
            }
            int i2 = 0;
            while (i2 < writtenSize) {
                result[unwrittenSize++] = (byte[])section.writtenData.elementAt(i2);
                ++i2;
            }
        }
        return result;
    }

    static synchronized Enumeration getLogged() {
        Vector logRecords = null;
        Enumeration coordLogs = null;
        if (CoordinatorLog.openLog()) {
            logRecords = logFile.getLogRecords();
            int i2 = 0;
            while (i2 < logRecords.size()) {
                byte[] buffer = (byte[])logRecords.elementAt(i2);
                ByteArrayInputStream byteInput = new ByteArrayInputStream(buffer);
                DataInputStream dataInput = new DataInputStream(byteInput);
                try {
                    Long localTID = new Long(dataInput.readLong());
                    CoordinatorLog coordLog = (CoordinatorLog)activeLogs.get(localTID);
                    if (coordLog == null) {
                        coordLog = CoordinatorLogPool.getCoordinatorLog();
                        coordLog.setLocalTID(localTID);
                    }
                    coordLog.reconstruct(dataInput);
                }
                catch (IOException iOException) {}
                ++i2;
            }
            coordLogs = activeLogs.elements();
        } else {
            coordLogs = new Hashtable().elements();
        }
        return coordLogs;
    }

    java.lang.Object[] getObjects(java.lang.Object sectionObj) {
        java.lang.Object[] result = null;
        if (sectionObj != null) {
            CoordinatorLogSection section = (CoordinatorLogSection)sectionObj;
            int unwrittenSize = 0;
            if (section.unwrittenObjects != null) {
                unwrittenSize = section.unwrittenObjects.size();
            }
            int writtenSize = 0;
            if (section.writtenObjects != null) {
                writtenSize = section.writtenObjects.size();
            }
            result = new java.lang.Object[unwrittenSize + writtenSize];
            int currObject = 0;
            ORB orb = Configuration.getORB();
            int i2 = 0;
            while (i2 < writtenSize) {
                Object obj = null;
                String refStr = (String)section.writtenObjects.elementAt(i2);
                int retries = 20;
                boolean discard = false;
                while (obj == null && retries-- > 0 && !discard) {
                    try {
                        obj = orb.string_to_object(refStr);
                    }
                    catch (MARSHAL mARSHAL) {
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException interruptedException) {
                            ErrorLog.error(30, null, true);
                        }
                    }
                    catch (Throwable throwable) {
                        discard = true;
                    }
                }
                if (!discard) {
                    if (obj != null) {
                        result[currObject++] = obj;
                    } else {
                        ErrorLog.error(53, null, true);
                    }
                }
                ++i2;
            }
            int i3 = 0;
            while (i3 < unwrittenSize) {
                try {
                    Object obj = orb.string_to_object((String)section.unwrittenObjects.elementAt(i3));
                    result[currObject++] = obj;
                }
                catch (Throwable throwable) {}
                ++i3;
            }
        }
        return result;
    }

    static void keypoint() {
        byte[] keypointEndRecord = new byte[]{75, 69, 89, 69, 78, 68};
        LogLSN previousLSN = new LogLSN();
        LogLSN keypointStartLSN = new LogLSN();
        boolean keypointRequired = false;
        java.lang.Object object = keypointLock;
        synchronized (object) {
            keypointRequired = CoordinatorLog.startKeypoint(keypointStartLSN);
        }
        if (keypointStartLSN.isNULL()) {
            return;
        }
        if (keypointRequired) {
            Enumeration keypointLocalTIDs = keypointLogs.keys();
            while (keypointLocalTIDs.hasMoreElements()) {
                java.lang.Object object2 = keypointStateLock;
                synchronized (object2) {
                    CoordinatorLog currentLog = (CoordinatorLog)keypointLogs.get(keypointLocalTIDs.nextElement());
                    if (currentLog != null) {
                        currentLog.rewrite();
                    }
                }
            }
        }
        logFile.write(0, keypointEndRecord, 2, previousLSN);
        logFile.checkpoint(keypointStartLSN);
        keypointInProgress = false;
        keypointLogs.clear();
    }

    private static boolean openLog() {
        boolean result = false;
        if (log == null && !(log = new Log()).initialise()) {
            ErrorLog.error(5, null, true);
            log = null;
        }
        String serverName = null;
        if (log != null && logFile == null && (serverName = Configuration.getServerName()) != null) {
            logFile = log.open(serverName, CoordinatorLogPool.getCoordinatorLog());
            if (logFile == null) {
                ErrorLog.error(6, new java.lang.Object[]{serverName}, true);
            } else {
                Configuration.setLogFile(logFile);
            }
        }
        result = log != null && logFile != null;
        return result;
    }

    private synchronized void reUse() {
        if (this.sectionMapping != null) {
            Enumeration sections = this.sectionMapping.elements();
            int sz = this.sectionMapping.size();
            while (sz-- > 0) {
                CoordinatorLogSection section = (CoordinatorLogSection)sections.nextElement();
                section.reUse();
            }
            this.sectionMapping.clear();
        }
        this.rewriteRequired = false;
        this.writeDone = false;
        this.localTID = null;
        this.byteOutput.reset();
        CoordinatorLogPool.putCoordinatorLog(this);
    }

    private boolean reconstruct(DataInputStream dataInput) throws IOException {
        boolean result = true;
        int numSections = dataInput.readUnsignedShort();
        while (--numSections >= 0) {
            int length = dataInput.readUnsignedShort();
            if (length <= 0) continue;
            int numObjects = dataInput.readUnsignedShort();
            int numData = dataInput.readUnsignedShort();
            byte[] stringData = new byte[length];
            dataInput.read(stringData);
            String sectionName = new String(stringData);
            CoordinatorLogSection section = (CoordinatorLogSection)this.createSection(sectionName);
            if (numObjects > 0 && section.writtenObjects == null) {
                section.writtenObjects = new Vector(numObjects, 10);
            }
            int i2 = 0;
            while (i2 < numObjects) {
                length = dataInput.readUnsignedShort();
                stringData = new byte[length];
                dataInput.read(stringData);
                String objRefStr = new String(stringData);
                section.writtenObjects.addElement(objRefStr);
                ++i2;
            }
            if (numData > 0 && section.writtenData == null) {
                section.writtenData = new Vector(numData, 4);
            }
            int i3 = 0;
            while (i3 < numData) {
                length = dataInput.readUnsignedShort();
                byte[] dataItem = new byte[length];
                dataInput.read(dataItem);
                section.writtenData.addElement(dataItem);
                ++i3;
            }
        }
        return result;
    }

    static synchronized boolean removeLog(Long localTID) {
        boolean result = true;
        CoordinatorLog clog = (CoordinatorLog)activeLogs.remove(localTID);
        if (clog != null) {
            java.lang.Object object = keypointStateLock;
            synchronized (object) {
                if (keypointInProgress && keypointLogs != null) {
                    keypointLogs.put(localTID, null);
                }
            }
            if (clog.writeDone) {
                ++tranCount;
            }
            clog.reUse();
            if (tranCount >= keypointTrigger) {
                tranCount = 0;
                CoordinatorLog.keypoint();
            }
        }
        return result;
    }

    private synchronized boolean requireRewrite() {
        boolean result = true;
        if (this.writeDone) {
            this.rewriteRequired = true;
        }
        return result;
    }

    private boolean rewrite() {
        boolean result;
        block2: {
            result = true;
            if (!this.rewriteRequired) break block2;
            try {
                result = this.formatLogRecords(false);
            }
            catch (IOException iOException) {
                result = false;
            }
        }
        return result;
    }

    synchronized void setLocalTID(Long localTID) {
        boolean addToMetaclass = localTID != 0L && (this.localTID == null || this.localTID == 0L);
        this.localTID = localTID;
        if (addToMetaclass) {
            CoordinatorLog.addLog(localTID, this);
        }
    }

    static synchronized boolean startKeypoint(LogLSN keypointStartLSN) {
        boolean keypointRequired = false;
        if (keypointInProgress) {
            return false;
        }
        keypointInProgress = true;
        if (!CoordinatorLog.openLog()) {
            keypointInProgress = false;
            return false;
        }
        if (activeLogs.size() == 0) {
            keypointRequired = false;
        } else {
            Enumeration clogs = activeLogs.elements();
            while (clogs.hasMoreElements()) {
                CoordinatorLog currentLog = (CoordinatorLog)clogs.nextElement();
                Long localTID = currentLog.localTID;
                currentLog.requireRewrite();
                keypointLogs.put(localTID, currentLog);
            }
            keypointRequired = keypointLogs.size() > 0;
        }
        byte[] keypointStartRecord = new byte[]{75, 69, 89, 83, 84, 65, 82, 84};
        logFile.write(0, keypointStartRecord, 1, keypointStartLSN);
        return keypointRequired;
    }

    public void upcall(int reason) {
        CoordinatorLog.keypoint();
    }

    synchronized boolean write(boolean force) {
        boolean result = true;
        try {
            result = this.formatLogRecords(force);
        }
        catch (IOException iOException) {
            result = false;
        }
        return result;
    }
}

