/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.jts.CosTransactions.CompletionHandler;
import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.CoordinatorImpl;
import com.sun.jts.CosTransactions.ErrorLog;
import com.sun.jts.CosTransactions.GlobalTID;
import com.sun.jts.CosTransactions.RecoveryManager;
import com.sun.jts.CosTransactions.SubCoordinator;
import com.sun.jts.CosTransactions.TopCoordinator;
import com.sun.jts.otsidl.CoordinatorResource;
import com.sun.jts.otsidl.CoordinatorResourceHelper;
import com.sun.jts.otsidl.CoordinatorResourcePOA;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.HeuristicCommit;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.HeuristicRollback;
import org.omg.CosTransactions.NotPrepared;
import org.omg.CosTransactions.Vote;
import org.omg.PortableServer.POA;

class CoordinatorResourceImpl
extends CoordinatorResourcePOA
implements CompletionHandler {
    private static POA poa = null;
    private static boolean recoverable = false;
    private CoordinatorResource thisRef = null;
    boolean beingForced = false;
    private GlobalTID globalTID = null;
    private boolean subtransaction = false;
    private boolean aborted = false;
    private boolean heuristicDamage = false;
    private boolean completed = false;
    private boolean setAsTerminator = false;

    CoordinatorResourceImpl(GlobalTID globalTID, CoordinatorImpl coord, boolean subtran) {
        this.subtransaction = subtran;
        this.globalTID = globalTID;
        if (coord != null) {
            coord.setTerminator(this);
        }
    }

    CoordinatorResourceImpl(byte[] key) {
        this.globalTID = new GlobalTID(key);
    }

    public void commit() throws HeuristicRollback, HeuristicMixed, HeuristicHazard, NotPrepared, SystemException {
        if (this.globalTID == null) {
            INTERNAL exc = new INTERNAL(258, CompletionStatus.COMPLETED_NO);
            throw exc;
        }
        if (this.subtransaction) {
            INTERNAL exc = new INTERNAL(259, CompletionStatus.COMPLETED_NO);
            throw exc;
        }
        if (this.completed) {
            if (this.aborted) {
                this.heuristicDamage = true;
                HeuristicRollback exc = new HeuristicRollback();
                throw exc;
            }
            if (this.heuristicDamage) {
                HeuristicMixed exc = new HeuristicMixed();
                throw exc;
            }
        } else {
            RecoveryManager.waitForRecovery();
            TopCoordinator coord = (TopCoordinator)RecoveryManager.getCoordinator(this.globalTID);
            if (coord != null) {
                TopCoordinator topCoordinator = coord;
                synchronized (topCoordinator) {
                    this.makeSureSetAsTerminator();
                    coord.commit();
                }
            }
        }
        if (!this.beingForced) {
            this.destroy();
        }
    }

    public void commit_one_phase() throws TRANSACTION_ROLLEDBACK, HeuristicHazard, SystemException {
        if (this.globalTID == null) {
            INTERNAL exc = new INTERNAL(258, CompletionStatus.COMPLETED_NO);
            throw exc;
        }
        if (this.subtransaction) {
            INTERNAL exc = new INTERNAL(259, CompletionStatus.COMPLETED_NO);
            throw exc;
        }
        if (this.completed) {
            if (this.aborted) {
                TRANSACTION_ROLLEDBACK exc = new TRANSACTION_ROLLEDBACK(0, CompletionStatus.COMPLETED_NO);
                throw exc;
            }
        } else {
            boolean rolledBack;
            RecoveryManager.waitForRecovery();
            TopCoordinator coord = (TopCoordinator)RecoveryManager.getCoordinator(this.globalTID);
            if (coord != null) {
                rolledBack = false;
                TopCoordinator topCoordinator = coord;
                synchronized (topCoordinator) {
                    block16: {
                        this.makeSureSetAsTerminator();
                        Vote vote = Vote.VoteRollback;
                        try {
                            vote = coord.prepare();
                        }
                        catch (HeuristicMixed heuristicMixed) {
                            throw new HeuristicHazard();
                        }
                        try {
                            if (vote == Vote.VoteCommit) {
                                coord.commit();
                            } else {
                                coord.rollback(true);
                                rolledBack = true;
                            }
                        }
                        catch (Throwable exc) {
                            if (!(exc instanceof INTERNAL)) break block16;
                            this.destroy();
                            throw (INTERNAL)exc;
                        }
                    }
                }
            }
            rolledBack = true;
            if (rolledBack) {
                this.destroy();
                TRANSACTION_ROLLEDBACK exc = new TRANSACTION_ROLLEDBACK(0, CompletionStatus.COMPLETED_YES);
                throw exc;
            }
        }
        this.destroy();
    }

    public void commit_subtransaction(Coordinator parent) throws TRANSACTION_ROLLEDBACK, SystemException {
        if (this.globalTID == null) {
            INTERNAL exc = new INTERNAL(258, CompletionStatus.COMPLETED_NO);
            throw exc;
        }
        if (!this.subtransaction) {
            INTERNAL exc = new INTERNAL(260, CompletionStatus.COMPLETED_NO);
            throw exc;
        }
        if (this.completed) {
            if (this.aborted) {
                this.destroy();
                TRANSACTION_ROLLEDBACK exc = new TRANSACTION_ROLLEDBACK(0, CompletionStatus.COMPLETED_YES);
                throw exc;
            }
        } else {
            SubCoordinator coord = (SubCoordinator)RecoveryManager.getCoordinator(this.globalTID);
            if (coord != null) {
                boolean rolledBack = false;
                SubCoordinator subCoordinator = coord;
                synchronized (subCoordinator) {
                    try {
                        if (coord.prepare() == Vote.VoteCommit) {
                            coord.commit();
                        } else {
                            coord.rollback(true);
                            rolledBack = true;
                        }
                    }
                    catch (Throwable throwable) {}
                }
                if (rolledBack) {
                    this.destroy();
                    TRANSACTION_ROLLEDBACK exc = new TRANSACTION_ROLLEDBACK(0, CompletionStatus.COMPLETED_YES);
                    throw exc;
                }
            }
        }
        this.destroy();
    }

    void destroy() {
        try {
            if (poa != null && this.thisRef != null) {
                poa.deactivate_object(poa.reference_to_id(this.thisRef));
                this.thisRef = null;
            } else {
                POA crPoa = null;
                crPoa = poa == null ? Configuration.getPOA("CoordinatorResource") : poa;
                if (this.thisRef == null) {
                    crPoa.deactivate_object(crPoa.servant_to_id(this));
                } else {
                    crPoa.deactivate_object(crPoa.reference_to_id(this.thisRef));
                    this.thisRef = null;
                }
            }
        }
        catch (Exception exception) {
            ErrorLog.error(8, new java.lang.Object[]{"CoordinatorResource"}, false);
        }
        this.finalize();
    }

    void dump() {
    }

    public void finalize() {
        this.globalTID = null;
    }

    public void forget() throws SystemException {
        if (this.subtransaction) {
            INTERNAL exc = new INTERNAL(259, CompletionStatus.COMPLETED_NO);
            throw exc;
        }
        this.destroy();
    }

    void makeSureSetAsTerminator() {
        if (!this.setAsTerminator) {
            CoordinatorImpl coord = RecoveryManager.getCoordinator(this.globalTID);
            if (coord == null) {
                OBJECT_NOT_EXIST exc = new OBJECT_NOT_EXIST();
                throw exc;
            }
            coord.setTerminator(this);
            this.setAsTerminator = true;
        }
    }

    CoordinatorResource object() {
        block4: {
            if (this.thisRef != null) break block4;
            if (poa == null) {
                poa = Configuration.getPOA("CoordinatorResource");
                recoverable = Configuration.isRecoverable();
            }
            try {
                byte[] id = null;
                if (recoverable && this.globalTID != null) {
                    id = this.globalTID.toBytes();
                    poa.activate_object_with_id(id, this);
                    Object obj = poa.create_reference_with_id(id, CoordinatorResourceHelper.id());
                    this.thisRef = CoordinatorResourceHelper.narrow(obj);
                    break block4;
                }
                poa.activate_object(this);
                Object obj = poa.servant_to_reference(this);
                this.thisRef = CoordinatorResourceHelper.narrow(obj);
            }
            catch (Exception exc) {
                exc.printStackTrace();
                ErrorLog.error(7, new java.lang.Object[]{"CoordinatorResource"}, true);
            }
        }
        return this.thisRef;
    }

    public Vote prepare() throws SystemException, HeuristicMixed, HeuristicHazard {
        Vote result = Vote.VoteRollback;
        if (this.globalTID == null) {
            INTERNAL exc = new INTERNAL(258, CompletionStatus.COMPLETED_NO);
            throw exc;
        }
        if (this.subtransaction) {
            INTERNAL exc = new INTERNAL(259, CompletionStatus.COMPLETED_NO);
            throw exc;
        }
        if (this.completed) {
            result = this.aborted ? Vote.VoteRollback : Vote.VoteCommit;
        } else {
            TopCoordinator coord = (TopCoordinator)RecoveryManager.getCoordinator(this.globalTID);
            if (coord != null) {
                TopCoordinator topCoordinator = coord;
                synchronized (topCoordinator) {
                    result = coord.prepare();
                    if (result == Vote.VoteRollback) {
                        coord.rollback(false);
                    }
                }
            }
        }
        if (result == Vote.VoteRollback) {
            this.destroy();
        }
        return result;
    }

    public void rollback() throws HeuristicCommit, HeuristicMixed, HeuristicHazard, SystemException {
        if (this.globalTID == null) {
            INTERNAL exc = new INTERNAL(258, CompletionStatus.COMPLETED_NO);
            throw exc;
        }
        if (this.subtransaction) {
            INTERNAL exc = new INTERNAL(259, CompletionStatus.COMPLETED_NO);
            throw exc;
        }
        if (this.completed) {
            if (!this.aborted) {
                this.heuristicDamage = true;
                HeuristicCommit exc = new HeuristicCommit();
                throw exc;
            }
            if (this.heuristicDamage) {
                HeuristicMixed exc = new HeuristicMixed();
                throw exc;
            }
        } else {
            RecoveryManager.waitForRecovery();
            TopCoordinator coord = (TopCoordinator)RecoveryManager.getCoordinator(this.globalTID);
            if (coord != null) {
                TopCoordinator topCoordinator = coord;
                synchronized (topCoordinator) {
                    this.makeSureSetAsTerminator();
                    coord.rollback(true);
                }
            }
        }
        if (!this.beingForced) {
            this.destroy();
        }
    }

    public void rollback_subtransaction() throws SystemException {
        SubCoordinator coord;
        if (this.globalTID == null) {
            INTERNAL exc = new INTERNAL(258, CompletionStatus.COMPLETED_NO);
            throw exc;
        }
        if (!this.subtransaction) {
            INTERNAL exc = new INTERNAL(260, CompletionStatus.COMPLETED_NO);
            throw exc;
        }
        if (!this.completed && (coord = (SubCoordinator)RecoveryManager.getCoordinator(this.globalTID)) != null) {
            SubCoordinator subCoordinator = coord;
            synchronized (subCoordinator) {
                coord.rollback(true);
            }
        }
        this.destroy();
    }

    public void setCompleted(boolean aborted, boolean heuristicDamage) {
        this.completed = true;
        this.aborted = aborted;
        this.heuristicDamage = heuristicDamage;
    }
}

