/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.security;

import com.sun.enterprise.ServerConfiguration;
import com.sun.enterprise.log.FileLogWriter;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.log.LogUtil;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.util.Date;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tomcat.core.Context;

class LogHandler {
    private static final String WEB_DIR_PREFIX = "web";
    private static final String HTTP_ACCESS_LOG = "web.access.log";
    private static final String HTTP_ERROR_LOG = "web.error.log";
    private static final int BUFFER_SIZE = 1024;
    private static ServerConfiguration config = ServerConfiguration.getConfiguration();
    private Hashtable accessLogs = new Hashtable();
    private Hashtable errorLogs = new Hashtable();
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$web$security$LogHandler != null ? class$com$sun$web$security$LogHandler : (class$com$sun$web$security$LogHandler = LogHandler.class$("com.sun.web.security.LogHandler")));
    static /* synthetic */ Class class$com$sun$web$security$LogHandler;

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private Log getAccessLog(String contextName) {
        Log aLog = (Log)this.accessLogs.get(contextName);
        if (aLog == null) {
            aLog = this.getLog(contextName, HTTP_ACCESS_LOG, "access.log");
            this.accessLogs.put(contextName, aLog);
        }
        return aLog;
    }

    private Log getErrorLog(String contextName) {
        Log aLog = (Log)this.errorLogs.get(contextName);
        if (aLog == null) {
            aLog = this.getLog(contextName, HTTP_ERROR_LOG, "error.log");
            this.errorLogs.put(contextName, aLog);
        }
        return aLog;
    }

    private synchronized Log getLog(String contextName, String propName, String defaultValue) {
        try {
            File dir = LogUtil.getLogDirectory(contextName, WEB_DIR_PREFIX);
            String fname = config.getProperty(propName, defaultValue);
            File logFile = new File(dir, fname);
            if (!logFile.exists()) {
                logFile.createNewFile();
            }
            FileLogWriter fwriter = new FileLogWriter(logFile, 1024);
            return Log.getLog(fwriter);
        }
        catch (Exception e10) {
            e10.printStackTrace();
            Log.err.println(e10);
            return Log.err;
        }
    }

    public synchronized void logError(Context context, HttpServletRequest req, HttpServletResponse resp) {
        Log errorLog = this.getErrorLog(context.getPath());
        errorLog.println("Error serving Request " + req.getRequestURI() + " on " + context.getPath() + " at " + new Date() + ". " + resp.toString());
        errorLog.flush();
    }

    public synchronized void logRequest(Context context, HttpServletRequest req, HttpServletResponse resp) {
        Log accessLog = this.getAccessLog(context.getPath());
        accessLog.println(localStrings.getLocalString("web.security.request.on.at", "Request for  {0} on {1} at {2} ", new Object[]{req.getRequestURI(), context.getPath(), String.valueOf(String.valueOf(new Date())) + ". " + resp.toString()}));
        accessLog.flush();
    }
}

