/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.security;

import com.sun.enterprise.ServerConfiguration;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.net.ssl.KeyManagerFactory;
import com.sun.net.ssl.SSLContext;
import com.sun.net.ssl.TrustManagerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.KeyStore;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import org.apache.tomcat.net.ServerSocketFactory;

public class SSLSocketFactory
extends ServerSocketFactory {
    private static final boolean clientAuth = false;
    private static final boolean debug = false;
    private static ServerConfiguration config = ServerConfiguration.getConfiguration();
    private static final String WEB_KEYSTORE_FILE = "web.keystore.filename";
    private static final String WEB_KEYSTORE_PASS = "web.keystore.password";
    private static final String KEYSTORE_INSTANCE_TYPE = "JKS";
    private KeyStore kstore = null;
    private KeyManagerFactory kmf = null;
    private TrustManagerFactory tmf = null;
    private SSLContext context = null;
    private SSLServerSocketFactory factory = null;
    private String[] cipherSuites;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$web$security$SSLSocketFactory != null ? class$com$sun$web$security$SSLSocketFactory : (class$com$sun$web$security$SSLSocketFactory = SSLSocketFactory.class$("com.sun.web.security.SSLSocketFactory")));
    static /* synthetic */ Class class$com$sun$web$security$SSLSocketFactory;

    public SSLSocketFactory() {
        try {
            this.context = SSLContext.getInstance("TLS");
            this.kmf = KeyManagerFactory.getInstance("SunX509");
            this.kstore = KeyStore.getInstance(KEYSTORE_INSTANCE_TYPE);
            FileInputStream istream = null;
            String keyPass = config.getProperty(WEB_KEYSTORE_PASS, "changeit");
            String defaultKeystoreFile = String.valueOf(System.getProperty("user.home")) + File.separator + ".keystore";
            String keystoreFile = config.getProperty(WEB_KEYSTORE_FILE, defaultKeystoreFile);
            try {
                istream = new FileInputStream(keystoreFile);
            }
            catch (IOException iOException) {
                Log.err.println(localStrings.getLocalString("web.security.keystorefilenotfound", "Cannot find keystore file : {0}", new Object[]{keystoreFile}));
                istream = null;
            }
            try {
                this.kstore.load(istream, keyPass.toCharArray());
            }
            catch (Exception e10) {
                Log.err.println(e10);
                System.out.println(localStrings.getLocalString("web.security.keystore.initialization.error", "Keystore {0} initialization error : {1} ", new Object[]{keystoreFile, e10.getMessage()}));
                this.kstore = KeyStore.getInstance(KEYSTORE_INSTANCE_TYPE);
                this.kstore.load(null, new char[0]);
            }
            this.kmf.init(this.kstore, keyPass.toCharArray());
            this.context.init(this.kmf.getKeyManagers(), null, null);
            this.factory = this.context.getServerSocketFactory();
            this.cipherSuites = this.factory.getSupportedCipherSuites();
        }
        catch (Exception e11) {
            Log.err.print(e11);
            System.out.println(e11.getMessage());
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public ServerSocket createSocket(int port) throws IOException {
        SSLServerSocket socket = (SSLServerSocket)this.factory.createServerSocket(port);
        this.init(socket);
        return socket;
    }

    public ServerSocket createSocket(int port, int backlog) throws IOException {
        SSLServerSocket socket = (SSLServerSocket)this.factory.createServerSocket(port, backlog);
        this.init(socket);
        return socket;
    }

    public ServerSocket createSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
        SSLServerSocket socket = (SSLServerSocket)this.factory.createServerSocket(port, backlog, ifAddress);
        this.init(socket);
        return socket;
    }

    private void init(SSLServerSocket socket) {
        socket.setNeedClientAuth(false);
    }
}

