/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspEngineContext;
import org.apache.jasper.compiler.GeneratorBase;
import org.apache.jasper.compiler.ServiceMethodPhase;
import org.apache.jasper.compiler.ServletWriter;

public class PluginGenerator
extends GeneratorBase
implements ServiceMethodPhase {
    Hashtable attrs;
    Hashtable param;
    String fallback;
    String ieClassId;

    public PluginGenerator(Hashtable attrs, Hashtable param, String fallback) {
        this.attrs = attrs;
        this.param = param;
        this.fallback = fallback;
    }

    public void generate(ServletWriter writer, Class phase) throws JasperException {
        String type = this.getAttribute("type");
        String code = this.getAttribute("code");
        String codebase = this.getAttribute("codebase");
        String archive = this.getAttribute("archive");
        String jreversion = this.getAttribute("jreversion");
        String name = this.getAttribute("name");
        String nspluginurl = this.getAttribute("nspluginurl");
        String iepluginurl = this.getAttribute("iepluginurl");
        if (type == null) {
            throw new JasperException(Constants.getString("jsp.error.plugin.notype"));
        }
        if (code == null) {
            throw new JasperException(Constants.getString("jsp.error.plugin.nocode"));
        }
        writer.popIndent();
        writer.println("/*Code generated for plugin*/");
        writer.indent();
        writer.print("out.println (\"<OBJECT classid=\\\"");
        writer.print(this.ieClassId);
        writer.print("\\\"");
        this.generateCommon(writer);
        writer.print(" codebase=\\\"");
        if (iepluginurl == null) {
            writer.print("http://java.sun.com/products/plugin/1.2.2/jinstall-1_2_2-win.cab#Version=1,2,2,0");
        } else {
            writer.print(iepluginurl);
        }
        writer.print("\\\"");
        writer.print(">\");");
        writer.println();
        writer.indent();
        writer.print("out.println (\"<PARAM name=\\\"java_code\\\"");
        writer.print(" value=\\\"");
        writer.print(code);
        writer.print("\\\"");
        writer.print(">\");");
        writer.println();
        if (codebase != null) {
            writer.indent();
            writer.print("out.println (\"<PARAM name=\\\"java_codebase\\\"");
            writer.print(" value=\\\"");
            writer.print(codebase);
            writer.print("\\\"");
            writer.print(">\");");
            writer.println();
        }
        if (archive != null) {
            writer.indent();
            writer.print("out.println (\"<PARAM name=\\\"java_archive\\\"");
            writer.print(" value=\\\"");
            writer.print(archive);
            writer.print("\\\"");
            writer.print(">\");");
            writer.println();
        }
        writer.indent();
        writer.print("out.println (\"<PARAM name=\\\"type\\\"");
        writer.print(" value=\\\"");
        if (type.equals("applet")) {
            writer.print("application/x-java-applet;");
        } else if (type.equals("bean")) {
            writer.print("application/x-java-bean;");
        }
        if (jreversion != null) {
            writer.print("version=");
            writer.print(jreversion);
        }
        writer.print("\\\"");
        writer.print(">\");");
        writer.println();
        Enumeration e10 = null;
        String[] value = null;
        String key = null;
        if (this.param != null) {
            e10 = this.param.keys();
            while (e10.hasMoreElements()) {
                key = (String)e10.nextElement();
                value = (String[])this.param.get(key);
                writer.indent();
                writer.print("out.println (\"<PARAM name=\\\"");
                if (key.equalsIgnoreCase("object")) {
                    writer.print("java_object");
                } else if (key.equalsIgnoreCase("type")) {
                    writer.print("java_type");
                } else {
                    writer.print(key);
                }
                writer.print("\\\"");
                writer.print(" value=\\\"");
                writer.print(value[0]);
                writer.print("\\\"");
                writer.print(">\");");
                writer.println();
            }
        }
        writer.println("out.println (\"<COMMENT>\");");
        writer.indent();
        writer.print("out.print (\"<EMBED type=\\\"");
        if (type.equals("applet")) {
            writer.print("application/x-java-applet;");
        } else if (type.equals("bean")) {
            writer.print("application/x-java-bean;");
        }
        if (jreversion != null) {
            writer.print("version=");
            writer.print(jreversion);
        }
        writer.print("\\\" ");
        this.generateCommon(writer);
        writer.print("pluginspage=\\\"");
        if (nspluginurl == null) {
            writer.print("http://java.sun.com/products/plugin/");
        } else {
            writer.print(nspluginurl);
        }
        writer.print("\\\" ");
        writer.print("java_code=\\\"");
        writer.print(code);
        writer.print("\\\" ");
        if (codebase != null) {
            writer.print("java_codebase=\\\"");
            writer.print(codebase);
            writer.print("\\\" ");
        }
        if (archive != null) {
            writer.print("java_archive=\\\"");
            writer.print(archive);
            writer.print("\\\" ");
        }
        if (this.param != null) {
            e10 = this.param.keys();
            key = null;
            value = null;
            while (e10.hasMoreElements()) {
                key = (String)e10.nextElement();
                value = (String[])this.param.get(key);
                if (key.equalsIgnoreCase("object")) {
                    writer.print("java_object");
                } else if (key.equalsIgnoreCase("type")) {
                    writer.print("java_type");
                } else {
                    writer.print(key);
                }
                writer.print("=\\\"");
                writer.print(value[0]);
                writer.print("\\\"");
                writer.print(" ");
            }
        }
        writer.print(">\");");
        writer.println();
        writer.println("out.println (\"<NOEMBED>\");");
        writer.println("out.println (\"</COMMENT>\");");
        if (this.fallback != null) {
            this.fallback = writer.quoteString(this.fallback);
            writer.indent();
            writer.print("out.println (");
            writer.print(this.fallback);
            writer.print(");");
            writer.println();
        }
        writer.println("out.println (\"</NOEMBED></EMBED>\");");
        writer.println("out.println (\"</OBJECT>\");");
        writer.pushIndent();
    }

    public void generateCommon(ServletWriter writer) {
        String align = this.getAttribute("align");
        String width = this.getAttribute("width");
        String height = this.getAttribute("height");
        String hspace = this.getAttribute("hspace");
        String vspace = this.getAttribute("vspace");
        if (width != null) {
            writer.print(" width=\\\"");
            writer.print(width);
            writer.print("\\\" ");
        }
        if (height != null) {
            writer.print(" height=\\\"");
            writer.print(height);
            writer.print("\\\" ");
        }
        if (hspace != null) {
            writer.print(" hspace=\\\"");
            writer.print(hspace);
            writer.print("\\\" ");
        }
        if (vspace != null) {
            writer.print(" vspace=\\\"");
            writer.print(vspace);
            writer.print("\\\" ");
        }
        if (align != null) {
            writer.print(" align=\\\"");
            writer.print(align);
            writer.print("\\\" ");
        }
    }

    public String getAttribute(String name) {
        return this.attrs != null ? (String)this.attrs.get(name) : null;
    }

    public void init(JspEngineContext ctxt) throws JasperException {
        this.ieClassId = ctxt.getOptions().ieClassId();
    }
}

