/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.ServerSession;
import org.apache.tomcat.util.FileUtil;
import org.apache.tomcat.util.StringManager;

public class HttpServletRequestFacade
implements HttpServletRequest {
    private StringManager sm = StringManager.getManager("org.apache.tomcat.core");
    private Request request;
    private boolean usingStream = false;
    private boolean usingReader = false;

    public HttpServletRequestFacade(Request request) {
        this.request = request;
    }

    public Object getAttribute(String name) {
        return this.request.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return this.request.getAttributeNames();
    }

    public String getAuthType() {
        return this.request.getAuthType();
    }

    public String getCharacterEncoding() {
        return this.request.getCharacterEncoding();
    }

    public int getContentLength() {
        return this.request.getContentLength();
    }

    public String getContentType() {
        return this.request.getContentType();
    }

    private Context getContext() {
        return this.getRealRequest().getContext();
    }

    public String getContextPath() {
        return this.getContext().getPath();
    }

    public Cookie[] getCookies() {
        return this.request.getCookies();
    }

    public long getDateHeader(String name) {
        return this.request.getDateHeader(name);
    }

    public String getHeader(String name) {
        return this.request.getHeader(name);
    }

    public Enumeration getHeaderNames() {
        return this.request.getHeaderNames();
    }

    public Enumeration getHeaders(String name) {
        return this.request.getHeaders(name);
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.usingReader) {
            String msg = this.sm.getString("reqfac.getinstream.ise");
            throw new IllegalStateException(msg);
        }
        this.usingStream = true;
        return this.request.getInputStream();
    }

    public int getIntHeader(String name) {
        return this.request.getIntHeader(name);
    }

    public Locale getLocale() {
        return (Locale)this.getLocales().nextElement();
    }

    public Enumeration getLocales() {
        String acceptLanguage = this.getHeader("Accept-Language");
        return this.getLocales(acceptLanguage);
    }

    private Enumeration getLocales(String acceptLanguage) {
        if (acceptLanguage == null) {
            Vector<Locale> def = new Vector<Locale>();
            def.addElement(Locale.getDefault());
            return def.elements();
        }
        Hashtable languages = new Hashtable();
        StringTokenizer languageTokenizer = new StringTokenizer(acceptLanguage, ",");
        while (languageTokenizer.hasMoreTokens()) {
            String language = languageTokenizer.nextToken().trim();
            int qValueIndex = language.indexOf(59);
            int qIndex = language.indexOf(113);
            int equalIndex = language.indexOf(61);
            Double qValue = new Double(1.0);
            if (qValueIndex > -1 && qValueIndex < qIndex && qIndex < equalIndex) {
                String qValueStr = language.substring(qValueIndex + 1);
                language = language.substring(0, qValueIndex);
                qValueStr = qValueStr.trim().toLowerCase();
                qValueIndex = qValueStr.indexOf(61);
                qValue = new Double(0.0);
                if (qValueStr.startsWith("q") && qValueIndex > -1) {
                    qValueStr = qValueStr.substring(qValueIndex + 1);
                    try {
                        qValue = new Double(qValueStr.trim());
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            if (language.equals("*")) continue;
            String key = qValue.toString();
            Vector<Object> v2 = languages.containsKey(key) ? languages.get(key) : new Vector();
            v2.addElement(language);
            languages.put(key, v2);
        }
        if (languages.size() == 0) {
            Vector<String> v3 = new Vector<String>();
            v3.addElement("en");
            languages.put("1.0", v3);
        }
        Vector<Locale> l2 = new Vector<Locale>();
        Enumeration e10 = languages.keys();
        while (e10.hasMoreElements()) {
            String key = (String)e10.nextElement();
            Vector v4 = (Vector)languages.get(key);
            Enumeration le = v4.elements();
            while (le.hasMoreElements()) {
                String language = (String)le.nextElement();
                String country = "";
                int countryIndex = language.indexOf("-");
                if (countryIndex > -1) {
                    country = language.substring(countryIndex + 1).trim();
                    language = language.substring(0, countryIndex).trim();
                }
                l2.addElement(new Locale(language, country));
            }
        }
        return l2.elements();
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public String getParameter(String name) {
        String[] values = this.getParameterValues(name);
        if (values != null) {
            return values[0];
        }
        return null;
    }

    public Enumeration getParameterNames() {
        return this.request.getParameterNames();
    }

    public String[] getParameterValues(String name) {
        return this.request.getParameterValues(name);
    }

    public String getPathInfo() {
        return this.request.getPathInfo();
    }

    public String getPathTranslated() {
        String pathTranslated;
        block4: {
            pathTranslated = null;
            String pathInfo = this.getPathInfo();
            if (pathInfo == null) break block4;
            if (pathInfo.equals("")) {
                pathInfo = "/";
            }
            try {
                URL url = this.request.getContext().getFacade().getResource(pathInfo);
                if (url != null && url.getProtocol().equals("file")) {
                    pathTranslated = FileUtil.patch(url.getFile());
                }
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return pathTranslated;
    }

    public String getProtocol() {
        return this.request.getProtocol();
    }

    public String getQueryString() {
        return this.request.getQueryString();
    }

    public BufferedReader getReader() throws IOException {
        if (this.usingStream) {
            String msg = this.sm.getString("reqfac.getreader.ise");
            throw new IllegalStateException(msg);
        }
        this.usingReader = true;
        return this.request.getReader();
    }

    public String getRealPath(String name) {
        return this.request.getContext().getFacade().getRealPath(name);
    }

    public Request getRealRequest() {
        return this.request;
    }

    public String getRemoteAddr() {
        return this.request.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.request.getRemoteHost();
    }

    public String getRemoteUser() {
        Principal p2 = this.getUserPrincipal();
        if (p2 != null) {
            return p2.getName();
        }
        return null;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (path == null) {
            String msg = this.sm.getString("hsrf.dispatcher.iae", path);
            throw new IllegalArgumentException(msg);
        }
        if (!path.startsWith("/")) {
            String lookupPath = this.request.getLookupPath();
            int index = lookupPath.lastIndexOf("/");
            lookupPath = lookupPath.substring(0, index);
            while (path.startsWith("../")) {
                if (lookupPath.length() <= 0) {
                    return null;
                }
                index = lookupPath.lastIndexOf("/");
                lookupPath = lookupPath.substring(0, index);
                index = path.indexOf("../") + 3;
                path = path.substring(index);
            }
            path = String.valueOf(lookupPath) + "/" + path;
        }
        RequestDispatcher requestDispatcher = this.getContext().getFacade().getRequestDispatcher(path);
        return requestDispatcher;
    }

    public String getRequestURI() {
        return this.request.getRequestURI();
    }

    public String getRequestedSessionId() {
        return this.request.getRequestedSessionId();
    }

    public String getScheme() {
        return this.request.getScheme();
    }

    public String getServerName() {
        return this.request.getServerName();
    }

    public int getServerPort() {
        return this.request.getServerPort();
    }

    public ServerSession getServerSession(boolean create) {
        return this.request.getServerSession(create);
    }

    public String getServletPath() {
        return this.request.getServletPath();
    }

    public HttpSession getSession() {
        return this.request.getSession();
    }

    public HttpSession getSession(boolean create) {
        return this.request.getSession(create);
    }

    public Principal getUserPrincipal() {
        Context ctx = this.getContext();
        return ctx.getRequestSecurityProvider().getUserPrincipal(ctx, this);
    }

    public boolean isRequestedSessionIdFromCookie() {
        return true;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdValid() {
        HttpSession session = this.getSession(false);
        return session != null;
    }

    public boolean isSecure() {
        Context ctx = this.getContext();
        return ctx.getRequestSecurityProvider().isSecure(ctx, this);
    }

    public boolean isUserInRole(String role) {
        Context ctx = this.getContext();
        return ctx.getRequestSecurityProvider().isUserInRole(ctx, this, role);
    }

    public void removeAttribute(String name) {
        this.request.removeAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        this.request.setAttribute(name, value);
    }
}

