/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.core;

import java.io.IOException;
import java.util.Hashtable;
import javax.servlet.ServletOutputStream;
import org.apache.tomcat.core.BufferedServletOutputStream;
import org.apache.tomcat.core.ResponseAdapter;
import org.apache.tomcat.util.MimeHeaderField;
import org.apache.tomcat.util.MimeHeaders;

public class ResponseAdapterImpl
implements ResponseAdapter {
    int status;
    String message;
    Hashtable headers = new Hashtable();
    BufferedServletOutputStream sos = new BufferedServletOutputStream(this);
    StringBuffer body = new StringBuffer();

    public void addHeader(String name, String value) throws IOException {
        this.headers.put(name, value);
    }

    public void addMimeHeaders(MimeHeaders headers) throws IOException {
        int size = headers.size();
        int i2 = 0;
        while (i2 < size) {
            MimeHeaderField h2 = headers.getField(i2);
            this.addHeader(h2.getName(), h2.getValue());
            ++i2;
        }
    }

    public void doWrite(byte[] buffer, int pos, int count) throws IOException {
        this.body.append(new String(buffer, pos, count));
    }

    public void endHeaders() throws IOException {
    }

    public void endResponse() throws IOException {
    }

    public StringBuffer getBody() {
        return this.body;
    }

    public Hashtable getHeaders() {
        return this.headers;
    }

    public String getMessage() {
        return this.message;
    }

    public ServletOutputStream getServletOutputStream() throws IOException {
        return this.sos;
    }

    public int getStatus() {
        return this.status;
    }

    public void recycle() {
        this.sos.recycle();
        this.headers.clear();
        this.status = -1;
        this.message = null;
        this.body.setLength(0);
    }

    public void setStatus(int status, String message) throws IOException {
        this.status = status;
        this.message = message;
    }
}

