/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.security.file;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.tomcat.security.file.FileRealmGroup;
import org.apache.tomcat.security.file.FileRealmUser;
import org.apache.tomcat.util.HexUtils;
import org.apache.tomcat.util.StringManager;
import org.apache.tomcat.util.XMLParser;
import org.apache.tomcat.util.XMLTree;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class FileRealmDatabase {
    private Hashtable groups = new Hashtable();
    private Hashtable roles = new Hashtable();
    private StringManager sm = StringManager.getManager("org.apache.tomcat.security.file");
    private Hashtable users = new Hashtable();

    public FileRealmDatabase() {
    }

    public FileRealmDatabase(InputStream stream) throws IOException, SAXParseException, SAXException {
        this.read(stream);
    }

    void addGroup(FileRealmGroup group) {
        this.groups.put(group.getName(), group);
    }

    void addRole(String role) {
        this.roles.put(role, role);
    }

    void addUser(FileRealmUser user) {
        this.users.put(user.getName(), user);
    }

    public FileRealmGroup createGroup(String name) {
        if (this.getGroup(name) != null) {
            throw new IllegalArgumentException(this.sm.getString("file.createGroup.exists", name));
        }
        return new FileRealmGroup(this, name);
    }

    public FileRealmUser createUser(String name, String password) {
        if (this.getUser(name) != null) {
            throw new IllegalArgumentException(this.sm.getString("file.createUser.exists", name));
        }
        return new FileRealmUser(this, name, password);
    }

    public FileRealmUser createUser(String name, byte[] password) {
        if (this.getUser(name) != null) {
            throw new IllegalArgumentException(this.sm.getString("file.createUser.exists", name));
        }
        return new FileRealmUser(this, name, password);
    }

    public FileRealmGroup getGroup(String name) {
        return (FileRealmGroup)this.groups.get(name);
    }

    public Enumeration getGroups() {
        return this.groups.elements();
    }

    public Enumeration getRoles() {
        return this.roles.keys();
    }

    public FileRealmUser getUser(String name) {
        return (FileRealmUser)this.users.get(name);
    }

    public Enumeration getUsers() {
        return this.users.elements();
    }

    public boolean hasRole(String role) {
        return this.roles.get(role) != null;
    }

    public void read(InputStream stream) throws IOException, SAXParseException, SAXException {
        this.reset();
        XMLParser parser = new XMLParser();
        XMLTree config = parser.process(stream);
        if (!config.getName().equals("tomcat-users")) {
            return;
        }
        Enumeration e10 = config.getElements("user").elements();
        while (e10.hasMoreElements()) {
            this.readUser((XMLTree)e10.nextElement());
        }
        e10 = config.getElements("group").elements();
        while (e10.hasMoreElements()) {
            this.readGroup((XMLTree)e10.nextElement());
        }
        e10 = config.getElements("role").elements();
        while (e10.hasMoreElements()) {
            this.readRole((XMLTree)e10.nextElement());
        }
    }

    private void readGroup(XMLTree element) {
        String name = (String)element.getAttribute("name");
        FileRealmGroup group = this.createGroup(name);
        Enumeration e10 = element.getElements("user-member").elements();
        while (e10.hasMoreElements()) {
            XMLTree um = (XMLTree)e10.nextElement();
            String username = (String)um.getAttribute("name");
            FileRealmUser user = this.getUser(username);
            if (user == null) continue;
            user.addGroup(group);
        }
    }

    private void readRole(XMLTree element) {
        String role = (String)element.getAttribute("name");
        Enumeration e10 = null;
        e10 = element.getElements("group-member").elements();
        while (e10.hasMoreElements()) {
            XMLTree gm = (XMLTree)e10.nextElement();
            String groupname = (String)gm.getAttribute("name");
            FileRealmGroup group = this.getGroup(groupname);
            if (group == null) continue;
            group.addRole(role);
        }
        e10 = element.getElements("user-member").elements();
        while (e10.hasMoreElements()) {
            XMLTree um = (XMLTree)e10.nextElement();
            String username = (String)um.getAttribute("name");
            FileRealmUser user = this.getUser(username);
            if (user == null) continue;
            user.addRole(role);
        }
    }

    private void readUser(XMLTree element) {
        String name = (String)element.getAttribute("name");
        byte[] password = HexUtils.convert((String)element.getAttribute("password"));
        this.createUser(name, password);
    }

    void remove(String role) {
        this.roles.remove(role);
    }

    void remove(FileRealmGroup group) {
        this.groups.remove(group.getName());
    }

    void remove(FileRealmUser user) {
        this.users.remove(user.getName());
    }

    public void reset() {
        this.groups.clear();
        this.roles.clear();
        this.users.clear();
    }

    public void write(OutputStream stream) throws IOException {
        PrintWriter writer = new PrintWriter(stream);
        writer.println("<tomcat-users>");
        Enumeration users = this.getUsers();
        while (users.hasMoreElements()) {
            FileRealmUser user = (FileRealmUser)users.nextElement();
            writer.println("  <user name=\"" + user.getName() + "\" password=\"" + HexUtils.convert(user.getPassword()) + "\" />");
        }
        Enumeration groups = this.getGroups();
        while (groups.hasMoreElements()) {
            FileRealmGroup group = (FileRealmGroup)groups.nextElement();
            writer.println("  <group name=\"" + group.getName() + "\">");
            users = group.getUsers();
            while (users.hasMoreElements()) {
                FileRealmUser user = (FileRealmUser)users.nextElement();
                writer.println("    <user-member name=\"" + user.getName() + "\" />");
            }
            writer.println("  </group>");
        }
        Enumeration roles = this.getRoles();
        while (roles.hasMoreElements()) {
            String role = (String)roles.nextElement();
            writer.println("  <role name=\"" + role + "\">");
            users = this.getUsers();
            while (users.hasMoreElements()) {
                FileRealmUser user = (FileRealmUser)users.nextElement();
                if (!user.hasRole(role)) continue;
                writer.println("    <user-member name=\"" + user.getName() + "\" />");
            }
            groups = this.getGroups();
            while (groups.hasMoreElements()) {
                FileRealmGroup group = (FileRealmGroup)groups.nextElement();
                if (!group.hasRole(role)) continue;
                writer.println("    <group-member name=\"" + group.getName() + "\" />");
            }
            writer.println("  </role>");
        }
        writer.println("</tomcat-users>");
        writer.flush();
    }
}

