/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tomcat.net.ServerSocketFactory;
import org.apache.tomcat.server.ConnectionHandler;
import org.apache.tomcat.server.Endpoint;
import org.apache.tomcat.server.HttpServer;
import org.apache.tomcat.server.HttpServerException;
import org.apache.tomcat.util.StringManager;

public class EndpointManager {
    private StringManager sm = StringManager.getManager("org.apache.tomcat.server");
    private static final int BACKLOG = 50;
    private static final int TIMEOUT = 1000;
    private static EndpointManager manager = new EndpointManager();
    private Vector endpoints = new Vector();
    private Hashtable endpointMaps = new Hashtable();
    private Hashtable serverMaps = new Hashtable();
    private ServerSocketFactory defaultFactory = ServerSocketFactory.getDefault();
    private int backlog = 50;
    private int timeout = 1000;

    private EndpointManager() {
    }

    public synchronized void addEndpoint(HttpServer server, int port, InetAddress inet, ServerSocketFactory factory) throws HttpServerException {
        Endpoint endpnt;
        Enumeration enumeration = this.endpoints.elements();
        while (enumeration.hasMoreElements()) {
            endpnt = (Endpoint)enumeration.nextElement();
            if (endpnt.getPort() != port || endpnt.getAddress() != inet) continue;
            return;
        }
        endpnt = new Endpoint(inet, port);
        try {
            ServerSocket ss = null;
            ss = inet != null ? (factory != null ? factory : this.defaultFactory).createSocket(port, this.backlog) : (factory != null ? factory : this.defaultFactory).createSocket(port, this.backlog, inet);
            endpnt.setServerSocket(ss);
            String msg = this.sm.getString("endptmgr.created", endpnt);
            System.out.println(msg);
        }
        catch (InstantiationException ie) {
            System.out.println("FOO: " + ie);
        }
        catch (IOException ioe) {
            String msg = this.sm.getString("endptmgr.getendpt.ioe", inet, Integer.toString(port), ioe);
            throw new HttpServerException(msg);
        }
        this.endpoints.addElement(endpnt);
        if (this.serverMaps.get(server) == null) {
            this.serverMaps.put(server, new Vector());
        }
        ((Vector)this.serverMaps.get(server)).addElement(endpnt);
        if (this.endpointMaps.get(endpnt) == null) {
            this.endpointMaps.put(endpnt, new Vector());
        }
        ((Vector)this.endpointMaps.get(endpnt)).addElement(server);
    }

    ConnectionHandler getHandler() {
        return new ConnectionHandler(this);
    }

    public static EndpointManager getManager() {
        return manager;
    }

    void notifyEndpointDown(Endpoint endpnt) {
        System.out.println("endpoint down: " + endpnt);
    }

    HttpServer resolveServer(Endpoint endpoint, String hostname) {
        HttpServer server = null;
        Vector v2 = (Vector)this.endpointMaps.get(endpoint);
        if (v2 == null) {
            System.out.println("NO SERVER FOR CONNECTION ON: " + endpoint);
            System.exit(1);
        }
        if (v2.size() == 1) {
            server = (HttpServer)v2.firstElement();
        } else {
            System.out.println("CAN'T DO VIRTUAL HOSTS YET");
            System.exit(1);
        }
        return server;
    }

    void returnHandler(ConnectionHandler handler) {
        handler.recycle();
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    void startServer(HttpServer server) throws HttpServerException {
        Vector v2 = (Vector)this.serverMaps.get(server);
        Enumeration e10 = v2.elements();
        while (e10.hasMoreElements()) {
            Endpoint endpnt = (Endpoint)e10.nextElement();
            Thread thread = new Thread(endpnt);
            thread.start();
        }
    }

    void stopServer(HttpServer server) throws HttpServerException {
        Vector v2 = (Vector)this.serverMaps.get(server);
        Enumeration e10 = v2.elements();
        while (e10.hasMoreElements()) {
            Endpoint endpnt = (Endpoint)e10.nextElement();
            System.out.println("Taking down endpoint: " + endpnt);
            endpnt.shutdown();
            this.endpointMaps.remove(endpnt);
        }
    }
}

