/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.service;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.http.Cookie;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.service.Ajp22Constants;
import org.apache.tomcat.service.Ajp22ServletOS;
import org.apache.tomcat.service.MessageConnector;
import org.apache.tomcat.util.BuffTool;
import org.apache.tomcat.util.CookieTools;

class Ajp22Response
extends Response
implements Ajp22Constants {
    MessageConnector proto;
    Ajp22ServletOS rout;

    public Ajp22Response(MessageConnector proto) {
        this.proto = proto;
        this.rout = new Ajp22ServletOS(proto);
        this.rout.setResponse(this);
        this.out = this.rout;
    }

    protected void fixHeaders() throws IOException {
        Cookie c10;
        this.headers.putIntHeader("Status", this.status);
        this.headers.putHeader("Content-Type", this.contentType);
        if (this.contentLength != -1) {
            this.headers.putIntHeader("Content-Length", this.contentLength);
        }
        Enumeration cookieEnum = null;
        cookieEnum = this.systemCookies.elements();
        while (cookieEnum.hasMoreElements()) {
            c10 = (Cookie)cookieEnum.nextElement();
            this.headers.putHeader(CookieTools.getCookieHeaderName(c10), CookieTools.getCookieHeaderValue(c10));
        }
        cookieEnum = this.userCookies.elements();
        while (cookieEnum.hasMoreElements()) {
            c10 = (Cookie)cookieEnum.nextElement();
            this.headers.putHeader(CookieTools.getCookieHeaderName(c10), CookieTools.getCookieHeaderValue(c10));
        }
    }

    public void recycle() {
        super.recycle();
        this.rout.recycle();
        this.out = this.rout;
    }

    public void writeHeaders() throws IOException {
        if (this.omitHeaders) {
            return;
        }
        this.fixHeaders();
        byte[] buff = this.proto.buff;
        buff[0] = 65;
        buff[1] = 66;
        int pos = 0;
        int count = this.headers.size();
        BuffTool.addInt(buff, 4, 2);
        BuffTool.addInt(buff, 6, count);
        pos = 8;
        Enumeration e10 = this.headers.names();
        while (e10.hasMoreElements()) {
            String headerName = (String)e10.nextElement();
            String headerValue = this.headers.getHeader(headerName);
            pos = BuffTool.addString(buff, pos, headerName);
            pos = BuffTool.addString(buff, pos, headerValue);
        }
        BuffTool.addInt(buff, 2, pos - 4);
        this.proto.out.write(buff, 0, pos);
    }
}

