/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.service.connector;

import java.io.IOException;
import java.util.Enumeration;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.service.connector.ConnectorServletOS;
import org.apache.tomcat.service.connector.MsgBuffer;
import org.apache.tomcat.service.connector.MsgConnector;

public class ConnectorResponse
extends Response {
    public static final int SEND_HEADERS = 2;
    public static final int END_RESPONSE = 5;
    MsgConnector con;
    ConnectorServletOS rout;

    public ConnectorResponse(MsgConnector con) {
        this.con = con;
        this.rout = new ConnectorServletOS(con);
        this.rout.setResponse(this);
        this.out = this.rout;
    }

    public void endResponse() throws IOException {
        MsgBuffer msg = this.con.getMsgBuffer();
        msg.reset();
        msg.appendInt(5);
        msg.end();
        this.con.send(msg);
    }

    public void recycle() {
        super.recycle();
        this.rout.recycle();
        this.rout = new ConnectorServletOS(this.con);
        this.rout.setResponse(this);
        this.out = this.rout;
    }

    public void writeHeaders() throws IOException {
        if (this.omitHeaders) {
            return;
        }
        this.fixHeaders();
        MsgBuffer msg = this.con.getMsgBuffer();
        msg.reset();
        msg.appendInt(2);
        msg.appendInt(this.headers.size());
        Enumeration e10 = this.headers.names();
        while (e10.hasMoreElements()) {
            String headerName = (String)e10.nextElement();
            String headerValue = this.headers.getHeader(headerName);
            msg.appendString(headerName);
            msg.appendString(headerValue);
        }
        msg.end();
        this.con.send(msg);
    }
}

