/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.tomcat.util.URLResourceReader;

public class NetworkClassLoader
extends ClassLoader {
    private ClassLoader parent = null;
    private Hashtable classCache = new Hashtable();
    private Hashtable urlset = new Hashtable();

    public NetworkClassLoader(ClassLoader parent) {
        this.setParent(parent);
    }

    public synchronized void addURL(URL url) {
        if (!this.urlset.containsKey(url)) {
            try {
                this.urlset.put(url, new URLResourceReader(url));
            }
            catch (IOException iOException) {}
        } else {
            try {
                URLResourceReader newu = new URLResourceReader(url);
                URLResourceReader oldu = (URLResourceReader)this.urlset.get(url);
                oldu.close();
                this.urlset.remove(url);
                this.urlset.put(url, newu);
            }
            catch (IOException iOException) {}
        }
    }

    protected final void clear() {
        this.urlset.clear();
        this.classCache.clear();
    }

    protected Class defineClass(String classname, byte[] classdata) {
        return this.defineClass(classname, classdata, 0, classdata.length);
    }

    protected void finalize() throws Throwable {
        this.clear();
        this.parent = null;
        this.urlset = null;
        this.classCache = null;
    }

    public InputStream getResourceAsStream(String name) {
        InputStream istream = null;
        istream = ClassLoader.getSystemResourceAsStream(name);
        if (istream != null) {
            return istream;
        }
        if (this.parent != null && (istream = this.parent.getResourceAsStream(name)) != null) {
            return istream;
        }
        byte[] data = this.loadResource(name);
        if (data != null) {
            istream = new ByteArrayInputStream(data);
        }
        return istream;
    }

    public Enumeration getURLs() {
        return this.urlset.keys();
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object var5_4;
        Class c10 = null;
        try {
            try {
                c10 = this.findSystemClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            var5_4 = null;
            if (c10 != null) {
                return c10;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (c10 != null) {
                return c10;
            }
            throw throwable;
        }
        try {
            try {
                if (this.parent != null) {
                    c10 = this.parent.loadClass(name);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            var5_4 = null;
            if (c10 != null) {
                return c10;
            }
        }
        catch (Throwable throwable) {
            var5_4 = null;
            if (c10 != null) {
                return c10;
            }
            throw throwable;
        }
        c10 = (Class)this.classCache.get(name);
        if (c10 != null) {
            return c10;
        }
        byte[] data = this.loadClassData(name);
        if (data != null) {
            c10 = this.defineClass(name, data);
            this.classCache.put(name, c10);
            if (resolve) {
                this.resolveClass(c10);
            }
        } else {
            throw new ClassNotFoundException(name);
        }
        return c10;
    }

    private byte[] loadClassData(String classname) {
        String resourceName = String.valueOf(classname.replace('.', '/')) + ".class";
        return this.loadResource(resourceName);
    }

    /*
     * Exception decompiling
     */
    private byte[] loadResource(String resource) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Missing node tying up JSR block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.tieUpRelations(Op02WithProcessedDataAndRefs.java:2900)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.copyBlock(Op02WithProcessedDataAndRefs.java:2889)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.inlineJSR(Op02WithProcessedDataAndRefs.java:2845)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSRs(Op02WithProcessedDataAndRefs.java:2591)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSR(Op02WithProcessedDataAndRefs.java:2481)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:444)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private byte[] loadResource(URL url, String resourceName) throws IOException {
        URLResourceReader urr = (URLResourceReader)this.urlset.get(url);
        if (urr != null) {
            return urr.getResource(resourceName);
        }
        return null;
    }

    protected final void setParent(ClassLoader parent) {
        this.parent = parent;
    }
}

