/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.pattern;

import org.apache.tomcat.util.pattern.Implication;

public class WildcardPattern
implements Implication {
    public static String WILDCARD = "*";
    private String pattern;

    public WildcardPattern(String pattern) {
        this.pattern = pattern;
    }

    public boolean equals(Object other) {
        if (other instanceof WildcardPattern) {
            WildcardPattern o2 = (WildcardPattern)other;
            return this.pattern.equals(o2.pattern);
        }
        return this.pattern.equals(other.toString());
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    public boolean implies(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof WildcardPattern) {
            WildcardPattern o2 = (WildcardPattern)other;
            return this.implies(o2.pattern);
        }
        return this.impliesCheck(other.toString());
    }

    private boolean impliesCheck(String str) {
        if (this.pattern.equals(str)) {
            return true;
        }
        int indx = this.pattern.lastIndexOf(WILDCARD);
        if (indx != -1) {
            String prematch = this.pattern.substring(0, indx);
            String postmatch = this.pattern.substring(indx + WILDCARD.length());
            if (str.startsWith(prematch) && str.endsWith(postmatch)) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.pattern;
    }
}

