/*
 * Decompiled with CFR 0.152.
 */
package iDSS.sm;

import iDSS.beans2.SurvivalModelsListJBean;
import iDSS.disp.DisplayFrame;
import iDSS.sm.SurvivalModel;
import iDSS.tables.GeneralTableModel;
import iDSS.utils.ConfigData;
import iDSS.utils.FileNameDialog;
import iDSS.utils.MessageHandler;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class SurvivalModelsList
extends DisplayFrame
implements ActionListener,
PropertyChangeListener {
    private JTable aTable;
    private JScrollPane aScrollPane;
    private JButton detailsButton;
    private JButton pickFromFileButton;
    private JButton selectAllButton;
    private JButton defineButton;
    private JButton pickAllButton;
    private JButton saveAllButton;
    private JComboBox defineCombo;
    private JButton userSMButton;
    private JPanel buttonPanel;
    private JPanel buttonPanel2;
    private JPanel buttonPanel3;
    private boolean ALLOW_ROW_SELECTION = true;
    private Vector columnNames;
    private Vector rowsOfData;
    private String lcClass;
    private String currentSurvivalModelName;
    private JTextField floodLcTextField;
    private SurvivalModel currentSurvivalModel;
    private JComboBox classTypesCombo;
    private File currentPath;
    private final char backSlash = File.separatorChar;
    private final char foreSlash = (char)47;
    private File currentFile;
    private SurvivalModelsListJBean smListJBean = new SurvivalModelsListJBean();

    public SurvivalModelsList(String string) {
        super("Defined Survival Models", false, false, false, true, null);
        this.smListJBean.addPropertyChangeListener(this);
        this.columnNames = this.smListJBean.getColumnNames();
        Vector vector = new Vector();
        GeneralTableModel generalTableModel = new GeneralTableModel(vector, this.columnNames);
        this.aTable = new JTable(generalTableModel);
        this.aTable.setPreferredScrollableViewportSize(new Dimension(50, 75));
        this.aTable.setSelectionMode(0);
        this.aScrollPane = new JScrollPane(this.aTable);
        this.detailsButton = new JButton("Details");
        this.pickFromFileButton = new JButton("From file");
        this.selectAllButton = new JButton("Select All");
        this.defineButton = new JButton("Define");
        this.pickAllButton = new JButton("Pick All from File");
        this.saveAllButton = new JButton("Save All to File");
        this.detailsButton.addActionListener(this);
        this.pickFromFileButton.addActionListener(this);
        this.selectAllButton.addActionListener(this);
        this.defineButton.addActionListener(this);
        this.pickAllButton.addActionListener(this);
        this.saveAllButton.addActionListener(this);
        this.detailsButton.setActionCommand("details");
        this.pickFromFileButton.setActionCommand("pickFromFile");
        this.selectAllButton.setActionCommand("selectAll");
        this.defineButton.setActionCommand("define");
        this.pickAllButton.setActionCommand("pickAllFromFile");
        this.saveAllButton.setActionCommand("saveAllToFile");
        this.detailsButton.setEnabled(false);
        this.pickFromFileButton.setEnabled(true);
        this.selectAllButton.setEnabled(false);
        this.defineButton.setEnabled(true);
        this.pickAllButton.setEnabled(true);
        this.saveAllButton.setEnabled(true);
        this.classTypesCombo = new JComboBox();
        this.defineCombo = new JComboBox(this.smListJBean.getSmModelNames());
        this.userSMButton = new JButton("Get User Defined Models");
        this.userSMButton.setActionCommand("getUserSMButtonCommand");
        this.userSMButton.addActionListener(this);
        this.buttonPanel = new JPanel();
        this.buttonPanel.add(this.detailsButton);
        this.buttonPanel.add(this.pickFromFileButton);
        this.buttonPanel.add(this.classTypesCombo);
        this.buttonPanel.add(this.defineButton);
        this.buttonPanel2 = new JPanel();
        this.buttonPanel2.add(this.userSMButton);
        this.buttonPanel2.add(this.defineCombo);
        this.buttonPanel3 = new JPanel();
        this.buttonPanel3.add(this.selectAllButton);
        this.buttonPanel3.add(this.pickAllButton);
        this.buttonPanel3.add(this.saveAllButton);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(this.aScrollPane);
        this.getContentPane().add(this.buttonPanel);
        this.getContentPane().add(this.buttonPanel2);
        this.getContentPane().add(this.buttonPanel3);
        this.pack();
        this.setVisible(true);
        if (this.ALLOW_ROW_SELECTION) {
            ListSelectionModel listSelectionModel = this.aTable.getSelectionModel();
            listSelectionModel.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (listSelectionEvent.getValueIsAdjusting()) {
                        return;
                    }
                    ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                    if (listSelectionModel.isSelectionEmpty()) {
                        System.out.println("No rows are selected.");
                        SurvivalModelsList.this.detailsButton.setEnabled(false);
                    } else {
                        int n = listSelectionModel.getMinSelectionIndex();
                        System.out.println("Row " + n + " is now selected.");
                        SurvivalModelsList.this.detailsButton.setEnabled(true);
                        SurvivalModelsList.this.lcClass = (String)SurvivalModelsList.this.aTable.getValueAt(n, 0);
                        SurvivalModelsList.this.classTypesCombo.setSelectedItem(SurvivalModelsList.this.lcClass);
                        SurvivalModelsList.this.currentSurvivalModelName = (String)SurvivalModelsList.this.aTable.getValueAt(n, 1);
                    }
                }
            });
        } else {
            this.aTable.setRowSelectionAllowed(false);
        }
    }

    public void setClassTypes(Vector vector) {
        if (vector != null) {
            this.classTypesCombo.removeAllItems();
            int n = 0;
            while (n < vector.size()) {
                String string = (String)vector.elementAt(n);
                this.classTypesCombo.addItem(string);
                ++n;
            }
            this.smListJBean.setClassTypes(vector);
        }
    }

    public String getCurrentClassType() {
        String string = (String)this.classTypesCombo.getSelectedItem();
        return string;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("details")) {
            SurvivalModel survivalModel = this.smListJBean.showDetails(this.getCurrentClassType(), false);
            if (survivalModel != null) {
                survivalModel.addPropertyChangeListener(this);
                this.firePropertyChange("addToModelView", null, survivalModel.showDetails(false));
            } else {
                JOptionPane.showMessageDialog(null, "Specified file is not a Survival Model", "Error", 0);
            }
        } else if (actionEvent.getActionCommand().equals("define")) {
            String string = (String)this.defineCombo.getSelectedItem();
            SurvivalModel survivalModel = this.smListJBean.define(string);
            if (survivalModel != null) {
                survivalModel.addPropertyChangeListener(this);
                this.firePropertyChange("addToModelView", null, survivalModel.showDetails(true));
            }
        } else if (actionEvent.getActionCommand().equals("pickFromFile")) {
            String string;
            File file;
            System.out.println("pick from file clicked");
            String string2 = (String)this.classTypesCombo.getSelectedItem();
            if (string2 != null && (file = FileNameDialog.getInputFileName(string = "SurvivalModel: Class " + string2, this.currentPath, null)) != null) {
                System.out.println("inFile.toString() : " + file.toString());
                String string3 = file.toString();
                this.addToTable(string2, string3);
                this.smListJBean.addToHashtable(string2, string3);
                this.currentPath = file.getParentFile();
            }
        } else if (actionEvent.getActionCommand().equals("saveAllToFile")) {
            System.out.println("select clicked");
            this.saveSurvivalModels();
        } else if (actionEvent.getActionCommand().equals("selectAll")) {
            Hashtable hashtable = this.smListJBean.getSurvivalModels();
            this.firePropertyChange("setAllSurvivalModels", null, hashtable);
        } else if (actionEvent.getActionCommand().equals("pickAllFromFile")) {
            this.pickAll();
        } else if (actionEvent.getActionCommand().equals("getUserSMButtonCommand")) {
            File file = FileNameDialog.getInputFileName("Select User SM File", null, null);
            Vector vector = new Vector();
            if (file != null && (vector = ConfigData.readProperties(file)) != null) {
                String string;
                int n = 0;
                while (n < vector.size()) {
                    string = (String)vector.elementAt(n);
                    this.defineCombo.addItem(string);
                    ++n;
                }
                string = ".";
                File file2 = file.getParentFile();
                if (file2 != null) {
                    string = file2.toString();
                }
                System.out.println("SurvivalModelsList.actionPerformed(), smpath: " + string);
                ConfigData.addToClassPath(string);
                this.smListJBean.addCustomClasses(string, vector);
            }
        }
    }

    private void pickAll() {
        File file = FileNameDialog.getInputFileName("Pick All from File", null, null);
        if (file != null) {
            Serializable serializable;
            Object object;
            Object object2;
            Hashtable hashtable = this.smListJBean.pickAll(file);
            Vector<Serializable> vector = new Vector<Serializable>();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                object2 = (String)enumeration.nextElement();
                object = (String)hashtable.get(object2);
                serializable = new Vector();
                ((Vector)serializable).add(object2);
                ((Vector)serializable).add(object);
                vector.add(serializable);
                System.out.println((String)object2 + "\t" + (String)object);
            }
            object2 = (GeneralTableModel)this.aTable.getModel();
            object = ((GeneralTableModel)object2).getColumns();
            serializable = new GeneralTableModel(vector, (Vector)object);
            this.aTable.setModel((TableModel)((Object)serializable));
            if (hashtable.size() >= this.classTypesCombo.getItemCount()) {
                this.selectAllButton.setEnabled(true);
            } else {
                this.selectAllButton.setEnabled(false);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object;
        if (propertyChangeEvent.getPropertyName().equals("setSurvivalModel")) {
            object = (SurvivalModel)propertyChangeEvent.getNewValue();
            JOptionPane.showMessageDialog(null, "Reached propertyChange method with a " + object.getName(), "Information", 1);
            if (object != null && object instanceof SurvivalModel) {
                JOptionPane.showMessageDialog(null, "Successfully received Survivalodel", "Information", 1);
                this.setNewSurvivalModel((SurvivalModel)object, this.getCurrentClassType());
            } else {
                JOptionPane.showMessageDialog(null, "Failed to receive Survivalodel", "Error", 0);
            }
        }
        if (propertyChangeEvent.getPropertyName().equals("addToModelView")) {
            this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
        if (propertyChangeEvent.getPropertyName().equals("removeFromModelView")) {
            this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
        if (propertyChangeEvent.getPropertyName().equals("showMessage")) {
            object = (Vector)propertyChangeEvent.getNewValue();
            MessageHandler.showMessage((Vector)object);
        }
    }

    public void addToTable(String string, String string2) {
        Object object;
        Serializable serializable;
        if (this.smListJBean.containsClass(string)) {
            System.out.println("Removing... " + string + " from survivalModelsHashtable");
            serializable = new Vector();
            ((Vector)serializable).add(string);
            object = this.smListJBean.getSurvivalModel(string);
            ((Vector)serializable).add(object);
            GeneralTableModel generalTableModel = (GeneralTableModel)this.aTable.getModel();
            generalTableModel.removeRow((Vector)serializable);
            this.aTable.setModel(generalTableModel);
            this.smListJBean.removeFromHashtable(string);
        }
        this.smListJBean.addToHashtable(string, string2);
        serializable = (GeneralTableModel)this.aTable.getModel();
        object = new Vector<String>();
        ((Vector)object).add(string);
        ((Vector)object).add(string2);
        ((GeneralTableModel)serializable).addRow((Vector)object);
        this.aTable.setModel((TableModel)((Object)serializable));
        this.saveAllButton.setEnabled(true);
        if (this.smListJBean.getHashtableSize() >= this.classTypesCombo.getItemCount()) {
            this.selectAllButton.setEnabled(true);
        } else {
            this.selectAllButton.setEnabled(false);
        }
    }

    private void saveSurvivalModels() {
        File file = FileNameDialog.getOutputFileName("Save", null, null);
        boolean bl = false;
        if (file != null) {
            bl = this.smListJBean.saveSurvivalModels(file);
        }
        if (bl) {
            JOptionPane.showMessageDialog(null, "Models saved in " + file.toString(), "Information", 1);
        } else {
            JOptionPane.showMessageDialog(null, "Models not saved", "Warning", 2);
        }
    }

    public void setNewSurvivalModel(SurvivalModel survivalModel, String string) {
        File file = FileNameDialog.getOutputFileName("Save", null, null);
        if (file != null) {
            boolean bl = this.smListJBean.setNewSurvivalModel(file, survivalModel);
            if (bl) {
                String string2 = file.toString();
                this.addToTable(string, string2);
                this.smListJBean.addToHashtable(string, string2);
            }
        } else {
            JOptionPane.showMessageDialog(null, "Model not saved", "Warning", 2);
        }
    }
}

