/*
 * Decompiled with CFR 0.152.
 */
package iDSS.webBeans;

import iDSS.beans.UserJBean;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Vector;

public class LogJBean
implements Serializable,
PropertyChangeListener {
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private UserJBean userJBean = new UserJBean();
    private Timestamp logOnTime;
    private Timestamp logOffTime;

    public LogJBean() {
        this.userJBean.addPropertyChangeListener(this);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public boolean logOn(String string) {
        boolean bl = true;
        if (string != null) {
            this.logOnTime = new Timestamp(System.currentTimeMillis());
            bl = this.userJBean.findByPrimaryKey(string);
            if (!bl) {
                String string2 = "LogJBean.logOn(), no user found with email " + string;
                Vector<Object> vector = new Vector<Object>();
                vector.add("No such user");
                vector.add(string2);
                vector.add(new Integer(0));
                this.pcs.firePropertyChange("showMessage", null, vector);
                System.out.println(string2);
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean register(String string, String string2) {
        long l;
        boolean bl = true;
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        boolean bl2 = this.userJBean.create(string, string2, timestamp, l = 0L);
        if (bl2) {
            boolean bl3 = this.logOn(string2);
            if (!bl3) {
                bl = false;
            }
        } else {
            bl2 = false;
            bl = false;
            String string3 = "LogJBean.register(), failed to create user for " + string2;
            Vector<Object> vector = new Vector<Object>();
            vector.add("Registration failed");
            vector.add(string3);
            vector.add(new Integer(0));
            this.pcs.firePropertyChange("showMessage", null, vector);
            System.out.println(string3);
        }
        return bl;
    }

    public boolean logOff() {
        boolean bl = true;
        this.logOffTime = new Timestamp(System.currentTimeMillis());
        long l = this.userJBean.getTotalTimeSpent() + ((Date)this.logOffTime).getTime() - ((Date)this.logOnTime).getTime();
        this.userJBean.setTotalTimeSpent(l);
        this.userJBean.setLastVisited(this.logOffTime);
        return bl;
    }

    public UserJBean getUser() {
        return this.userJBean;
    }

    public static void main(String[] stringArray) {
        LogJBean logJBean = new LogJBean();
        String string = "sayeed@strath";
        boolean bl = logJBean.register("Sayeed Ahmed", string);
        if (bl) {
            System.out.println("registered successfully!");
            UserJBean userJBean = logJBean.getUser();
            System.out.println("Name           : " + userJBean.getName());
            System.out.println("Email          : " + userJBean.getEmail());
            System.out.println("LastVisited    : " + userJBean.getLastVisited());
            System.out.println("TotalTimeSpent : " + userJBean.getTotalTimeSpent());
        } else {
            System.out.println("Not registered email " + string + "!");
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }
}

