/*
 * Decompiled with CFR 0.152.
 */
package iDSS.xyGraph;

import iDSS.disp.DisplayFrame;
import iDSS.gridDisp.DrawingPanel2;
import iDSS.xyGraph.Graph;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.event.InternalFrameEvent;

public class GraphicalDisplay2
extends DisplayFrame {
    private DrawingPanel2 aCanvas;
    private JScrollPane aScrollPane;
    private String graphTitle;
    private Vector graphs;
    private Graph parentGraph = null;
    private String key;

    public GraphicalDisplay2(int n, int n2) {
        super("Graphical View", true, true, true, true, null);
        this.setPreferredSize(new Dimension(n, n2));
        this.aCanvas = new DrawingPanel2(n, n2, this);
        this.aScrollPane = new JScrollPane(this.aCanvas);
        this.getContentPane().add(this.aScrollPane);
        this.pack();
        this.setVisible(true);
    }

    public GraphicalDisplay2(String string, int n, int n2) {
        super(string, true, true, true, true, null);
        this.key = string;
        this.setPreferredSize(new Dimension(n, n2));
        this.aCanvas = new DrawingPanel2(n, n2, this);
        this.aScrollPane = new JScrollPane(this.aCanvas);
        this.getContentPane().add(this.aScrollPane);
        this.pack();
        this.setVisible(true);
    }

    public void setParentGraph(Graph graph) {
        this.parentGraph = graph;
    }

    public void resizeCanvas() {
        this.firePropertyChange("drawGraph", new Integer(0), new Integer(1));
    }

    public void addGraph(Graph graph) {
    }

    public int getCanvasX() {
        int n = this.aCanvas.getCanvasX();
        System.out.println("GraphicalDisplay2:getCanvasX() = " + n);
        return n;
    }

    public int getCanvasY() {
        int n = this.aCanvas.getCanvasY();
        System.out.println("GraphicalDisplay2:getCanvasY() = " + n);
        return n;
    }

    public BufferedImage getCanvas() {
        System.out.println("GraphicalDisplay2:getCanvas()");
        BufferedImage bufferedImage = this.aCanvas.getCanvas();
        System.out.println("returned from DrawingPanel2:getCanvas()");
        return bufferedImage;
    }

    public void refreshCanvas(BufferedImage bufferedImage) {
        this.aCanvas.refreshCanvas(bufferedImage);
    }

    public void drawXYGraph(String string, double[] dArray, double[] dArray2) {
        this.graphTitle = this.graphTitle + string;
        this.setTitle(this.graphTitle);
        this.aCanvas.drawXYGraph(dArray, dArray2);
    }

    public void clearBuffer() {
        this.aCanvas.clearBuffer();
    }

    public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
        this.firePropertyChange("internalFrameClosing", null, this.key);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("GraphicalDisplay test");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        GraphicalDisplay2 graphicalDisplay2 = new GraphicalDisplay2(300, 200);
        JDesktopPane jDesktopPane = new JDesktopPane();
        jDesktopPane.putClientProperty("JDesktopPane.dragMode", "outline");
        jDesktopPane.add(graphicalDisplay2);
        jFrame.setContentPane(jDesktopPane);
        jFrame.pack();
        ((Component)jFrame).setSize(500, 400);
        ((Component)jFrame).setVisible(true);
        double[] dArray = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0};
        double[] dArray2 = new double[]{0.0, 1.0, 4.0, 9.0, 16.0, 25.0};
        graphicalDisplay2.drawXYGraph("Graph view", dArray, dArray2);
    }
}

