/*
 * @(#)PlayElement.java	1.13 99/02/19
 *
 * Copyright (c) 1998-1999 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Sun grants you ("Licensee") a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Sun.
 *
 * This software is provided "AS IS," without a warranty of any kind. ALL
 * EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
 * IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE
 * LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
 * OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS
 * LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
 * INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
 * CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
 * OR INABILITY TO USE SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *
 * This software is not designed or intended for use in on-line control of
 * aircraft, air traffic, aircraft navigation or aircraft communications; or in
 * the design, construction, operation or maintenance of any nuclear
 * facility. Licensee represents and warrants that it will not use or
 * redistribute the Software for such purposes.
 */

package project;

import java.io.IOException;
import java.io.Writer;

import com.sun.xml.tree.*;

import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;


public class PlayElement extends TitledElement
{
    private ElementNode	fm, personae, scndescr, playsubt;
    
    public PlayElement () { }

    /**
     * Write out this node's children, including the TITLE, FM, PERSONAE,
     * SCNDESCR, and PLAYSUBT elements which are currently hidden.
     */
    public void writeChildrenXml (XmlWriteContext context) throws IOException
    {
	Writer out = context.getWriter ();

	context.printIndent ();
	out.write ("<TITLE>");
	out.write (getTitle ());
	out.write ("</TITLE>");

	fm.writeXml (context);
	personae.writeXml (context);
	scndescr.writeXml (context);
	playsubt.writeXml (context);

	for (int i = 0; item (i) != null; i++)
	    ((ElementNode)item (i)).writeXml (context);

	out.write ("\n");
    }
    
    /**
     * Prune out various play elements we don't really want
     * to be displaying though swing.JTree ...
     */
    public Node appendChild (Node n)
    throws DOMException
    {
	if (n instanceof ElementNode) {
	    if ("FM".equals (n.getNodeName ())) {
		fm = (ElementNode) n;
		return n;
	    } else if ("PERSONAE".equals (n.getNodeName ())) {
		personae = (ElementNode) n;
		return n;
	    } else if ("SCNDESCR".equals (n.getNodeName ())) {
		scndescr = (ElementNode) n;
		return n;
	    } else if ("PLAYSUBT".equals (n.getNodeName ())) {
		playsubt = (ElementNode) n;
		return n;
	    } 
	}
	return super.appendChild (n);
    }
}
