/*
 * @(#)TitledElement.java	1.15 99/02/19
 *
 * Copyright (c) 1998-1999 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Sun grants you ("Licensee") a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Sun.
 *
 * This software is provided "AS IS," without a warranty of any kind. ALL
 * EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
 * IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE
 * LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
 * OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS
 * LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
 * INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
 * CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
 * OR INABILITY TO USE SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *
 * This software is not designed or intended for use in on-line control of
 * aircraft, air traffic, aircraft navigation or aircraft communications; or in
 * the design, construction, operation or maintenance of any nuclear
 * facility. Licensee represents and warrants that it will not use or
 * redistribute the Software for such purposes.
 */

package project;

import java.io.IOException;
import java.io.Writer;

import com.sun.xml.tree.NodeEx;
import com.sun.xml.tree.ParseContext;
import com.sun.xml.tree.XmlReadable;
import com.sun.xml.tree.XmlWriteContext;

import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;


/**
 * Base class for elements which have titles which are used in
 * their TreeNode displays:  PLAY, ACT, SCENE, plus the less
 * often used INDUCT, PROLOGUE, and EPILOGUE.
 *
 * <P> Title nodes are not exposed as DOM children of this kind of
 * element; when the element is printed the TITLE tag appears.
 */
public class TitledElement extends ProjectElement
{
    private String      title;
    
    public TitledElement () { }
    
    public String getTitle () { return title; }

    public void setTitle (String t) { title = t; }
    
    public String toString () { return title; }
    
    public void doneChild (NodeEx n, ParseContext context)
    throws DOMException
    {
	if (title == null && n.getNodeType () == ELEMENT_NODE) {
	    if ("TITLE".equals (n.getNodeName ())) {
		Node child;

		((Element)n).normalize ();
		child =  n.getFirstChild ();
		title = child.getNodeValue ();
		removeChild (n);
	    }
	}
    }

    /**
     * Write out this node's children, including the TITLE
     * element which is currently hidden.
     */
    public void writeChildrenXml (XmlWriteContext context) throws IOException
    {
	Writer	out = context.getWriter ();

	out.write ("\n<TITLE>");
	out.write (getTitle ());
	out.write ("</TITLE>\n");
	super.writeChildrenXml (context);
    }
    
}
