package iDSS;

import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import javax.swing.event.*;

import iDSS.utils.*;
import iDSS.disp.*;





public class VerticalSlider extends DisplayFrame implements ChangeListener,ActionListener {

    private JTextField sliderLabel;
    private JTextField movementLabel;
    private JSlider slider;
    private String units;
    private JTextField dependentTextField;
    private JButton selectButton;




    public VerticalSlider (String title,int min, int max, int value,String unitString,JTextField textField) {

        //super (title,false,true,false,true,null);
        super (title,true,false,false,true,null);    //same thing, but resizable

        setBackground(Color.lightGray);

        slider = new JSlider(JSlider.VERTICAL,min,max,value);
        units = unitString;

        if (textField != null)
            dependentTextField = textField;

        slider.setMajorTickSpacing((max-min)/5);
        slider.setMinorTickSpacing((max-min)/100);
        slider.setPaintTicks(true);
        slider.setPaintLabels(true);
        slider.setSnapToTicks(true);
        slider.addChangeListener(this);

        slider.setAlignmentY(10);

        sliderLabel = new JTextField(title);
        movementLabel = new JTextField(Integer.toString(value)+ " " + units);

        sliderLabel.setHorizontalAlignment(JTextField.CENTER);
        movementLabel.setHorizontalAlignment(JTextField.CENTER);

        sliderLabel.setEditable(false);
        movementLabel.setEditable(false);

        selectButton = new JButton(IDSSAppConstants.selectButtonText);
        selectButton.addActionListener(this);
        selectButton.setActionCommand(IDSSAppConstants.selectButtonCommand);

        selectButton.setHorizontalTextPosition(SwingConstants.CENTER);
        selectButton.setHorizontalAlignment(SwingConstants.CENTER);

        getContentPane().setLayout(new BoxLayout(getContentPane(),BoxLayout.Y_AXIS));
        getContentPane().add(sliderLabel);
        getContentPane().add(slider);
        getContentPane().add(movementLabel);
        getContentPane().add(selectButton);

        pack();
        setVisible(true);


        //This is to solve a bug thst JSliders don't appear in JInternalFrame
        Dimension dim = this.getSize();
        if (dim.height > 5) {
            dim.height = dim.height-5;
            this.setSize(dim);
        }
        //This is to solve a bug thst JSliders don't appear in JInternalFrame - end

    }//public VerticalSlider (int width, int height, String url)








    public void actionPerformed(ActionEvent e) {


        if(e.getActionCommand().equals(IDSSAppConstants.selectButtonCommand)) {

            firePropertyChange(IDSSAppConstants.setIsostaticMovement,null,new Integer(slider.getValue()));

        } //if(e.getActionCommand().equals(IDSSAppConstants.selectButtonCommand))

    } //public void actionPerformed(ActionEvent e)






    public void stateChanged(ChangeEvent ce) {

        if (ce.getSource() == slider) {

            if (slider.getValueIsAdjusting()) {      //slider is being dragged

                int sliderValue = slider.getValue();
                movementLabel.setText(Integer.toString(sliderValue) + " " + units);
                if (dependentTextField != null)
                    dependentTextField.setText(Integer.toString(sliderValue) + " " + units);

            } //if (dataModelIterationsSlider.getValueIsAdjusting())
            

        } //if (ce.getSource() == dataModelIterationsSlider)

    } //public void stateChanged(ChangeEvent e)










    public static void main(String args[]) {

        JFrame aFrame = new JFrame("Canvas test");

        aFrame.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent we) {
                System.exit(0);
            }
        });


        VerticalSlider aWin = new VerticalSlider ("Select Isostatic\nMovement",-50,50,0, "mm/year",null);

        JDesktopPane dPane = new JDesktopPane();

        dPane.putClientProperty("JDesktopPane.dragMode", "outline");
        dPane.add(aWin);
        aFrame.setContentPane(dPane);

        aFrame.pack();
        aFrame.setSize(600,500);
        aFrame.setVisible(true);

    }//main()


}
