package iDSS.beans;

import java.io.*;
import java.beans.*;
import java.sql.Timestamp;
import java.util.*;
import java.util.Properties; 

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;



import java.rmi.RemoteException;


import iDSS.*;
import iDSS.utils.*;

//Serverside packages

import ejb.slrStory.*;



public class SLRStoryJBean implements Serializable {


    private PropertyChangeSupport pcs;
    private String ejbName;

    private SLRStoryHome slrStoryHome;
    private SLRStory slrStory;



    public SLRStoryJBean() {

        pcs = new PropertyChangeSupport(this);

    } //public SLRStoryJBean()



    public void addPropertyChangeListener(PropertyChangeListener l) {

        pcs.addPropertyChangeListener(l);

    } //public void addPropertyChangeListener(PropertyChangeListener l)




    public void removePropertyChangeListener(PropertyChangeListener l) {

        pcs.removePropertyChangeListener(l);

    } //public void removePropertyChangeListener(PropertyChangeListener l)






    public String getEjbName() {

        return ejbName;

    }//public String getEjbName()




    public void setEjbName(String s) {

        try {
            ejbName = s;

            if(IDSSAppConstants.debug) {
                System.out.println("SLRStoryJBean.setEjbName(), ejbName = " + ejbName);
            }//if(IDSSAppConstants.debug)


            Properties props = new Properties(); 
            props.put(Context.DNS_URL, IDSSAppConstants.serverURL);
            Context initial = new InitialContext(props);


            Object objref = initial.lookup(ejbName);
            slrStoryHome = (SLRStoryHome)PortableRemoteObject.narrow(objref,SLRStoryHome.class);
        } //try

        catch(Exception ex) {
            System.out.println("SLRStoryJBean.setEjbName(), Caught an exception");
            ex.printStackTrace();
        } //catch();

    }//public void setEjbName()




    public StringBuffer getContents(String url) {

        StringBuffer s = null;

        try {

            SLRStory slrStory = slrStoryHome.create();
            s = slrStory.getContents(url);

        } //try

        catch (Exception ex) {

            System.err.println("SLRStoryJBean.getContents(), Caught an exception." );
            ex.printStackTrace();

        } //catch (Exception ex)

        return s;

    } //public StringBuffer getContents()





}//public class SLRStoryJBean implements Serializable

