package iDSS.beans;

import java.io.*;
import java.beans.*;
import java.sql.Timestamp;
import java.util.*;
import java.util.Properties; 

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;



import java.rmi.RemoteException;


import iDSS.*;
import iDSS.utils.*;

//Serverside packages

import ejb.users.*;



public class UserJBean implements Serializable {


    private PropertyChangeSupport pcs;
    private String ejbName;

    private UserHome userHome;
    private User user;



    public UserJBean() {

        pcs = new PropertyChangeSupport(this);
        setEjbName(IDSSAppConstants.userBean);

    } //public UserJBean()



    public void addPropertyChangeListener(PropertyChangeListener l) {

        pcs.addPropertyChangeListener(l);

    } //public void addPropertyChangeListener(PropertyChangeListener l)




    public void removePropertyChangeListener(PropertyChangeListener l) {

        pcs.removePropertyChangeListener(l);

    } //public void removePropertyChangeListener(PropertyChangeListener l)





    public void setUser(User u) {

        user = u;

    } //



    public String getEjbName() {

        return ejbName;

    }//public String getEjbName()




    public void setEjbName(String s) {

        try {
            ejbName = s;

            if(IDSSAppConstants.debug) {
                System.out.println("UserJBean.setEjbName(), ejbName = " + ejbName);
            }//if(IDSSAppConstants.debug)


            Properties props = new Properties(); 
            props.put(Context.DNS_URL, IDSSAppConstants.serverURL);
            Context initial = new InitialContext(props);


            Object objref = initial.lookup(ejbName);
            userHome = (UserHome)PortableRemoteObject.narrow(objref,UserHome.class);
        } //try

        catch(Exception ex) {
            System.out.println("UserJBean.setEjbName(), Caught an exception");
            ex.printStackTrace();
        } //catch();

    }//public void setEjbName()




    public Vector findAll() {

        Vector v = new Vector();

        try {

            Collection c = userHome.findAll();
            Iterator i=c.iterator();

            while (i.hasNext()) {

                User u = (User)i.next();
                UserJBean uBean = new UserJBean();
                uBean.setUser(u);
                v.add(uBean);

            } //while (i.hasNext())

        } //try

        catch (Exception ex) {

            System.err.println("UserJBean.findAll(), caught an exception." );
            ex.printStackTrace();

        } //catch (Exception ex)

        return v;

    } //public Vector findAll()





    public boolean create(String name,String email,Timestamp lastVisited,long totalTimeSpent) {

        boolean success = false;

        try {

            boolean exists = findByPrimaryKey(email);

            if(!exists) {

                user = userHome.create(name,email,lastVisited,totalTimeSpent);
                success = true;

            } //if(user == null)

            else {

                success = false;
                String message = "UserJBean.create(), Email " + email + " is already in use!";

                Vector messageVector = new Vector();
                messageVector.add("Email in use");
                messageVector.add(message);
                messageVector.add(new Integer(IDSSAppConstants.errorMessage));
                pcs.firePropertyChange(IDSSAppConstants.showMessage,null,messageVector);

                System.out.println(message);

            } //else

        } //try

        catch(java.rmi.RemoteException e) {

            success = false;

            String message = "UserJBean.create(), " + e.toString();

            Vector messageVector = new Vector();
            messageVector.add("Remote exception");
            messageVector.add(message);
            messageVector.add(new Integer(IDSSAppConstants.errorMessage));
            pcs.firePropertyChange(IDSSAppConstants.showMessage,null,messageVector);

            System.out.println(message);

        } //

        catch(javax.ejb.CreateException e) {

            success = false;

            String message = "UserJBean.create(), " + e.toString();

            Vector messageVector = new Vector();
            messageVector.add("Create exception");
            messageVector.add(message);
            messageVector.add(new Integer(IDSSAppConstants.errorMessage));
            pcs.firePropertyChange(IDSSAppConstants.showMessage,null,messageVector);

            System.out.println(message);


        } //


        return success;

    } //public boolean create(String name,String email,Timestamp lastVisited,long totalTimeSpent)




    public boolean findByPrimaryKey(String email) {

        //Vector v = new Vector();
        boolean success = false;

        try {

            user = userHome.findByPrimaryKey(email);
            success = true;

        } //try

        catch(java.rmi.RemoteException e) {

            success = false;
            String message = "UserJBean.findByPrimaryKey(), " + e.toString();

            Vector messageVector = new Vector();
            messageVector.add("Remote exception");
            messageVector.add(message);
            messageVector.add(new Integer(IDSSAppConstants.errorMessage));
            pcs.firePropertyChange(IDSSAppConstants.showMessage,null,messageVector);

            System.out.println(message);

        } //


        catch(javax.ejb.FinderException e) {

            success = false;
            String message = "UserJBean.findByPrimaryKey(), " + e.toString();

            Vector messageVector = new Vector();
            messageVector.add("Finder exception");
            messageVector.add(message);
            messageVector.add(new Integer(IDSSAppConstants.errorMessage));
            pcs.firePropertyChange(IDSSAppConstants.showMessage,null,messageVector);

            System.out.println(message);

        } //


        return success;

    } //public boolean findByPrimaryKey(String email)



    

    public void setName(String s) {

        try {
            user.setName(s);
        } //try

        catch(java.rmi.RemoteException e) {

            String message = "UserJBean.setName(), " + e.toString();

            Vector messageVector = new Vector();
            messageVector.add("Remote exception");
            messageVector.add(message);
            messageVector.add(new Integer(IDSSAppConstants.errorMessage));
            pcs.firePropertyChange(IDSSAppConstants.showMessage,null,messageVector);

            System.out.println(message);

        } //

    } //public void setName(String s)





    public void setLastVisited(Timestamp t) {

        try {
            user.setLastVisited(t);
        } //try

        catch(java.rmi.RemoteException e) {

            String message = "UserJBean.setLastVisited(), " + e.toString();

            Vector messageVector = new Vector();
            messageVector.add("Remote exception");
            messageVector.add(message);
            messageVector.add(new Integer(IDSSAppConstants.errorMessage));
            pcs.firePropertyChange(IDSSAppConstants.showMessage,null,messageVector);

            System.out.println(message);

        } //

    } //public void setLastVisited(Timestamp t)



    public void setTotalTimeSpent(long t) {

        try {
            user.setTotalTimeSpent(t);
        } //try

        catch(java.rmi.RemoteException e) {

            String message = "UserJBean.setTotalTimeSpent(), " + e.toString();

            Vector messageVector = new Vector();
            messageVector.add("Remote exception");
            messageVector.add(message);
            messageVector.add(new Integer(IDSSAppConstants.errorMessage));
            pcs.firePropertyChange(IDSSAppConstants.showMessage,null,messageVector);

            System.out.println(message);

        } //

    } //public void setTotalTimeSpent(long t)




    public String getName() {

        String s = null;

        try {

            s = user.getName();

        } //try

        catch(java.rmi.RemoteException e) {

            String message = "UserJBean.getName(), " + e.toString();

            Vector messageVector = new Vector();
            messageVector.add("Remote exception");
            messageVector.add(message);
            messageVector.add(new Integer(IDSSAppConstants.errorMessage));
            pcs.firePropertyChange(IDSSAppConstants.showMessage,null,messageVector);

            System.out.println(message);

        } //

        return s;

    } //



    public String getEmail() {

        String s = null;

        try {
           s = user.getEmail();
        }

        catch(java.rmi.RemoteException e) {

            String message = "UserJBean.getEmail(), " + e.toString();

            Vector messageVector = new Vector();
            messageVector.add("Remote exception");
            messageVector.add(message);
            messageVector.add(new Integer(IDSSAppConstants.errorMessage));
            pcs.firePropertyChange(IDSSAppConstants.showMessage,null,messageVector);

            System.out.println(message);

        } //

        return s;

    } //



    public Timestamp getLastVisited() {

        Timestamp t = null;

        try {

            t = user.getLastVisited();

        } //try

        catch(java.rmi.RemoteException e) {

            String message = "UserJBean.getLastVisited(), " + e.toString();

            Vector messageVector = new Vector();
            messageVector.add("Remote exception");
            messageVector.add(message);
            messageVector.add(new Integer(IDSSAppConstants.errorMessage));
            pcs.firePropertyChange(IDSSAppConstants.showMessage,null,messageVector);

            System.out.println(message);

        } //

        return t;

    } //


    public long getTotalTimeSpent() {

        long l = 0;

        try {

            l = user.getTotalTimeSpent();

        } //

        catch(java.rmi.RemoteException e) {

            String message = "UserJBean.getTotalTimeSpent(), " + e.toString();

            Vector messageVector = new Vector();
            messageVector.add("Remote exception");
            messageVector.add(message);
            messageVector.add(new Integer(IDSSAppConstants.errorMessage));
            pcs.firePropertyChange(IDSSAppConstants.showMessage,null,messageVector);

            System.out.println(message);

        } //


        return l;

    } //





    public void remove() {


        try {
            user.remove();
        } //try


        catch(java.rmi.RemoteException e) {

            String message = "UserJBean.remove(), " + e.toString();

            Vector messageVector = new Vector();
            messageVector.add("Remote exception");
            messageVector.add(message);
            messageVector.add(new Integer(IDSSAppConstants.errorMessage));
            pcs.firePropertyChange(IDSSAppConstants.showMessage,null,messageVector);

            System.out.println(message);

        } //

        catch(javax.ejb.RemoveException e) {

            String message = "UserJBean.remove(), " + e.toString();

            Vector messageVector = new Vector();
            messageVector.add("RemoveException");
            messageVector.add(message);
            messageVector.add(new Integer(IDSSAppConstants.errorMessage));
            pcs.firePropertyChange(IDSSAppConstants.showMessage,null,messageVector);

            System.out.println(message);

        } //

    } //public void remove()



}//public class UserJBean implements Serializable

