package iDSS.beans2;

import java.beans.*;
import java.util.*;



import iDSS.utils.*;
import iDSS.disp.*;
import iDSS.grids.*;
import iDSS.tidalData.*;
import iDSS.beans2.*;





public class ModelSetupControllerJBean implements PropertyChangeListener {

    private Hashtable modelDataHashtable;
    private Hashtable tidalModelsHashtable;


    private PropertyChangeSupport pcs;
    private StatusJBean statusJBean;





    public ModelSetupControllerJBean() {


        modelDataHashtable = new Hashtable();
        tidalModelsHashtable = new Hashtable();
        modelDataHashtable.put(IDSSAppConstants.tidalModelsHashtableName,tidalModelsHashtable);

        pcs = new PropertyChangeSupport(this);

        statusJBean = new StatusJBean();


    } //public ModelSetupControllerJBean()



    public StatusJBean getStatusBean() {

        //pcs.firePropertyChange(IDSSAppConstants.setStatusBean,null,statusJBean);
        return statusJBean;

    } //public StatusJBean getStatusBean()




    public void addPropertyChangeListener(PropertyChangeListener l) {

        pcs.addPropertyChangeListener(l);

    } //public void addPropertyChangeListener(PropertyChangeListener l)




    public void removePropertyChangeListener(PropertyChangeListener l) {

        pcs.removePropertyChangeListener(l);

    } //public void removePropertyChangeListener(PropertyChangeListener l)









    public void propertyChange(PropertyChangeEvent evt) {



        if (evt.getPropertyName().equals(IDSSAppConstants.addGridToModel)) {

            Vector v = (Vector)evt.getNewValue();
            addGridToModel(v);


        } //if (evt.getPropertyName().equals(IDSSAppConstants.addGridToModel))




        if(evt.getPropertyName().equals(IDSSAppConstants.setTidalModel)) {

            Vector v = (Vector)evt.getNewValue();
            setTidalModel(v);

        } //if(evt.getPropertyName().equals(IDSSAppConstants.setTidalModel))



        if(evt.getPropertyName().equals(IDSSAppConstants.setAllTidalModels)) {

            Hashtable h = (Hashtable)evt.getNewValue();
            setAllTidalModels(h);

        } //if(evt.getPropertyName().equals(IDSSAppConstants.setAllTidalModels))



        if (evt.getPropertyName().equals(IDSSAppConstants.setIsostaticMovement)) {

            Integer isostaticMovement = (Integer)evt.getNewValue();
            setIsostaticMovement(isostaticMovement);


        } //if (evt.getPropertyName().equals(IDSSAppConstants.setIsostaticMovement))



        if (evt.getPropertyName().equals(IDSSAppConstants.setSLRScenario)) {

            ClientDataSet slrDataSet = (ClientDataSet)evt.getNewValue();

            setSLRScenario(slrDataSet);


        } //if (evt.getPropertyName().equals(IDSSAppConstants.setSLRScenario))




        if (evt.getPropertyName().equals(IDSSAppConstants.setAllSurvivalModels)) {

            Hashtable survivalModels = (Hashtable)evt.getNewValue();
            setAllSurvivalModels(survivalModels);

        } //if (evt.getPropertyName().equals(IDSSAppConstants.setAllSurvivalModels))





        if (evt.getPropertyName().equals(IDSSAppConstants.proceedWithSimulation)) {


            Vector v = new Vector();
            v.add("Simulation status message");
            v.add("ModelSetupControllerJBean.propertyChange(), "+IDSSAppConstants.proceedWithSimulation);
            v.add(new Integer(IDSSAppConstants.informationMessage));

            pcs.firePropertyChange(IDSSAppConstants.showMessage,null,v);

            proceedWithSimulation();

        } //if (evt.getPropertyName().equals(IDSSAppConstants.proceedWithSimulation))

    } //public void propertyChangeEvent(PropertyChangeEvent evt)







    public void addGridToModel(Vector v) {


        if(v != null) {

            String hashCode = (String)v.elementAt(0);
            Grid g = (Grid)v.elementAt(1);

            if(g != null) {

                if(hashCode.equals(IDSSAppConstants.lcGridName)) {

                    if(!g.isRead())
                        g.read();

                    Vector landClassesVector = g.getClasses();
                    pcs.firePropertyChange(IDSSAppConstants.setClassTypes,null,landClassesVector);
                    //smList.setClassTypes(landClassesVector);

                    statusJBean.setLcGrid(g.getGridVector().toString());

                } //if(hashCode.equals(IDSSAppConstants.lcGridName))


                else if(hashCode.equals(IDSSAppConstants.demGridName)) {

                    statusJBean.setDem(g.getGridVector().toString());

                } //else if(hashCode.equals(IDSSAppConstants.demGridName))


                modelDataHashtable.put(hashCode,g);
                System.out.println("ModelSetupControllerJBaen.addGridToModel(), hashCode : " + hashCode + ", name : " + g.getName());

            }//if(g != null)

        } //if(v != null)


        //Vector v2 = new Vector();
        //v2.add(hashCode);
        //v2.add(g);

        //firePropertyChange(evt.getPropertyName(),null,v2);


/**

        if(g != null) {

            modelDataHashtable.put(hashCode,g);
            System.out.println("ModelSetupControllerJBean.propertyChangeEvent(), gridName = " + g.getName());

        } //if(g != null)

        else {
            if(IDSSAppConstants.debug) {
                DebugWriter.writeDebug("ModelSetupControllerJBean.propertyChangeEvent(), grid = null, hashCode = " + hashCode);
                System.out.println("ModelSetupControllerJBean.propertyChangeEvent(), grid = null, hashCode = " + hashCode);
            } //if(IDSSAppConstants.debug)
        } //else

**/

    } //public void addGridToModel(Vector v)







    public void setTidalModel(Vector v) {

        String key = (String)v.elementAt(0);
        TidalModel tm = (TidalModel)v.elementAt(1);

        tidalModelsHashtable.put(key,tm);

    } //public void setTidalModel(Vector v)





    public void setAllTidalModels(Hashtable h) {

        tidalModelsHashtable = h;

        if(modelDataHashtable.containsKey(IDSSAppConstants.tidalModelsHashtableName)) {

            modelDataHashtable.remove(IDSSAppConstants.tidalModelsHashtableName);

        } //

        modelDataHashtable.put(IDSSAppConstants.tidalModelsHashtableName,tidalModelsHashtable);
        System.out.println("ModelSetupControllerJBean.setAllTidalModels(), " + 
                            "tidalModelsHashtable.size() : " + tidalModelsHashtable.size());

    } //public void setAllTidalModels(Hashtable h)





    public void setIsostaticMovement(Integer isostaticMovement) {

        modelDataHashtable.put(IDSSAppConstants.isostaticMovementHashCode,isostaticMovement);

    } //public void setIsostaticMovement(Integer isostaticMovement)







    public int getIsostaticMovement() {

        int iso = 0;

        if(modelDataHashtable.containsKey(IDSSAppConstants.isostaticMovementHashCode)) {

            iso = ((Integer)modelDataHashtable.get(IDSSAppConstants.isostaticMovementHashCode)).intValue();

        }

        return iso;

    } //public int getIsostaticMovement()







    public void setSLRScenario(ClientDataSet slrDataSet) {

        modelDataHashtable.put(IDSSAppConstants.slrDataHashCode,slrDataSet);

        System.out.println(
                "ModelSetupControllerJBean.propertyChangeEvent(), SLRScenario = " +
                        IDSSAppConstants.setSLRScenario + " done");

        System.out.println("ModelSetupControllerJBean.propertuChange(), slrDataSet.getStationName() : " + slrDataSet.getStationName());

        if(slrDataSet == null)
            System.out.println("slr is null");
        else
            System.out.println("slr is not null");


    } //public void setSLRScenario(ClientDataSet slrDataSet)







    public void setAllSurvivalModels(Hashtable survivalModels) {

        modelDataHashtable.put(IDSSAppConstants.smHashCode,survivalModels);

        System.out.println(
                "ModelSetupControllerJBean.propertyChangeEvent(), survivalModels = " +
                        IDSSAppConstants.smHashCode + " done");


    } //public void setAllSurvivalModels(Hashtable survivalModels)





    public void proceedWithSimulation() {

        Grid dem = (Grid)modelDataHashtable.get(IDSSAppConstants.demGridName);
        Grid lcGrid = (Grid)modelDataHashtable.get(IDSSAppConstants.lcGridName);
        Hashtable smHashtable = (Hashtable)modelDataHashtable.get(IDSSAppConstants.smHashCode);
        int isostatic = ((Integer)modelDataHashtable.get(IDSSAppConstants.isostaticMovementHashCode)).intValue();
        ClientDataSet slr = (ClientDataSet)modelDataHashtable.get(IDSSAppConstants.slrDataHashCode);

        System.out.println("ModelSetupControllerJBean.propertyChange(), Checking contents of modelDataHashtable");

        if(dem == null)
            System.out.println("demGrid is null");

        if(lcGrid == null)
            System.out.println("lcGrid is null");

        if(smHashtable == null)
            System.out.println("smHashtable is null");

        System.out.println("isostatic = " + isostatic);

        if(slr == null)
            System.out.println("slr is null");


        LCGrid2 lcGrid2 = new LCGrid2("Land Cover Details",null,lcGrid,smHashtable);

        Vector simVector = new Vector();
        simVector.add(dem);
        simVector.add(lcGrid2);
        simVector.add(tidalModelsHashtable);
        simVector.add(new Integer(isostatic));
        simVector.add(slr);

        pcs.firePropertyChange(IDSSAppConstants.createSimNode,null,simVector);

    } //public void proceedWithSimulation()







    public Vector getLandClasses() {

        Vector v = new Vector();
        Grid g = (Grid)modelDataHashtable.get(IDSSAppConstants.lcGridName);

        if(g != null) {
            v = g.getClasses();
        }

        return v;

    } //public Vector getLandClasses()






    public Hashtable getSurvivalModels() {

        Hashtable h = (Hashtable)modelDataHashtable.get(IDSSAppConstants.smHashCode);

        if(h== null) {
            h = new Hashtable();
        } //

        return h;

    } //public Hashtable getSurvivalModels()






    public Hashtable getModelSetup() {

        return modelDataHashtable;

    } //public Hashtable getModelSetup()





    public SimulationJBean getSimulationJBean() {

        SimulationJBean simJBean = new SimulationJBean();

        Grid dem = (Grid)modelDataHashtable.get(IDSSAppConstants.demGridName);
        Grid lcGrid = (Grid)modelDataHashtable.get(IDSSAppConstants.lcGridName);
        Hashtable smHashtable = (Hashtable)modelDataHashtable.get(IDSSAppConstants.smHashCode);
        int isostatic = ((Integer)modelDataHashtable.get(IDSSAppConstants.isostaticMovementHashCode)).intValue();
        ClientDataSet slr = (ClientDataSet)modelDataHashtable.get(IDSSAppConstants.slrDataHashCode);

        LCGrid2 lcGrid2 = new LCGrid2("Land Cover Details",null,lcGrid,smHashtable);


        simJBean.setDem(dem);

        simJBean.setLcGrid2(lcGrid2);

        simJBean.setTidalModelHashtable(tidalModelsHashtable);

        simJBean.setIsostaticMovement(isostatic);

        simJBean.setSlrDataSet(slr);


        return simJBean;

    } //public SimulationJBean getSimulationJBean()


} //public class ModelSetupControllerJBean

