package iDSS.disp;

import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import java.io.IOException;
import javax.swing.event.*;
import java.io.*;
import java.net.*;
import java.util.*;
import javax.swing.text.html.*;




public class DocumentDisplay extends DisplayFrame implements HyperlinkListener {

    private JEditorPane aHTMLPane;
    private JScrollPane aScrollPane;

    public DocumentDisplay (String title,String url) {

        super (title,true,true,true,true,null);

        aHTMLPane = new JEditorPane();
        setDisplayPane();

        try {
            aHTMLPane.setPage(url);
        }
        catch(IOException IOe) {
            System.out.println("IOException, " + IOe);
            System.exit(0);
        }


        aScrollPane = new JScrollPane(aHTMLPane);

        getContentPane().add(aScrollPane);
        pack();
        setVisible(true);

    }//public DocumentDisplay (int width, int height, String url)







    public DocumentDisplay (String title,Vector content,String contentType) {

        super (title,true,true,true,true,null);

        aHTMLPane = new JEditorPane();
        aHTMLPane.addHyperlinkListener(this);

        setDisplayPane();

        for(int i=0;i<content.size();i++) {
            String s = (String) content.elementAt(i);
            aHTMLPane.setText(aHTMLPane.getText()+s);
        }
/**
        if(contentType.equals("text/plain") ||
            contentType.equals("text/html") ||
            contentType.equals("text/rtf"))
                aHTMLPane.setContentType(contentType);
**/
        aScrollPane = new JScrollPane(aHTMLPane);

        getContentPane().add(aScrollPane);
        pack();
        setVisible(true);

    }//public DocumentDisplay (String title,Vector content,String contentType)






    public DocumentDisplay (String title,StringBuffer content,String contentType) {

        super (title,true,true,true,true,null);

        aHTMLPane = new JEditorPane();
        setDisplayPane();
/**
        if(contentType.equals("text/plain") ||
            contentType.equals("text/html") ||
            contentType.equals("text/rtf"))
                aHTMLPane.setContentType(contentType);
**/

        aHTMLPane.setText(content.toString());




        aScrollPane = new JScrollPane(aHTMLPane);

        getContentPane().add(aScrollPane);
        pack();
        setVisible(true);

    }//public DocumentDisplay (String title,StringBuffer content,String contentType)




    private void setDisplayPane() {

        aHTMLPane.setMinimumSize(new Dimension (300,300));
        aHTMLPane.setPreferredSize(new Dimension (300,300));
        aHTMLPane.setSize(new Dimension (300,300));
        aHTMLPane.setEditable(false);


    } //private void setDisplayPane()





    public void hyperlinkUpdate(HyperlinkEvent e) {

        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {

            JEditorPane pane = (JEditorPane) e.getSource();

	        if (e instanceof HTMLFrameHyperlinkEvent) {

	            HTMLFrameHyperlinkEvent  evt = (HTMLFrameHyperlinkEvent)e;
	            HTMLDocument doc = (HTMLDocument)pane.getDocument();
	            doc.processHTMLFrameHyperlinkEvent(evt);

            } //if (e instanceof HTMLFrameHyperlinkEvent)

            else {

	            try {

    		        pane.setPage(e.getURL());

	            } //try

	            catch (Throwable t) {

		            t.printStackTrace();

	            } //catch

	        } //else

        } //if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED)

    } //public void hyperlinkUpdate(HyperlinkEvent e)










} //public class DocumentDisplay extends DisplayFrame
