package iDSS.gView;

import java.beans.*;
import java.util.*;
import javax.swing.*;


import iDSS.*;
import iDSS.disp.*;
import iDSS.grids.*;
import iDSS.tidalData.*;
import iDSS.utils.*;





public class TestAnim implements PropertyChangeListener {


    ModelSetupView modelSetupView;


    public TestAnim() {



        modelSetupView = new ModelSetupView
                    (IDSSAppConstants.modelSetupViewName,400,300);
        modelSetupView.addPropertyChangeListener(this);


        GridViewControl gvc = new GridViewControl(GridViewControl.INSTANT,"Flood Grids Test");
        gvc.addPropertyChangeListener(this);

        addToView(gvc);


    } //public TestAnim()








    private void addToView(DisplayFrame panel) {

        modelSetupView.addToView(panel);

    } //private void addToView(DisplayFrame panel)




    private void removeAllFromView() {

        modelSetupView.removeAllFromView();

    } //private void removeAllFromView()




    private void removeFromView(DisplayFrame panel) {

        modelSetupView.removeFromView(panel);

    } //private void removeFromView(DisplayFrame panel)









    public void propertyChange(PropertyChangeEvent evt) {


        if (evt.getPropertyName().equals(IDSSAppConstants.addToModelView)) {

            DisplayFrame frame = (DisplayFrame)evt.getNewValue();

            if(frame != null) {

                addToView(frame);

            } //if(frame != null)

            else {

                if(IDSSAppConstants.debug)
                    System.out.println("ModelSetupTree.propertyChange(), " +
                            evt.getPropertyName() + " frame = null");

            } //else

        } //if (evt.getPropertyName().equals(IDSSAppConstants.addToModelView))




        if (evt.getPropertyName().equals(IDSSAppConstants.removeFromModelView)) {

            DisplayFrame frame = (DisplayFrame)evt.getNewValue();

            if(frame != null) {

                removeFromView(frame);

            } //if(frame != null)

            else {

                if(IDSSAppConstants.debug)
                    System.out.println("ModelSetupTree.propertyChange(), " +
                            evt.getPropertyName() + " frame = null");

            } //else

        } //if (evt.getPropertyName().equals(IDSSAppConstants.removeFromModelView))




        if (evt.getPropertyName().equals(IDSSAppConstants.removeAllFromModelView)) {

            removeAllFromView();

        } //if (evt.getPropertyName().equals(IDSSAppConstants.removeAllFromModelView))










    } //public void propertyChangeEvent(PropertyChangeEvent evt)










    public static void main(String[] args) {

        iDSS.gView.TestAnim test = new iDSS.gView.TestAnim();

    } //public static void main(String[] args)



} //public class TestAnim

