package iDSS.grids;

import java.io.*;
import java.util.*;


import iDSS.sm.*;




public class LandCover implements Serializable {



    private int landCoverId;
    private SurvivalModel survivalModel;
    private Hashtable history;



    public LandCover(int lcId,SurvivalModel sm) {

        landCoverId = lcId;
        survivalModel = sm;
        history = new Hashtable();

    } //public LandCover(int lcId,SurvivalModel sm)



    public Enumeration getYears() {

        Enumeration years = null;

        if(history.size()>0) {

            years = history.keys();

        } //if(history.size()>0)

        return years;

    } //public Enumeration getYears()




    public void appendHistory(int year,GridCell gc) {

        Hashtable oneYear = new Hashtable();

        Vector parameters = GridCell.getParametersVector();

        for(int i=0;i<parameters.size();i++) {

            String s = (String) parameters.elementAt(i);
            String s2 = gc.getValue(s);

            oneYear.put(s,s2);

        } //for(int i=0;i<parameters.size();i++)

        history.put(new Integer(year),oneYear);

    } //public void appendHistory(int year,GridCell gc)








    public String getValue(int year, String parameter) {


        Hashtable h = (Hashtable) history.get(new Integer(year));
        String s = (String) h.get(parameter);
        return s;


    } //public String getValue(int year, String parameter)









    public SurvivalModel getSurvivalModel() {

        return survivalModel;

    } //public SurvivalModel getSurvivalModel()




} //public class LandCover implements serializable
