package iDSS.slr;

import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import java.util.*;
import javax.swing.table.*;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.ListSelectionEvent;
//import java.io.*;
//import java.net.*;
//import java.sql.*;


import iDSS.*;
import iDSS.utils.*;
import iDSS.disp.*;
import iDSS.tables.*;
import iDSS.tidalData.*;
import iDSS.beans2.*;



public class ScenarioDetail extends DisplayFrame implements ActionListener {

    private JButton selectButton;

    private boolean ALLOW_ROW_SELECTION = false;
    private boolean ALLOW_COLUMN_SELECTION = true;

    private int selectedCol;

    private JTable aTable;
    private String scenarioName;

    private final int yearCol = 1;

    private ScenarioDetailJBean scenarioDetailJBean;






    public ScenarioDetail(String scenario) {

        super (scenario+":Detail",false,true,false,true,null);
        scenarioName = scenario;

        scenarioDetailJBean = new ScenarioDetailJBean();
        scenarioDetailJBean.setScenarioName(scenarioName);

        Vector slrData = scenarioDetailJBean.getScenarioDetail();

        GeneralTableModel tm;


        if (slrData != null){

            Vector columnNames = new Vector();
            columnNames = new Vector();
            columnNames.add("Scenario");
            columnNames.add("Year");
            columnNames.add("1.5C Sensitivity");
            columnNames.add("4.5C Sensitivity");
            columnNames.add("2.5C Sensitivity");
            columnNames.add("2.5C w/o Sulphate Forcing");

            tm = new GeneralTableModel(slrData,columnNames);
            aTable = new JTable(tm);

        }

        else {

            JOptionPane.showMessageDialog (null, "No SLR scenario found in database");
            tm = null;
            aTable = new JTable(5,5);
        }

        aTable.setPreferredScrollableViewportSize(new Dimension(300,100));
        aTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        JScrollPane aScrollPane = new JScrollPane(aTable);

        selectButton = new JButton(IDSSAppConstants.selectButtonText);
        selectButton.addActionListener(this);
        selectButton.setActionCommand(IDSSAppConstants.selectButtonCommand);

        selectButton.setEnabled(false);

        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel,BoxLayout.X_AXIS));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(selectButton);

        getContentPane().setLayout(new BoxLayout(getContentPane(),BoxLayout.Y_AXIS));
        getContentPane().add(aScrollPane);
        getContentPane().add(buttonPanel);
        pack();
        setVisible(true);


        if (ALLOW_COLUMN_SELECTION) { // false by default
            if (ALLOW_ROW_SELECTION) {
                //We allow both row and column selection, which
                //implies that we *really* want to allow individual
                //cell selection.
                aTable.setCellSelectionEnabled(true);
            } 
            aTable.setColumnSelectionAllowed(true);
            ListSelectionModel colSM =
                aTable.getColumnModel().getSelectionModel();
            colSM.addListSelectionListener(new ListSelectionListener() {
                public void valueChanged(ListSelectionEvent e) {
                    //Ignore extra messages.
                    if (e.getValueIsAdjusting()) return;

                    ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                    if (lsm.isSelectionEmpty()) {
                        System.out.println("No columns are selected.");
                        selectButton.setEnabled(false);
                    } else {
                        selectedCol = lsm.getMinSelectionIndex();
                        System.out.println("Column " + selectedCol
                                           + " is now selected.");
                        if(selectedCol > 1)
                            selectButton.setEnabled(true);
                        else
                            selectButton.setEnabled(false);

                    }
                }
            });
        }



  }//public ScenarioDetail(int row, int column)












    public void actionPerformed(ActionEvent ae) {


        if (ae.getActionCommand().equals(IDSSAppConstants.selectButtonCommand)) {

            ClientDataSet slrDataSet = scenarioDetailJBean.makeSLRDataSet(selectedCol,yearCol);
            slrDataSet.setStationName(scenarioName+":"+aTable.getColumnName(selectedCol));

            setSLRScenario(slrDataSet);

        } //else if (ae.getActionCommand().equals(IDSSAppConstants.selectButtonCommand))


    }//public void actionPerformed(ActionEvent ae)


















    private void setSLRScenario(ClientDataSet scenarioDataSet) {

        firePropertyChange(IDSSAppConstants.setSLRScenario,null,scenarioDataSet);

    } //setSLRScenario(ClientDataSet scenarioDataSet)






} //public class ScenarioDetail extends DisplayFrame implements ActionListener

