package iDSS.slr;

import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import java.util.*;
import javax.swing.table.*;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.ListSelectionEvent;
import java.io.*;
import java.net.*;
import java.beans.*;



import iDSS.*;
import iDSS.utils.*;
import iDSS.disp.*;
import iDSS.tables.*;
import iDSS.beans.*;
import iDSS.beans2.*;



public class ScenarioList extends DisplayFrame implements ActionListener,PropertyChangeListener {

    private JTable aTable;
    private JScrollPane aScrollPane;
    private JButton storeyLineButton,scenarioButton,selectButton;

    private JPanel buttonPanel;
    private boolean ALLOW_ROW_SELECTION = true;

    private Vector columnNames;
    private Vector rowsOfData;

    private String scenarioName,storeyLineName,scenarioTable;
    private JTextField scenarioTextField;

    private ScenarioListJBean scenarioListJBean;


    public ScenarioList(String ejb) {

        super (IDSSAppConstants.modelSlrListWindow,false,false,false,true,null);

        scenarioListJBean = new ScenarioListJBean();
        scenarioListJBean.addPropertyChangeListener(this);
        rowsOfData = scenarioListJBean.getScenarios();

        columnNames = new Vector();
        columnNames.add("Scenario Name");
        columnNames.add("Storey Line");
        columnNames.add("Scenarios Table");

        GeneralTableModel tm = new GeneralTableModel(rowsOfData,columnNames);
        aTable = new JTable(tm);

        aTable.setPreferredScrollableViewportSize(new Dimension(200,100));
        aTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);

        aScrollPane = new JScrollPane(aTable);

        storeyLineButton = new JButton(IDSSAppConstants.readStoryLineButtonText);
        scenarioButton = new JButton(IDSSAppConstants.getScenarioButtonText);

        storeyLineButton.addActionListener(this);
        scenarioButton.addActionListener(this);

        storeyLineButton.setActionCommand(IDSSAppConstants.readStoryLineButtonCommand);
        scenarioButton.setActionCommand(IDSSAppConstants.getScenarioButtonCommand);

        storeyLineButton.setEnabled(false);
        scenarioButton.setEnabled(false);

        buttonPanel = new JPanel();
        buttonPanel.add(storeyLineButton);
        buttonPanel.add(scenarioButton);

        getContentPane().add(aScrollPane,BorderLayout.CENTER);
        getContentPane().add(buttonPanel,BorderLayout.SOUTH);
        pack();
        setVisible(true);



        if (ALLOW_ROW_SELECTION) { // true by default
            ListSelectionModel rowSM = aTable.getSelectionModel();
            rowSM.addListSelectionListener(new ListSelectionListener() {
                public void valueChanged(ListSelectionEvent e) {
                    //Ignore extra messages.
                    if (e.getValueIsAdjusting()) return;
                
                    ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                    if (lsm.isSelectionEmpty()) {
                        System.out.println("No rows are selected.");
                        storeyLineButton.setEnabled(false);
                        scenarioButton.setEnabled(false);
                    } else {
                        int selectedRow = lsm.getMinSelectionIndex();
                        System.out.println("Row " + selectedRow
                                           + " is now selected.");

                        storeyLineButton.setEnabled(true);
                        scenarioButton.setEnabled(true);

                        scenarioName = (String) aTable.getValueAt(selectedRow,0);
                        storeyLineName = (String) aTable.getValueAt(selectedRow,1);
                        scenarioTable = (String) aTable.getValueAt(selectedRow,2);

                        System.out.println("scenarioName,storeyLineName,scenarioTable : \n" +
                                            scenarioName + ", " + storeyLineName + ", " + scenarioTable);


                    }
                }
            });
        } else {
            aTable.setRowSelectionAllowed(false);
        }



    }//public ScenarioList(String ejb)












    public void actionPerformed(ActionEvent ae) {



        if(ae.getActionCommand().equals(IDSSAppConstants.readStoryLineButtonCommand)) {


            DocumentDisplay docDisp = scenarioListJBean.getStoreyLine(
                                IDSSAppConstants.modelSlrDetailWindow+": "+scenarioName,
                                            storeyLineName);

            //docDisp.addPropertyChangeListener(this);
            //docDisp.removePropertyChangeListener(this);
            firePropertyChange(IDSSAppConstants.addToModelView,null,docDisp);

        } //if(ae.getActionCommand().equals(IDSSAppConstants.readStoryLineButtonCommand))


        else if (ae.getActionCommand().equals(IDSSAppConstants.getScenarioButtonCommand)) {

            //ScenarioDetail slrDetail = new ScenarioDetail(scenarioName);

            ScenarioDetail slrDetail = scenarioListJBean.getScenarioDetail(scenarioName);

            slrDetail.removePropertyChangeListener(this);
            slrDetail.addPropertyChangeListener(this);
            firePropertyChange(IDSSAppConstants.addToModelView,null,slrDetail);

        } //else if (ae.getActionCommand().equals(IDSSAppConstants.getScenarioButtonCommand))



    }//public void actionPerformed(ActionEvent ae)















    public void propertyChange(PropertyChangeEvent evt) {



        if(evt.getPropertyName().equals(IDSSAppConstants.addToModelView)) {

            firePropertyChange(evt.getPropertyName(),evt.getOldValue(),evt.getNewValue());

        } //if(evg.getPropertyName().equals(IDSSAppConstants.addToModelView))



        if(evt.getPropertyName().equals(IDSSAppConstants.removeFromModelView)) {

            firePropertyChange(evt.getPropertyName(),evt.getOldValue(),evt.getNewValue());

        } //if(evg.getPropertyName().equals(IDSSAppConstants.removeFromModelView))



        if(evt.getPropertyName().equals(IDSSAppConstants.setSLRScenario)) {

            firePropertyChange(evt.getPropertyName(),evt.getOldValue(),evt.getNewValue());

        } //if(evg.getPropertyName().equals(IDSSAppConstants.setSLRScenario))





    } //public void propertyChange(PropertyChangeEvent evt)










} //public class ScenarioList extends DisplayFrame implements ActionListener
