package iDSS.tables;

import javax.swing.table.AbstractTableModel;
import java.util.*;
import javax.swing.event.*;
//import javax.swing.table.DefaultTableModel;


public class GeneralTableModel extends AbstractTableModel  {



    private final String[] columnNames;
    private int numberOfColumns;
    private Object[][] data;
    private Vector allRowsVector;
    private boolean DEBUG = false;

    private Vector editableColumns;
    private Vector columns;



    public GeneralTableModel (Vector rowsOfData,Vector columnNamesVector) {

      columnNames = new String[columnNamesVector.size()];
      numberOfColumns = columnNamesVector.size();
      editableColumns = new Vector();
      columns = columnNamesVector;

      //data = new Object[rowsOfData.size()][firstRow.size()];

      for (int i=0;i<columnNamesVector.size();i++) {
        //System.out.println("Column = " + columnNamesVector.elementAt(i));

        columnNames[i] = (String) columnNamesVector.elementAt(i);
      }

      allRowsVector = rowsOfData;

      makeRows();


    } //public GeneralTableModel (Vector rowsOfData,Vector columnNames)






    public GeneralTableModel (Vector rowsOfData,Vector columnNamesVector,int editableColumn) {

      columnNames = new String[columnNamesVector.size()];
      numberOfColumns = columnNamesVector.size();
      editableColumns = new Vector();
      columns = columnNamesVector;


      editableColumns.add(new Integer(editableColumn));

      //data = new Object[rowsOfData.size()][firstRow.size()];

      for (int i=0;i<columnNamesVector.size();i++) {
        //System.out.println("Column = " + columnNamesVector.elementAt(i));

        columnNames[i] = (String) columnNamesVector.elementAt(i);
      }

      allRowsVector = rowsOfData;

      makeRows();


    } //public GeneralTableModel (Vector rowsOfData,Vector columnNames,int editableColumn)




    public Vector getColumns() {

        return columns;

    } //public Vector getColumns()





    public void setEditableColumn(int col) {

      editableColumns.add(new Integer(col));

    } //public void setEditableColumn(int col)





    public void setEditableColumn(Vector cols) {

        for(int i=0;i<cols.size();i++) {

            int col = Integer.parseInt(cols.elementAt(i).toString());
            setEditableColumn(col);

        }//for(int i=0;i<cols.size();i++)

    } //public void setEditableColumn(Vector cols)















    public int getNumberOfRows() {

        return allRowsVector.size();

    } //public int getNumberOfRows()







    private void makeRows() {
      //Vector firstRow = (Vector) allRowsVector.elementAt(0);
      data = new Object[allRowsVector.size()][numberOfColumns];

      for (int i=0;i<allRowsVector.size();i++) {
        Vector ithElement = (Vector) allRowsVector.elementAt(i);
        for (int j=0;j<ithElement.size();j++) {

          //System.out.println("Row["+ i + "][" + j + "] = " + ithElement.elementAt(j));
          data[i][j] = ithElement.elementAt(j);
        }
      }


    } //private void makeRows(Vector rowsVector)  





    public void addRow(Vector newRow) {


      allRowsVector.add(newRow);
      makeRows();

      fireTableRowsInserted(getRowCount()-1, getRowCount()-1);


    } //public void addRow(Vector newRow)






    public void removeRow(Vector rowToRemove) {

      allRowsVector.remove(rowToRemove);
      makeRows();

      fireTableRowsDeleted(getRowCount()-1, getRowCount()-1);


    } //public void addRow(Vector newRow)




    //This method is added to get edited cell values

    public Vector getRowsVector() {

        return allRowsVector;

    } //public Vector getRowsVector()



    public Vector getRow(int rowNum) {

        Vector row = (Vector)allRowsVector.elementAt(rowNum);
        return row;

    } //public Vector getRow(int rowNum)





    public int getColumnCount() {
        return columnNames.length;
    }
    
    public int getRowCount() {
        return data.length;
    }

    public String getColumnName(int col) {
        return columnNames[col];
    }

    public Object getValueAt(int row, int col) {
        return data[row][col];
    }

    /*
     * JTable uses this method to determine the default renderer/
     * editor for each cell.  If we didn't implement this method,
     * then the last column would contain text ("true"/"false"),
     * rather than a check box.
     */

/**
    public Class getColumnClass(int c) {

        return getValueAt(0, c).getClass();
    }
**/
    /*
     * Don't need to implement this method unless your table's
     * editable.
     */
    public boolean isCellEditable(int row, int col) {
        //Note that the data/cell address is constant,
        //no matter where the cell appears onscreen.


        return editableColumns.contains(new Integer(col));


    } //public boolean isCellEditable(int row, int col)




    /*
     * Don't need to implement this method unless your table's
     * data can change.
     */



    public void setValueAt(Object value, int row, int col) {
        if (DEBUG) {
            System.out.println("Setting value at " + row + "," + col
                               + " to " + value
                               + " (an instance of " 
                               + value.getClass() + ")");
        }


        data[row][col] = value;
        fireTableCellUpdated(row, col);

        allRowsVector.removeAllElements();

        for (int i=0;i<data.length;i++) {

            Vector ithRow = new Vector();
            for(int j=0;j<data[i].length;j++) {

                ithRow.add(data[i][j]);

            }//for(int j=0;j<data[i].length;j++)

            allRowsVector.add(ithRow);

        } //for (int i=0;i<data.length;i++)


/***

        if (data[0][col] instanceof Integer                        
                && !(value instanceof Integer)) {                  
            //With JFC/Swing 1.1 and JDK 1.2, we need to create    
            //an Integer from the value; otherwise, the column     
            //switches to contain Strings.  Starting with v 1.3,   
            //the table automatically converts value to an Integer,
            //so you only need the code in the 'else' part of this 
            //'if' block.                                          
            //XXX: See TableEditDemo.java for a better solution!!!
            try {
                data[row][col] = new Integer(value.toString());
                fireTableCellUpdated(row, col);
            } catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(TableDemo.this,
                    "The \"" + getColumnName(col)
                    + "\" column accepts only integer values.");
            }
        } else {
            data[row][col] = value;
            fireTableCellUpdated(row, col);
        }

        if (DEBUG) {
            System.out.println("New value of data:");
            printDebugData();
        }

***/


    } //public void setValueAt(Object value, int row, int col)




/***

    private void printDebugData() {
        int numRows = getRowCount();
        int numCols = getColumnCount();

        for (int i=0; i < numRows; i++) {
            System.out.print("    row " + i + ":");
            for (int j=0; j < numCols; j++) {
                System.out.print("  " + data[i][j]);
            }
            System.out.println();
        }
        System.out.println("--------------------------");
    }

***/


} //class DataManagerTableModel extends AbstractTableModel



