package iDSS.utils;


import java.util.*;
import javax.swing.*;
import java.io.*;
import java.net.*;





public class ConfigData {









    public static Vector readProperties(String fileParent,String fileChild) {

        Vector propsList = new Vector();
        Properties props = new Properties();

        final char fileSeparator = File.separatorChar;
        final char foreSlash = 47;
        final char backSlash = 92;


        try {

            fileParent = fileParent.replace(foreSlash,fileSeparator);
            fileParent = fileParent.replace(backSlash,fileSeparator);

            fileChild = fileChild.replace(foreSlash,fileSeparator);
            fileChild = fileChild.replace(backSlash,fileSeparator);

            File inputFile = new File(fileParent,fileChild);

            if(inputFile.exists()) {
                FileInputStream fis = new FileInputStream(inputFile);
        
                props.load(fis);

                Enumeration keys = props.propertyNames();

                while(keys.hasMoreElements()) {

                    String key = (String)keys.nextElement();
                    String prop = props.getProperty(key);
                    propsList.add(prop);

                } //while(keys.hasMoreElements())

            }//if(inputFile.exists())

        }//try

        catch (IOException e) {

            System.out.println("ConfigData.readProperties(), " + e.toString());


        } //catch (IOException e)

        return propsList;

    } //public static Vector readProperties(String fileParent,String fileChild)







    public static Vector readProperties(File inputFile) {

        Vector propsList = new Vector();
        Properties props = new Properties();

        try {


            if(inputFile != null && inputFile.exists()) {

                FileInputStream fis = new FileInputStream(inputFile);
                props.load(fis);

                Enumeration keys = props.propertyNames();

                while(keys.hasMoreElements()) {

                    String key = (String)keys.nextElement();
                    String prop = props.getProperty(key);
                    propsList.add(prop);

                } //while(keys.hasMoreElements())

            }//if(inputFile != null && inputFile.exists())

        }//try

        catch (IOException e) {

            System.out.println("ConfigData.readProperties(), " + e.toString());


        } //catch (IOException e)

        return propsList;

    } //public static Vector readProperties(File inputFile)












    public static Vector readURLProperties(String urlParent,String urlChild,Class c) {

        Vector propsList = new Vector();
        Properties props = new Properties();

        final char fileSeparator = File.separatorChar;
        final char foreSlash = 47;
        final char backSlash = 92;


        try {

            urlParent = urlParent.replace(fileSeparator,foreSlash);
            urlParent = urlParent.replace(backSlash,foreSlash);

            urlChild = urlChild.replace(fileSeparator,foreSlash);
            urlChild = urlChild.replace(fileSeparator,foreSlash);

            String fullURL = urlParent + "/" + urlChild;
            System.out.println("ConfigData.readURLProperties(), fullURL : " + fullURL);
            //System.out.println("ConfigData.readURLProperties(), c.toString() : " + c.toString());
            //System.out.println("ConfigData.readURLProperties(), this.getClass().toString() : " + this.getClass().toString());
            //System.out.println("ConfigData.readURLProperties(), this.getClass().getPackage().toString() : " + this.getClass().getPackage().toString());
            //System.out.println("");
            //System.out.println("");


            //URL inputURL = ClassLoader.getSystemResource(fullURL);
            URL inputURL = c.getResource("/iDSS/" + fullURL);
            //URL inputURL = ConfigData.getURL(fullURL,c);

            System.out.println("ConfigData.readURLProperties(), inputURL : " + inputURL.toString());

            //HttpURLConnection connection = (HttpURLConnection)inputURL.openConnection();
            //URL url = inputURL.openStream();
            //System.out.println("ConfigData.readURLProperties(), stream opened");

            //if(o instanceof HttpURLConnection) {

                //System.out.println("ConfigData.readURLProperties(), HttpURLConnection");
                //int responseCode = connection.getResponseCode();
                //System.out.println("ConfigData.readURLProperties(), responseCode : " + responseCode);

                //if(responseCode == HttpURLConnection.HTTP_OK) {

                    //InputStream inputStream = connection.getInputStream();
                    InputStream inputStream = inputURL.openStream();

                    props.load(inputStream);

                    Enumeration keys = props.propertyNames();

                    while(keys.hasMoreElements()) {

                        String key = (String)keys.nextElement();
                        String prop = props.getProperty(key);
                        propsList.add(prop);

                    } //while(keys.hasMoreElements())


                    inputStream.close();
                    //connection.disconnect();

                //}//if(responseCode == HttpURLConnection.HTTP_OK)

            //} //if(o instanceof HttpURLConnection)





        }//try

        catch (Exception e) {

            System.out.println("ConfigData.readURLProperties(), " + e.toString());


        } //catch (IOException e)

        return propsList;

    } //public static Vector readURLProperties(String fileParent,String fileChild)








    public static URL getURL(String fileName, Class loader) { 

        URL url = null; 

        if (fileName == null) 
            return null; 

        if (loader == null) 
            url = ConfigData.class.getResource(fileName); 
        else 
            url = loader.getResource(fileName); 

        return url; 

    } //public static URL getURL(String fileName, Class loader)






    public static void addToClassPath(String path) {

        System.out.println("ConfigData.addToClassPath(), path : " + path);


        String extDirs = System.getProperty("java.ext.dirs");
        System.out.println("ConfigData.addToClassPath(), extDirs : " + extDirs);


        String ps = System.getProperty("path.separator");
        String cp = System.getProperty("java.class.path");

        System.out.println("ConfigData.addToClassPath(), cp : " + cp);
        System.out.println("ConfigData.addToClassPath(), ps : " + ps);


        String newExtDir = extDirs + ps + path;
        System.setProperty("java.ext.dirs",newExtDir);

        System.out.println("ConfigData.addToClassPath(), newExtDirs : " +
                                        System.getProperty("java.ext.dirs"));


        StringTokenizer st = new StringTokenizer(cp,ps);
        Vector v = new Vector();

        while (st.hasMoreTokens()) {

            String s = st.nextToken();
            v.add(s);
            System.out.println(s);

        } //while (st.hasMoreTokens())

        if(!v.contains(path)) {

            System.setProperty("java.class.path",cp+ps+path);
            String cp2 = System.getProperty("java.class.path");
            System.out.println("ConfigData.addToClassPath(), cp2 : " + cp2);

        } //if(!v.contains(path))

        else {

            System.out.println("ConfigData.addToClassPath(), classpath already contains " + path);

        } //else


    } //public static void addToClassPath(String path)

 } //public class ConfigData

