package iDSS.webBeans;


import java.io.*;
import java.beans.*;
import java.sql.Timestamp;
import java.util.*;



import iDSS.*;
import iDSS.utils.*;
import iDSS.beans.*;




public class LogJBean implements Serializable,PropertyChangeListener {


    private PropertyChangeSupport pcs;

    private UserJBean userJBean;
    private Timestamp logOnTime;
    private Timestamp logOffTime;
    



    public LogJBean() {

        pcs = new PropertyChangeSupport(this);

        userJBean = new UserJBean();
        userJBean.addPropertyChangeListener(this);


    } //public LogJBean()



    public void addPropertyChangeListener(PropertyChangeListener l) {

        pcs.addPropertyChangeListener(l);

    } //public void addPropertyChangeListener(PropertyChangeListener l)




    public void removePropertyChangeListener(PropertyChangeListener l) {

        pcs.removePropertyChangeListener(l);

    } //public void removePropertyChangeListener(PropertyChangeListener l)





    public boolean logOn(String email) {

        boolean success = true;

        if(email != null) {

            logOnTime = new Timestamp(System.currentTimeMillis());

            //userJBean = new UserJBean();
            //userJBean.addPropertyChangeListener(this);

            success = userJBean.findByPrimaryKey(email);

            if(!success) {

                String message = "LogJBean.logOn(), no user found with email " + email;

                Vector messageVector = new Vector();
                messageVector.add("No such user");
                messageVector.add(message);
                messageVector.add(new Integer(IDSSAppConstants.errorMessage));
                pcs.firePropertyChange(IDSSAppConstants.showMessage,null,messageVector);

                System.out.println(message);

            } //

        } //if(email != null)

        else {
            success = false;
        } //

        return success;

    } //public boolean logOn(String email)





    public boolean register(String name,String email) {


        boolean success = true;

        //userJBean = new UserJBean();
        //userJBean.addPropertyChangeListener(this);

        Timestamp lastVisited = new Timestamp(System.currentTimeMillis());
        long totalTimeSpent = 0;

        boolean registerSuccess = userJBean.create(name,email,lastVisited,totalTimeSpent);

        if(registerSuccess) {

            boolean logonSuccess = logOn(email);

            if(!logonSuccess)
                success = false;

        } //

        else {

            registerSuccess = false;
            success = false;

            String message = "LogJBean.register(), failed to create user for " + email;

            Vector messageVector = new Vector();
            messageVector.add("Registration failed");
            messageVector.add(message);
            messageVector.add(new Integer(IDSSAppConstants.errorMessage));
            pcs.firePropertyChange(IDSSAppConstants.showMessage,null,messageVector);

            System.out.println(message);


        } //else


        return success;

    } //





    public boolean logOff() {

        boolean success = true;

        logOffTime = new Timestamp(System.currentTimeMillis());

        //userJBean = new UserJBean();
        //userJBean.addPropertyChangeListener(this);

        long timeSpent = userJBean.getTotalTimeSpent() + logOffTime.getTime()-logOnTime.getTime();

        userJBean.setTotalTimeSpent(timeSpent);
        userJBean.setLastVisited(logOffTime);

        return success;


    } //public boolean logOff(UserJBean userJBean)





    public UserJBean getUser() {

        return userJBean;

    } //public UserJBean getUser()




    public static void main(String args[]) {


        LogJBean logBean = new LogJBean();
        String email = "sayeed@strath";
        boolean registerSuccess = logBean.register("Sayeed Ahmed",email);

        if(registerSuccess) {

            System.out.println("registered successfully!");

            UserJBean userJBean = logBean.getUser();

            System.out.println("Name           : " + userJBean.getName());
            System.out.println("Email          : " + userJBean.getEmail());
            System.out.println("LastVisited    : " + userJBean.getLastVisited());
            System.out.println("TotalTimeSpent : " + userJBean.getTotalTimeSpent());

        } //if

        else {
            System.out.println("Not registered email " + email + "!");
        }


/**

        String email = "ahmed@strath.ac.uk";
        boolean success = logBean.logOn(email);

        if(success) {

            System.out.println("Found user");

            UserJBean userJBean = logBean.getUser();

            System.out.println("Name           : " + userJBean.getName());
            System.out.println("Email          : " + userJBean.getEmail());
            System.out.println("LastVisited    : " + userJBean.getLastVisited());
            System.out.println("TotalTimeSpent : " + userJBean.getTotalTimeSpent());

        } //

        else {

            System.out.println("User not found, registering");

            boolean registerSuccess = logBean.register("Sayeed Ahmed","sayeed.ahmed@strath.ac.uk");

            if(registerSuccess) {

                System.out.println("registered successfully!");

                UserJBean userJBean = logBean.getUser();

                System.out.println("Name           : " + userJBean.getName());
                System.out.println("Email          : " + userJBean.getEmail());
                System.out.println("LastVisited    : " + userJBean.getLastVisited());
                System.out.println("TotalTimeSpent : " + userJBean.getTotalTimeSpent());

            } //if

            else {
                System.out.println("Not registered!");
            }


        } //



        for(int i=0;i<1000000;i++) {}

        success = logBean.logOff();


        if(success) {

            UserJBean userJBean = logBean.getUser();

            System.out.println("Name           : " + userJBean.getName());
            System.out.println("Email          : " + userJBean.getEmail());
            System.out.println("LastVisited    : " + userJBean.getLastVisited());
            System.out.println("TotalTimeSpent : " + userJBean.getTotalTimeSpent());

        }//if(success)

**/

    } //public static void main(String args[])



    public void propertyChange(PropertyChangeEvent evt) {



    } //public void propertyChange(PropertyChangeEvent evt)



}//public class LogJBean implements Serializable

