/*
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.  
 * Use is subject to license terms.
 * 
 */

package ejb.dataAccess;


import java.util.*;
import javax.naming.*;
import javax.rmi.PortableRemoteObject;
import javax.sql.*;
import java.sql.*;
import javax.ejb.*;
import javax.rmi.*;
import sun.jdbc.rowset.*;


import utils.*;

public class DataClient {

   public static void main(String[] args) {
       try {

           Context initial = new InitialContext();
           Object objref = initial.lookup("DataAccessEJB");

           DataHome home = 
               (DataHome)PortableRemoteObject.narrow(objref, 
                                            DataHome.class);


           //String dbName = "java:comp/env/jdbc/idss";
           String dbName = ServerConstants.tidalStationDB;

           Data dataAccess = home.create();

           //String sql = "insert into test (observ_date,observation) values ('1999-01-03 00:00:00',1.5975)";
           //String sql = "delete from test";
           //dataAccess.insert(sql,dbName);




           System.out.println("DataClient 1");
           String sql = "select * from tidalStations";

           DataSet ds = dataAccess.select(sql,dbName);
           System.out.println("DataClient 2");

           System.out.println("sql : " + ds.getSqlString());
           Vector columns = ds.getColumnNamesVector();
           Vector rows = ds.getRowsOfDataVector();

            System.out.println("");

           for(int i=0;i<columns.size();i++) {

                String s = (String)columns.elementAt(i);
                System.out.print("\t" + s);

           } //for(int i=0;i<columns.size();i++)

            System.out.println("");



           for(int i=0;i<rows.size();i++) {

                Vector v = (Vector)rows.elementAt(i);

                System.out.println("");

                for(int j=0;j<v.size();j++) {

                    String s = v.elementAt(j).toString();
                    System.out.print("\t" + s);

                } //for(int j=0;j<v.size();j++)

           } //for(int i=0;i<rows.size();i++)

            System.out.println("");


       } //try


        catch(NamingException e) {

            System.out.println("NamingException : " + e.toString());
            e.printStackTrace();
            System.exit(0);

        } //catch(NamingException e)




       catch (Exception ex) {
           System.err.println("Caught an unexpected exception! " + ex.toString());
           ex.printStackTrace();
           System.out.println("message : " + ex.getMessage());
       } //catch (Exception ex)


   } //public static void main(String[] args)


} //public class DataClient
