package applets;

import javax.swing.*;
import java.awt.*;
import java.awt.image.*;
import java.awt.event.*;
import java.util.*;
import java.sql.*;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.*;
import java.io.*;
import java.beans.*;
import javax.imageio.*;
import java.text.*;
import java.net.*;

import iDSS.*;
import iDSS.gridDisp.*;
import iDSS.disp.*;
import iDSS.utils.*;
import iDSS.grids.*;
import iDSS.tidalData.*;




/**JInternal frame**/
/**GridViewControlApplet to be used with applets or frames**/




public class GridViewControlApplet extends DisplayFrame implements ActionListener {

    private JButton okButton;
    private TimestampPanel fromTS,toTS;

    public static final String INSTANT = "instant";
    public static final String SUMMARY = "summary";
    public static final String HISTORY = "history";

    private static final String fdGrids = "fdGrids";
    private static final String summaryGrids = "summaryGrids";

    private String gridPath;

    private String simulationName;

    private JRadioButton instantGridsRadioButton,summaryGridsRadioButton;
    private ButtonGroup bg;

    private final int MINIMUM_IMAGE_SIZE = IDSSAppConstants.MINIMUM_IMAGE_SIZE_FOR_ANIM;

    private final String serverResultsAddress = "http://" + IDSSAppConstants.ip + ":8000/idss/results/";

    private int timeStepHrs;
    private int simStartYear = 2000;
    private int simEndYear;

    private JComboBox gridDataCategory;
    private SurfaceColor sc;


    private JTextField simNameTextField;
    private JComboBox timeStepHrsCombo;




    //public GridViewControlApplet(String simName,int startYear,int endYear,int timeStep) {   //timestep in hrs

    public GridViewControlApplet() {

        super("Visualization",false,true,false,true,null);

/**
        simulationName = simName;
        timeStepHrs = timeStep;
        simStartYear = startYear;
        simEndYear = endYear;
**/

        gridPath = fdGrids;

        //Make the GUI

        //Parameters input components, because of a bug in J2EE

        simNameTextField = new JTextField(10);

        Vector v2 = new Vector();
        v2.add(new Integer(1));
        v2.add(new Integer(6));
        v2.add(new Integer(12));
        v2.add(new Integer(24));
        v2.add(new Integer(240));

        timeStepHrsCombo = new JComboBox(v2);

        JPanel paramPanel1 = new JPanel();
        paramPanel1.setLayout(new BoxLayout(paramPanel1,BoxLayout.X_AXIS));

        paramPanel1.add(Box.createHorizontalStrut(5));
        paramPanel1.add(new JLabel("SimName:"));
        paramPanel1.add(simNameTextField);
        paramPanel1.add(Box.createHorizontalGlue());
        paramPanel1.add(new JLabel("Timestep hrs:"));
        paramPanel1.add(timeStepHrsCombo);

        //Parameters input components, because of a bug in J2EE -- end


        fromTS = new TimestampPanel("From: ",2000,2100);
        toTS = new TimestampPanel("To: ",2000,2100);

        JLabel gridType = new JLabel("Grid type:");
        okButton = new JButton(IDSSAppConstants.okButtonText);
        okButton.addActionListener(this);
        okButton.setActionCommand(IDSSAppConstants.okButtonCommand);

        instantGridsRadioButton = new JRadioButton("Instant",true);
        summaryGridsRadioButton = new JRadioButton("Summary",false);

        instantGridsRadioButton.addActionListener(this);
        summaryGridsRadioButton.addActionListener(this);

        instantGridsRadioButton.setActionCommand(INSTANT);
        summaryGridsRadioButton.setActionCommand(SUMMARY);

        bg = new ButtonGroup();
        bg.add(instantGridsRadioButton);
        bg.add(summaryGridsRadioButton);

        gridDataCategory = new JComboBox(GridCell.getParametersVector());
        gridDataCategory.setEnabled(false);

        JPanel radioPanel = new JPanel();
        radioPanel.setLayout(new BoxLayout(radioPanel,BoxLayout.X_AXIS));
        radioPanel.setBorder(BorderFactory.createEtchedBorder());
        radioPanel.add(instantGridsRadioButton);
        radioPanel.add(summaryGridsRadioButton);

        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel,BoxLayout.X_AXIS));
        buttonPanel.setBorder(BorderFactory.createEtchedBorder());

        buttonPanel.add(Box.createHorizontalStrut(5));
        buttonPanel.add(gridType);
        buttonPanel.add(Box.createHorizontalStrut(5));
        buttonPanel.add(radioPanel);
        buttonPanel.add(Box.createHorizontalGlue());

        JPanel okButtonPanel = new JPanel();
        okButtonPanel.setLayout(new BoxLayout(okButtonPanel,BoxLayout.X_AXIS));

        okButtonPanel.add(gridDataCategory);
        okButtonPanel.add(Box.createHorizontalGlue());
        okButtonPanel.add(okButton);

        getContentPane().setLayout(new BoxLayout(getContentPane(),BoxLayout.Y_AXIS));
        getContentPane().add(fromTS);
        getContentPane().add(toTS);
        getContentPane().add(Box.createVerticalStrut(10));
        getContentPane().add(buttonPanel);
        getContentPane().add(Box.createVerticalStrut(5));
        getContentPane().add(okButtonPanel);
        getContentPane().add(Box.createVerticalStrut(10));
        getContentPane().add(paramPanel1);




        getContentPane().setBackground(Color.lightGray);
        pack();
        setVisible(true);


    } //public GridViewControlApplet(String simName)








    public void resetYearCombo(int startYear, int endYear) {

        fromTS.resetYearCombo(startYear,endYear);
        toTS.resetYearCombo(startYear,endYear);

    } //public void resetYearCombo(int startYear, int endYear)





    public void actionPerformed(ActionEvent ae) {



        if(ae.getActionCommand().equals(IDSSAppConstants.okButtonCommand)) {

            System.out.println("OK button pressed, gridPath : " + gridPath);


            simulationName = simNameTextField.getText();
            timeStepHrs = ((Integer)timeStepHrsCombo.getSelectedItem()).intValue();
            System.out.println("timeStepHrs : " + timeStepHrs);


            if(simulationName != null && simulationName.length() > 0) {

                System.out.println("simulationName.length() : " + simulationName.length());
                System.out.println("simulationName : " + simulationName);

                Vector images = new Vector();

                if(gridPath == fdGrids) {

                    Vector urlNames = getURLNames();
                    images = getImages(urlNames);

                } //if(gridPath == fdGrids)

                else if(gridPath == summaryGrids) {

                    Vector urlNames = getURLNames2();
                    images = getImages2(urlNames);

                } //else if(gridPath == summaryGrids)


                AnimationFrameApplet animFrame = new AnimationFrameApplet(simulationName,images);
                firePropertyChange(IDSSAppConstants.addToModelView,null,animFrame);


                if(sc != null) {

                    ImageDisplay legendFrame = new ImageDisplay("Legend",sc.getLegendWidth(),
                                            sc.getLegendHeight());

                    firePropertyChange(IDSSAppConstants.addToModelView,null,legendFrame);
                    sc.drawLegend(legendFrame);

                } //if(sc != null)

            } //if(simulationName != null && simulationName.length() > 0)

        } //if(ae.getActionCommand(IDSSAppConstants.okButtonCommand))



        else if (ae.getActionCommand().equals(INSTANT)) {

            gridPath = fdGrids;
            gridDataCategory.setEnabled(false);
            System.out.println("RadioButton clicked, gridPath : " + gridPath);

        } //else if (ae.getActionCommand().equals(INSTANT))


        else if (ae.getActionCommand().equals(SUMMARY)) {

            gridPath = summaryGrids;
            gridDataCategory.setEnabled(true);
            System.out.println("RadioButton clicked, gridPath : " + gridPath);

        } //else if (ae.getActionCommand().equals(SUMMARY))



    } //public void actionPerformed(ActionEvent ae)






    private Vector getImages(Vector urlNames) {


        double zMin = 9999;
        double zMax = -9999;

        Vector grids = new Vector();

        for(int i=0;i<urlNames.size();i++) {

            URL url = (URL)urlNames.elementAt(i);
            Grid g = (Grid)ObjectReadWrite.read(url);

            if(g != null) {

                g.setZMinMax();
                grids.add(g);

                zMin = Math.min(zMin,g.getZMin());
                zMax = Math.max(zMax,g.getZMax());

            } //if(g != null)

        } //for(int i=0;i<urlNames.size();i++)

        sc = new SurfaceColor("Flood Grids",zMin,zMax,SurfaceColor.FLOOD);

        Vector images = new Vector();

        for(int i=0;i<grids.size();i++) {

            Grid g = (Grid)grids.elementAt(i);

            String name = g.getName();
            BufferedImage bi = g.getImage(sc);

            Vector oneRow = new Vector();
            oneRow.add(name);
            oneRow.add(bi);

            images.add(oneRow);

        } //for(int i=0;i<grids.size();i++)


        return images;

    } //private Vector getImages(Vector urlNames)








    private Vector getImages2(Vector urlNames) {

        double zMin = 9999;
        double zMax = -9999;

        String dataCategory = (String)gridDataCategory.getSelectedItem();

        Vector grids = new Vector();

        for(int i=0;i<urlNames.size();i++) {

            URL url = (URL)urlNames.elementAt(i);
            Grid2 g2 = (Grid2)ObjectReadWrite.read(url);

            if(g2 != null) {

                Grid g = g2.getGrid(dataCategory);

                if(g != null) {

                    g.setZMinMax();
                    grids.add(g);

                    zMin = Math.min(zMin,g.getZMin());
                    zMax = Math.max(zMax,g.getZMax());

                } //if(g != null)

            }//if(g2 != null)

        } //for(int i=0;i<urlNames.size();i++)

        //sc = new SurfaceColor("Flood Grids",zMin,zMax,SurfaceColor.FLOOD);


        SurfaceColor scForFlood = new SurfaceColor("Flood Grids",zMin,zMax,SurfaceColor.FLOOD);
        SurfaceColor scForProbability = new SurfaceColor("Probability Grids",0,1,SurfaceColor.DEM);
        double d = 365.0*24*60.0*60.0*1000.0;
        SurfaceColor scForTime = new SurfaceColor("Time Length",SurfaceColor.TIMECOLORSCHEMEUPTOAYEAR);

        if(dataCategory == IDSSAppConstants.highestDepthOfFlooding) {

            sc = scForFlood;

        }

        else if(dataCategory == IDSSAppConstants.minimumProbabilityOfSurvival) {

            sc = scForProbability;

        }

        else {

            sc = scForTime;
        }


        Vector images = new Vector();

        for(int i=0;i<grids.size();i++) {

            Grid g = (Grid)grids.elementAt(i);

            String name = g.getName();
            BufferedImage bi = g.getImage(sc);

            Vector oneRow = new Vector();
            oneRow.add(name);
            oneRow.add(bi);

            images.add(oneRow);

        } //for(int i=0;i<grids.size();i++)


        return images;

    } //private Vector getImages2(Vector urlNames)





    private Vector getURLNames2() {

        Vector urlNames = new Vector();

        try {

            String year1 = fromTS.getYear();
            String year2 = toTS.getYear();

            int iStart = Integer.parseInt(year1);
            int iEnd = Integer.parseInt(year2);

            String s = "http://" + IDSSAppConstants.ip + ":8000/idss/results/" + simulationName + "/" + gridPath + "/";

            for(int i=iStart;i<=iEnd;i++) {

                String s2 = String.valueOf(i);
                String s3 = s + "SUM" + s2;
                URL url = new URL(s3);
                urlNames.add(url);
            
            } //for(int i=iStart;i<=iEnd;i++)

        } //try


        catch(MalformedURLException mfe) {

            System.out.println("GridViewControlApplet.getURLNames2()" + mfe.toString());

        } //catch(MalformedURLException mfe)

        catch(NumberFormatException mfe) {

            System.out.println("GridViewControlApplet.getURLNames2()" + mfe.toString());

        } //catch(NumberFormatException mfe)



        for(int i=0;i<urlNames.size();i++) {

            URL u = (URL)urlNames.elementAt(i);
            System.out.println(u.toString());

        } //for(int i=0;i<urlNames.size();i++)

        return urlNames;


    } //private Vector getURLNames2()







    private Vector getURLNames() {


        String year1 = fromTS.getYear();
        String month1 = fromTS.getMonth();
        String day1 = fromTS.getDay();

        String year2 = toTS.getYear();
        String month2 = toTS.getMonth();
        String day2 = toTS.getDay();


        //Determine starting and ending filename

        Calendar cal = Calendar.getInstance();
        cal.set(simStartYear,0,1,0,0,0);
        Timestamp currentTimestamp = new Timestamp(cal.getTime().getTime());

        Timestamp animStartTS = Timestamp.valueOf(year1+"-"+month1+"-"+day1+" 00:00:00");
                                                        //yyyy-mm-dd hh:mm:ss.fffffffff

        Timestamp animEndTS = Timestamp.valueOf(year2+"-"+month2+"-"+day2+" 00:00:00");


        while(currentTimestamp.before(animStartTS)) {

            long t = currentTimestamp.getTime() + timeStepHrs*3600000;      //timeStepHrs is converted to millisecs
            currentTimestamp = new Timestamp(t);

        } //while(currentTimestamp.before(animStartTS))

        Timestamp startFileNameTS = currentTimestamp;


        while(currentTimestamp.before(animEndTS)) {

            long t = currentTimestamp.getTime() + timeStepHrs*3600000;      //timeStepHrs is converted to millisecs
            currentTimestamp = new Timestamp(t);

        } //while(currentTimestamp.before(animEndTS))

        Timestamp endFileNameTS = currentTimestamp;

        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        Vector urlNames = new Vector();

        long startFileNameTSLong = startFileNameTS.getTime();
        long endFileNameTSLong = endFileNameTS.getTime();
        long timeStepLong = timeStepHrs*3600000;

        String s = "http://" + IDSSAppConstants.ip + ":8000/idss/results/" + simulationName + "/" + gridPath + "/";

        try {

            for(long i = startFileNameTSLong; i <= endFileNameTSLong; i += timeStepLong) {

                Timestamp ts = new Timestamp(i);
                String fileName = "FD" + dateFormat.format(ts);

                URL url = new URL(s + fileName);
                urlNames.add(url);

            } //for(long i = startFileNameTSLong; i <= endFileNameTSLong; i += timeStepLong)

        } //try

        catch(MalformedURLException mfe) {

            System.out.println("GridViewControlApplet.getURLNames()" + mfe.toString());

        } //catch(MalformedURLException mfe)


        for(int i=0;i<urlNames.size();i++) {

            URL u = (URL)urlNames.elementAt(i);
            System.out.println(u.toString());

        } //for(int i=0;i<urlNames.size();i++)

        return urlNames;

    } //private Vector getURLNames()






/**

        if(ae.getActionCommand().equals(IDSSAppConstants.describeButtonCommand)) {

            File aFile = new File(currentFileName);
            Grid aGrid = null;

            if (gridsType == INSTANT) {

                aGrid = (Grid) Grid.readGridObject(aFile);
            }

            else if (gridsType == SUMMARY) {

                String dataCategory = (String) dataCategoryCombo.getSelectedItem();

                Grid2 aGrid2 = (Grid2) Grid2.readGrid2Object(aFile);
                aGrid = aGrid2.getGrid(dataCategory);

            }


            if(aGrid != null) {
                describeGrid(aGrid);
            }


        } //if(ae.getActionCommand().equals(IDSSAppConstants.describeButtonCommand))


        else if(ae.getActionCommand().equals(IDSSAppConstants.newButtonCommand)) {

            getNewGrid();

        } //if(ae.getActionCommand().equals(IDSSAppConstants.newButtonCommand))


        else if(ae.getActionCommand().equals(IDSSAppConstants.disposeButtonCommand)) {

            removeFromGrids();

        } //else if(ae.getActionCommand().equals(IDSSAppConstants.disposeButtonCommand))

        else if(ae.getActionCommand().equals(IDSSAppConstants.runButtonCommand)) {

            runAnimation();

        } //else if(ae.getActionCommand().equals(IDSSAppConstants.runButtonCommand))


    } //public void actionPerformed(ActionEvent ae)





    private SurfaceColor getDefaultSC() {

        Vector z = new Vector();
        Vector r = new Vector();
        Vector g = new Vector();
        Vector b = new Vector();

        z.add(new Double(0));
        z.add(new Double(1.8));
        z.add(new Double(3.6));
        z.add(new Double(5.4));
        z.add(new Double(7.2));

        r.add(new Double(0));
        r.add(new Double(.2));
        r.add(new Double(1));
        r.add(new Double(.2));
        r.add(new Double(0));

        g.add(new Double(.25));
        g.add(new Double(0));
        g.add(new Double(0));
        g.add(new Double(0));
        g.add(new Double(0));

        b.add(new Double(0));
        b.add(new Double(0.25));
        b.add(new Double(0.50));
        b.add(new Double(0.75));
        b.add(new Double(1.0));

        SurfaceColor sc = new SurfaceColor("Grids Animation",z,r,g,b);
        return sc;

    } //private SurfaceColor getDefaultSC()



















    private void runAnimation() {


        Vector gridsVector = new Vector();

        //Enumeration grids = gridsListVector.elements();

        //GeneralTableModel tm = (GeneralTableModel) gridsTable.getModel();
        //int numberOfRows = tm.getNumberOfRows();

        if (gridsType == INSTANT) {

            double zMin = 9999;
            double zMax = -9999;

            for(int i=0;i<gridsListVector.size();i++) {

                File aFile = (File)gridsListVector.elementAt(i);
                Grid aGrid = (Grid) Grid.readGridObject(aFile);

                zMin = Math.min(zMin,aGrid.getZMin());
                zMax = Math.max(zMax,aGrid.getZMax());

            } //for(int i=0;i<gridsListVector.size();i++)

            SurfaceColor scForFlood = new SurfaceColor("Flood Grids",zMin,zMax,SurfaceColor.FLOOD);


            for(int i=0;i<gridsListVector.size();i++) {

                File aFile = (File)gridsListVector.elementAt(i);
                Grid aGrid = (Grid) Grid.readGridObject(aFile);

                Vector oneRow = writeImgFiles(scForFlood,aGrid);
                gridsVector.add(oneRow);

            }//for(int i=0;i<gridsListVector.size();i++)

            addAnimationToDesktop("Frames of instant flood grids",gridsVector,scForFlood);

        } //if (gridsType == INSTANT)


        else if (gridsType == SUMMARY) {

            String dataCategory = (String) dataCategoryCombo.getSelectedItem();
            double zMin = 9999;
            double zMax = -9999;

            //System.out.println("gridsType = " + gridsType +", dataCategory = " + dataCategory);

            if(dataCategory == IDSSAppConstants.highestDepthOfFlooding) {

                for(int i=0;i<gridsListVector.size();i++) {

                    //System.out.println("determining zMin and zMax");

                    File aFile = (File)gridsListVector.elementAt(i);
                    Grid2 aGrid2 = (Grid2) Grid2.readGrid2Object(aFile);
                    Grid aGrid = aGrid2.getGrid(dataCategory);

                    zMin = Math.min(zMin,aGrid.getZMin());
                    zMax = Math.max(zMax,aGrid.getZMax());

                    //System.out.println("zMin,zMax = " + zMin +"," + zMax);

                }//for(int i=0;i<gridsListVector.size();i++)

            } //if(dataCategory == IDSSAppConstants.highestDepthOfFlooding)

            SurfaceColor scForFlood = new SurfaceColor("Flood Grids",zMin,zMax,SurfaceColor.FLOOD);
            SurfaceColor scForProbability = new SurfaceColor("Probability Grids",0,1,SurfaceColor.DEM);
            double d = 365.0*24*60.0*60.0*1000.0;
            SurfaceColor scForTime = new SurfaceColor("Time Length",SurfaceColor.TIMECOLORSCHEMEUPTOAYEAR);

            for(int i=0;i<gridsListVector.size();i++) {

                File aFile = (File)gridsListVector.elementAt(i);
                Grid2 aGrid2 = (Grid2) Grid2.readGrid2Object(aFile);
                Grid aGrid = aGrid2.getGrid(dataCategory);

                Vector oneRow = null;


                if(dataCategory == IDSSAppConstants.highestDepthOfFlooding) {
                    //oneRow.add(aGrid.getImage(scForFlood));
                    oneRow = writeImgFiles(scForFlood,aGrid);

                }



                else if(dataCategory == IDSSAppConstants.minimumProbabilityOfSurvival) {
                    //oneRow.add(aGrid.getImage(scForProbability));
                    oneRow = writeImgFiles(scForProbability,aGrid);

                }

                else {
                    //oneRow.add(aGrid.getImage(scForTime));
                    oneRow = writeImgFiles(scForTime,aGrid);
                }

                gridsVector.add(oneRow);

            }//for(int i=0;i<gridsListVector.size();i++)



            if(dataCategory == IDSSAppConstants.highestDepthOfFlooding)
                addAnimationToDesktop("Frames of yearly summary",gridsVector,scForFlood);
            else if(dataCategory == IDSSAppConstants.minimumProbabilityOfSurvival)
                addAnimationToDesktop("Frames of yearly summary",gridsVector,scForProbability);
            else
                addAnimationToDesktop("Frames of yearly summary",gridsVector,scForTime);


        } //else if (gridsType == SUMMARY)


        else if (gridsType == HISTORY) {

            String dataCategory = (String) dataCategoryCombo.getSelectedItem();
            SurfaceColor sc = getDefaultSC();

            for(int i=0;i<gridsListVector.size();i++) {

                File aFile = (File)gridsListVector.elementAt(i);
                LCGrid2 lcGrid2 = (LCGrid2) LCGrid2.readLCGrid2Object(aFile);

                Enumeration years = lcGrid2.getYears();

                if(years != null) {

                    while(years.hasMoreElements()) {

                        Integer aYear = (Integer) years.nextElement();
                        Grid aGrid = lcGrid2.getGrid(dataCategory,aYear.intValue());

                        Vector oneRow = writeImgFiles(sc,aGrid);
                        gridsVector.add(oneRow);


                        //Vector oneRow = new Vector();
                        //oneRow.add(aGrid.getImage(sc));
                        //oneRow.add(aGrid.getName());
                        //gridsVector.add(oneRow);

                    } //while(years.hasMoreElements())

                } //if(years != null)

            }//for(int i=0;i<gridsListVector.size();i++)

        } //else if (gridsType == HISTORY)


    } //private void runAnimation()







    private Vector writeImgFiles(SurfaceColor sc,Grid aGrid) {

        BufferedImage bi = aGrid.getImage(sc);
        BufferedImage bi2 = null;

        if ((bi.getWidth() < MINIMUM_IMAGE_SIZE) && (bi.getHeight() < MINIMUM_IMAGE_SIZE)) {

            int longSide = Math.max(bi.getWidth(),bi.getHeight());
            int ratio = MINIMUM_IMAGE_SIZE / longSide;

            bi2 = new BufferedImage (bi.getWidth()*ratio,bi.getHeight()*ratio,BufferedImage.TYPE_INT_RGB);
            Graphics g2 = bi2.getGraphics();
            g2.drawImage(bi,0,0,bi2.getWidth(),bi2.getHeight(),0,0,bi.getWidth(),bi.getHeight(),null);

        }

        else {
            bi2 = bi;
        }


        File tempDir = new File(IDSSAppConstants.tempDir);
        if(!tempDir.exists())
            tempDir.mkdirs();

        //File tempOutFile = new File(tempDir,FileNameDialog.getTempFileName());
        File tempOutFile = new File(tempDir,FileNameDialog.getTempImgFileName());

        tempOutFile.deleteOnExit();

        if(tempOutFile.exists())
            tempOutFile.delete();


        try {
            ImageIO.write(bi2, "png", tempOutFile);
        }

        catch(javax.imageio.IIOException ie) {

            System.out.println("GridViewColtrol.writeImgFiles(), " + ie.toString());

        } //catch(javax.imageio.IIOException ie)


        Vector oneRow = new Vector();
        oneRow.add(tempOutFile);
        oneRow.add(aGrid.getName());

        return oneRow;

    } //private Vector writeImgFiles(SurfaceColor sc,Grid aGrid)























    private void addAnimationToDesktop(String animTitle,Vector gridsVector,SurfaceColor sc) {

        AnimationFrame animFrame = new AnimationFrame (animTitle,gridsVector);

        animFrame.removePropertyChangeListener(this);
        animFrame.addPropertyChangeListener(this);

        addToDesktop(animFrame);

        //This is to solve a bug thst JSliders don't appear in JInternalFrame
        Dimension dim = animFrame.getSize();
        //if (dim.width > 5) {
            dim.width = dim.width+100;
            animFrame.setSize(dim.width,dim.height);
        //}
        //This is to solve a bug thst JSliders don't appear in JInternalFrame - end


        ImageDisplay legendFrame = new ImageDisplay("Legend",sc.getLegendWidth(),
                                        sc.getLegendHeight());

        addToDesktop(legendFrame);
        sc.drawLegend(legendFrame);


    } //private void addAnimationToDesktop(SurfaceColor sc)









    private void drawSummaryGrid(Grid2 aGrid2) {

        String dataCategory = (String) dataCategoryCombo.getSelectedItem();
        Grid currentGrid = aGrid2.getGrid(dataCategory);
        drawGrid(currentGrid);

    } //private void drawSummaryGrid(Grid currentGrid)








    private void drawGrid(Grid currentGrid) {

        if (!currentGrid.isRead()) {
            currentGrid.read();
        }


        Vector z = new Vector();
        Vector r = new Vector();
        Vector g = new Vector();
        Vector b = new Vector();

        z.add(new Double(0));
        z.add(new Double(1.8));
        z.add(new Double(3.6));
        z.add(new Double(5.4));
        z.add(new Double(7.2));


        //z.add(new Double(5));
        //z.add(new Double(100));


        r.add(new Double(0));
        r.add(new Double(.2));
        r.add(new Double(1));
        r.add(new Double(.2));
        r.add(new Double(0));

        g.add(new Double(1));
        g.add(new Double(.75));
        g.add(new Double(.5));
        g.add(new Double(.25));
        g.add(new Double(0));

        b.add(new Double(0));
        b.add(new Double(0.25));
        b.add(new Double(0.50));
        b.add(new Double(0.75));
        b.add(new Double(1.0));

        SurfaceColor sc = new SurfaceColor(currentGrid.getName(),z,r,g,b);

        GridDisplay gridDisplay = new GridDisplay(currentGrid.getName());
        //gridDisplay.drawGrid(currentGrid,sc);
        currentGrid.draw(gridDisplay,sc);
        addToDesktop(gridDisplay);

        System.out.println("sc.getLegendWidth(),sc.getLegendHeight() : " + sc.getLegendWidth() + ", "
                            + sc.getLegendHeight());

        ImageDisplay legendFrame = new ImageDisplay(currentGrid.getName()+
                                        ":Legend",sc.getLegendWidth(),
                                        sc.getLegendHeight());

        addToDesktop(legendFrame);
        sc.drawLegend(legendFrame);

    } //private void drawGrid()






    public void getNewGrid() {

        File filePath = null;

        if(currentFileName != null) {

            File currentFile = new File(currentFileName);
            filePath = currentFile.getParentFile();

        }//if(currentFileName != null)

        File [] aFileList = FileNameDialog.getInputFileNames("Pick new Grid...",filePath,null);

        if(aFileList != null) {

            for(int i=0;i<aFileList.length;i++) {

                File aFile = aFileList[i];

                if ((aFile != null) && (aFile.exists())) {

                    addToGrids(aFile);

                } //if ((aFile != null) && (aFile.exists()))


                else
                    System.out.println("GridManager.getNewGrid(), file is null");



            } //for(int i=0;i<aFileList.length;i++)

        } //if(aFileList != null)

    } //public void getNewGrid()




    private void addToDesktop(DisplayFrame panel) {

        if(panel == null)
            System.out.println("GridViewControlApplet.addToDesktop(), panel is null");

        firePropertyChange(IDSSAppConstants.addToModelView,null,panel);

    }//private void addToDesktop(DisplayFrame panel)






    //public void addToGrids(GenericGrid grid) {
    public void addToGrids(File aFile) {


        if(!gridsListVector.contains(aFile)) {

            gridsListVector.add(aFile);

            GeneralTableModel tm = (GeneralTableModel) gridsTable.getModel();
            Vector oneRow = new Vector();
            oneRow.add(aFile.toString());
            tm.addRow(oneRow);
            gridsTable.setModel(tm);

            if(gridsListVector.size()>0)
                runButton.setEnabled(true);
            else
                runButton.setEnabled(false);

        } //if(!gridsListVector.contains(aFile))



    } //public void addToDataSet(File aFile)






    private void removeFromGrids() {

        drawButton.setEnabled(false);
        disposeButton.setEnabled(false);

        File currentFile = new File(currentFileName);
        gridsListVector.remove(currentFile);

        GeneralTableModel tm = (GeneralTableModel) gridsTable.getModel();

        tm.removeRow(currentRow);
        gridsTable.setModel(tm);
        if(gridsListVector.size()>0)
            runButton.setEnabled(true);
        else
            runButton.setEnabled(false);


    } //private void removeFromGrids()








    private void describeGrid(Grid aGrid) {

        DocumentDisplay aDocDisplay =
            new DocumentDisplay ("Describing :" + aGrid.getName(),aGrid.showdescription(),"text/HTML");

        addToDesktop(aDocDisplay);

    } //private void describeGrid(Grid aGrid)




    public void propertyChange(PropertyChangeEvent evt) {


        if(evt.getPropertyName().equals(IDSSAppConstants.addToModelView)) {

            firePropertyChange(evt.getPropertyName(),evt.getOldValue(),evt.getNewValue());

        } //if(evt.getPropertyName().equals(IDSSAppConstants.addToModelView))


        if(evt.getPropertyName().equals(IDSSAppConstants.removeFromModelView)) {

            firePropertyChange(evt.getPropertyName(),evt.getOldValue(),evt.getNewValue());

        } //if(evt.getPropertyName().equals(IDSSAppConstants.removeFromModelView))


    } //public void propertyChange(PropertyChangeEvent evt)

**/






} //public class GridViewControlApplet extends JFrame implements ActionListener

