/*
 * $Id: main.java,v 1.3 2000/02/17 04:12:12 mode Exp $
 *
 * Copyright (c) 1998 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Sun grants you ("Licensee") a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Sun.
 *
 * This software is provided "AS IS," without a warranty of any kind. ALL
 * EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
 * IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE
 * LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
 * OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS
 * LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
 * INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
 * CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
 * OR INABILITY TO USE SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *
 * This software is not designed or intended for use in on-line control of
 * aircraft, air traffic, aircraft navigation or aircraft communications; or in
 * the design, construction, operation or maintenance of any nuclear
 * facility. Licensee represents and warrants that it will not use or
 * redistribute the Software for such purposes.
 */

import java.io.*;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.*;

public class main
{
    //
    // Simple demonstration of document construction with DOM,
    // with deep and shallow modes of cloning. 
    //
    // Also, that real applications have real exception handling! 
    //
    public static void main (String argv [])
    throws IOException, DOMException, ParserConfigurationException
    {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance ();
	DocumentBuilder db = dbf.newDocumentBuilder ();
	Document doc = db.newDocument ();
	Element root = doc.createElement ("root");
	Attr		tmp;
	Writer		out = new OutputStreamWriter (System.out);

	doc.appendChild (root);

	out.write ("No children ...\n");
	out.write ("\n");
	out.flush ();
	doClones (out, root);

	root.appendChild (doc.createElement ("header"));
	root.appendChild (doc.createTextNode ("\n  some data is text\n  "));
	root.appendChild (doc.createElement ("footer"));

	// White space is added to help people read XML documents.
	// In content models with text, it's not ignorable; in
	// other content models, applications can discard it.
	Text		text;

	// The portable way to get the first item from the root is
	// root.getChildren ().item (0) ... and you'd need to test for
	// a null list of children too, so it's actually multiple lines
	// when coded safely.
	text = doc.createTextNode ("\n");
	root.insertBefore (text, root.getFirstChild ());

	text = doc.createTextNode ("\n");
	root.appendChild (text);

	out.write ("Cloning ... mixed content model ...\n");
	out.write ("\n");
	out.flush ();
	doClones (out, root);
    
	// This is one way to create an attribute ...
	tmp = doc.createAttribute ("attr1");
	tmp.setNodeValue ("value of attribute 1");
	root.getAttributes ().setNamedItem (tmp);

	// ... and this is another (simpler, and far preferable)
	root.setAttribute ("attr2", "another string");

	out.write ("Cloning with attributes... and attributes...\n");
	out.write ("\n");
	out.flush ();
	doClones (out, root);

	System.exit (0);
    }

    private static void doClones (Writer out, Element root)
    throws IOException
    {
        Element clone1;
    
        clone1 =  (Element)root.cloneNode (false);
    
        out.write ("Finished SHALLOW CLONE:\t");
	out.write ("\n");
	out.flush ();

        Element clone2;
    
        clone2 =  (Element)root.cloneNode (true);
    
        out.write ("Finished DEEP CLONE:\t");
	out.write ("\n");
	out.flush ();
    }
}
