/*
 * @(#)ShowElement.java	1.10 98/10/19
 *
 * Copyright (c) 1998 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Sun grants you ("Licensee") a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Sun.
 *
 * This software is provided "AS IS," without a warranty of any kind. ALL
 * EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
 * IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE
 * LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
 * OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS
 * LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
 * INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
 * CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
 * OR INABILITY TO USE SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *
 * This software is not designed or intended for use in on-line control of
 * aircraft, air traffic, aircraft navigation or aircraft communications; or in
 * the design, construction, operation or maintenance of any nuclear
 * facility. Licensee represents and warrants that it will not use or
 * redistribute the Software for such purposes.
 */

package project;

import java.io.Writer;
import java.util.Enumeration;

import javax.swing.tree.TreeNode;

import com.sun.xml.tree.ElementNode;

import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;


public class ShowElement extends ElementNode implements TreeNode
{
    public ShowElement () {
    };
    
    // used by JTree to display this node
    public String toString ()
    {
	StringBuffer	value = new StringBuffer ();
	value.append ('<');
	value.append (getTagName ());
	value.append (getAttributes ().toString ());
	value.append ('>');
	return value.toString ();
    }
    
    // TreeNode method implementations
    public TreeNode getChildAt (int n) {
    	//System.out.println ("ShowElement.getChildAt()");
	Node		node = item (n);
	
	if (node instanceof TreeNode)
            return (TreeNode) node;
        // Text, ProcessingInstruction ...
        return new MaskedNode (node);
    }
    
    //
    // In this case we really _do_ want to show all the internal
    // nodes, so we really ought to use custom TreeNode and
    // ProcessingInstruction classes as we build.
    //
    static class MaskedNode implements TreeNode {
    	private Node	real;
    	MaskedNode (Node e) { real = e; }
    	
    	public int getChildCount () { return 0; }
    	public TreeNode getChildAt (int n) { return null; }
    	public TreeNode getParent ()
    		{ return (TreeNode) real.getParentNode (); }
    	public int getIndex (TreeNode node) { return -1; }
    	public boolean getAllowsChildren () { return false; }
    	public boolean isLeaf () { return true; }
    	public Enumeration children () { return null; }
    	
    	public String toString () {
    	    if (real instanceof Text)
    	       return real.toString ();		// XXX constructor
    	    if (real instanceof ProcessingInstruction)
    	       return real.toString ();		// XXX unreasonable result
    	    return "... ? ...";
    	}
    }
    	
    
    public int getChildCount () {
    	return getLength ();
    }
    
    public TreeNode getParent () {
        return (TreeNode) getParentNode ();
    }
    
    public int getIndex (TreeNode node) {
        return -1;                  // XXX implement
    }
    
    public boolean getAllowsChildren () {
        return true;
    }
    
    public boolean isLeaf () {
        return !hasChildNodes ();
    }
    
    public Enumeration children () {
    	//System.out.println ("ShowElement.children()");

	throw new RuntimeException ("NYI");
    }
    
}
