/*
 * $Id: main.java,v 1.3 2000/02/17 04:13:09 mode Exp $
 *
 * Copyright (c) 1998 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Sun grants you ("Licensee") a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Sun.
 *
 * This software is provided "AS IS," without a warranty of any kind. ALL
 * EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
 * IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE
 * LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
 * OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS
 * LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
 * INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
 * CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
 * OR INABILITY TO USE SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *
 * This software is not designed or intended for use in on-line control of
 * aircraft, air traffic, aircraft navigation or aircraft communications; or in
 * the design, construction, operation or maintenance of any nuclear
 * facility. Licensee represents and warrants that it will not use or
 * redistribute the Software for such purposes.
 */

import java.io.*;
import org.w3c.dom.*;
import org.xml.sax.*;
import com.sun.xml.tree.*;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.DocumentBuilder;

public class main
{
    //
    // Simple demonstration of namespace support used
    // in conjunction with DOM.
    //
    // Note that namespace support is not part of DOM Level 1. Hence we need to
    // use com.sun.xml.tree.* here in this example
    //
    public static void main (String argv [])
    throws IOException
    {
	String		uri;
	XmlDocument	doc;

	if (argv.length != 1) {
	    System.err.println ("Usage: cmd filename");
	    System.exit (1);
	}

	try {
	    //
	    // turn the filename into a fully qualified URL
	    //
	    uri = "file:" + new File (argv [0]).getAbsolutePath ();

	    //
	    // turn it into an in-memory object ... we couple the
	    // parser and builder bidirectionally to ensure that 
	    // the parser enforces namespace syntax rules (which
	    // add constraints that XML 1.0 doesn't have).
	    //

	    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance ();
	    dbf.setNamespaceAware (true);
	    DocumentBuilder db = dbf.newDocumentBuilder ();
	    doc = (XmlDocument)db.parse (uri);

	    //
	    // write out its namespace info
	    //
	    dumpNamespaces (0,
		(ElementNode) doc.getDocumentElement (),
		new OutputStreamWriter (System.out));

	}catch (SAXException e) {
	    Exception	x = e;
	    if (e.getException () != null)
		x = e.getException ();
	    x.printStackTrace ();

	} catch (Throwable t) {
	    t.printStackTrace ();
	}

	System.exit (0);
    }

    private static void dumpNamespaces (
	int		indent,
	ElementNode	node,
	Writer		w
    ) throws IOException
    {
	doIndent (indent, w);
	w.write ("Element Local Part = " + node.getLocalName () + "\n");
	doIndent (indent, w);
	w.write ("Element Namespace  = " + node.getNamespace () + "\n");

	NamedNodeMap	attributes = node.getAttributes ();
	int		length = attributes.getLength ();

	indent += 4;
	for (int i = 0; i < length; i++) {
	    NamespaceScoped	attr = (NamespaceScoped) attributes.item (i);

	    if (attr.getNodeName ().startsWith ("xml"))
		continue;
	    doIndent (indent, w);
	    w.write ("Attribute Local Part = " + attr.getLocalName () + "\n");
	    doIndent (indent, w);
	    w.write ("Attribute Namespace  = " + attr.getNamespace () + "\n");
	}

	w.flush ();

	indent -= 2;
	for (Node n = node.getFirstChild ();
		n != null;
		n = n.getNextSibling ())
	    if (n.getNodeType () == Node.ELEMENT_NODE)
		dumpNamespaces (indent, (ElementNode) n, w);
    }

    private static void doIndent (int indent, Writer w)
    throws IOException
    {
	for ( ; indent >= 8; indent -= 8)
	    w.write ('\t');
	for ( ; indent > 0; indent -= 1)
	    w.write (' ');
    }
}
