package iDSS;



import java.io.*;
import java.awt.*;
import java.awt.image.*;
import javax.imageio.*;

import iDSS.grids.*;
import iDSS.utils.*;
import iDSS.gridDisp.*;



public class ImageIOTest {


    public static void main (String args[]) {


        try {

            int MINIMUM_IMAGE_SIZE = 200;
            BufferedImage bi2;
            BufferedImage bi;

            File file = new File("f:\\iDSSApplet\\iDSS\\demGrids\\normalDEM.txt");

            Grid currentGrid = new Grid("TestGrid",IDSSAppConstants.gridTypeDEM,0,file);
            if(!currentGrid.isRead())
                currentGrid.read();


            SurfaceColor sc = new SurfaceColor(currentGrid.getName(),currentGrid.getZMin(),
                                            currentGrid.getZMax(),SurfaceColor.DEM);

            bi = currentGrid.getImage(sc);

            if ((bi.getWidth() < MINIMUM_IMAGE_SIZE) && (bi.getHeight() < MINIMUM_IMAGE_SIZE)) {

                int longSide = Math.max(bi.getWidth(),bi.getHeight());
                int ratio = MINIMUM_IMAGE_SIZE / longSide;

                bi2 = new BufferedImage (bi.getWidth()*ratio,bi.getHeight()*ratio,BufferedImage.TYPE_INT_RGB);
                Graphics g2 = bi2.getGraphics();
                g2.drawImage(bi,0,0,bi2.getWidth(),bi2.getHeight(),0,0,bi.getWidth(),bi.getHeight(),null);

            }

            else {
                bi2 = bi;
            }

            File outFile = new File("TestGrid.png");

            if(outFile.exists())
                outFile.delete();

            System.out.println(ImageIO.write(bi2, "png", outFile));


        }//try

        catch(IOException e) {

            System.out.println(e.toString());

        } //

/**
        GridDisplay gridDisplay = new GridDisplay(currentGrid.getName());

        currentGrid.draw(gridDisplay,sc);

        firePropertyChange(IDSSAppConstants.addToModelView,null,gridDisplay);

        ImageDisplay legendFrame = new ImageDisplay(currentGrid.getName()+
                                        ":Legend",sc.getLegendWidth(),
                                        sc.getLegendHeight());

        firePropertyChange(IDSSAppConstants.addToModelView,null,legendFrame);
        sc.drawLegend(legendFrame);
**/

    } //public static void main (String args[])

} //public class ImageIOTest
