package iDSS;

import java.beans.*;
import java.util.*;
import javax.swing.*;


import iDSS.utils.*;
import iDSS.disp.*;
import iDSS.grids.*;
import iDSS.tidalData.*;
import iDSS.beans2.*;




public class ModelSetupController implements PropertyChangeListener {


    private ModelSetupView modelSetupView;
    private ModelSetupTree modelSetupTree;

    ModelSetupControllerJBean modelSetupControllerJBean;



    public ModelSetupController() {

        modelSetupTree = new ModelSetupTree
                    (IDSSAppConstants.modelSetupTreeName,400,300);
        modelSetupTree.addPropertyChangeListener(this);

        modelSetupView = new ModelSetupView
                    (IDSSAppConstants.modelSetupViewName,400,300);
        modelSetupView.addPropertyChangeListener(this);

        modelSetupControllerJBean = new ModelSetupControllerJBean();
        modelSetupControllerJBean.addPropertyChangeListener(this);

        StatusJBean statusBean = modelSetupControllerJBean.getStatusBean();
        modelSetupTree.setStatusBean(statusBean);

    } //public ModelSetupController()








    private void addToView(DisplayFrame panel) {

        modelSetupView.addToView(panel);

    } //private void addToView(DisplayFrame panel)




    private void removeAllFromView() {

        modelSetupView.removeAllFromView();

    } //private void removeAllFromView()




    private void removeFromView(DisplayFrame panel) {

        modelSetupView.removeFromView(panel);

    } //private void removeFromView(DisplayFrame panel)









    public void propertyChange(PropertyChangeEvent evt) {


        if (evt.getPropertyName().equals(IDSSAppConstants.addToModelView)) {

            DisplayFrame frame = (DisplayFrame)evt.getNewValue();

            if(frame != null) {

                addToView(frame);

            } //if(frame != null)

            else {

                if(IDSSAppConstants.debug)
                    System.out.println("ModelSetupTree.propertyChange(), " +
                            evt.getPropertyName() + " frame = null");

            } //else

        } //if (evt.getPropertyName().equals(IDSSAppConstants.addToModelView))




        if (evt.getPropertyName().equals(IDSSAppConstants.removeFromModelView)) {

            DisplayFrame frame = (DisplayFrame)evt.getNewValue();

            if(frame != null) {

                removeFromView(frame);

            } //if(frame != null)

            else {

                if(IDSSAppConstants.debug)
                    System.out.println("ModelSetupTree.propertyChange(), " +
                            evt.getPropertyName() + " frame = null");

            } //else

        } //if (evt.getPropertyName().equals(IDSSAppConstants.removeFromModelView))




        if (evt.getPropertyName().equals(IDSSAppConstants.removeAllFromModelView)) {

            removeAllFromView();

        } //if (evt.getPropertyName().equals(IDSSAppConstants.removeAllFromModelView))





        if (evt.getPropertyName().equals(IDSSAppConstants.addGridToModel)) {

            Vector v = (Vector)evt.getNewValue();
            modelSetupControllerJBean.addGridToModel(v);


        } //if (evt.getPropertyName().equals(IDSSAppConstants.addDEMToModel))




        if(evt.getPropertyName().equals(IDSSAppConstants.setTidalModel)) {

            Vector v = (Vector)evt.getNewValue();

            modelSetupControllerJBean.setTidalModel(v);


        } //if(evt.getPropertyName().equals(IDSSAppConstants.setTidalModel))



        if(evt.getPropertyName().equals(IDSSAppConstants.setAllTidalModels)) {

            Hashtable tidalModelsHashtable = (Hashtable)evt.getNewValue();
            modelSetupControllerJBean.setAllTidalModels(tidalModelsHashtable);

        } //if(evt.getPropertyName().equals(IDSSAppConstants.setAllTidalModels))



        if (evt.getPropertyName().equals(IDSSAppConstants.setIsostaticMovement)) {

            Integer isostaticMovement = (Integer)evt.getNewValue();
            modelSetupControllerJBean.setIsostaticMovement(isostaticMovement);


        } //if (evt.getPropertyName().equals(IDSSAppConstants.setIsostaticMovement))



        if (evt.getPropertyName().equals(IDSSAppConstants.setSLRScenario)) {

            ClientDataSet slrDataSet = (ClientDataSet)evt.getNewValue();
            modelSetupControllerJBean.setSLRScenario(slrDataSet);


        } //if (evt.getPropertyName().equals(IDSSAppConstants.setSLRScenario))




        if (evt.getPropertyName().equals(IDSSAppConstants.setAllSurvivalModels)) {

            Hashtable survivalModels = (Hashtable)evt.getNewValue();
            modelSetupControllerJBean.setAllSurvivalModels(survivalModels);


        } //if (evt.getPropertyName().equals(IDSSAppConstants.setAllSurvivalModels))





        if (evt.getPropertyName().equals(IDSSAppConstants.proceedWithSimulation)) {


            JOptionPane.showMessageDialog(null,"ModelSetupController.propertyChange(), " +
                                            IDSSAppConstants.proceedWithSimulation,
                                            "Information",JOptionPane.INFORMATION_MESSAGE);

            modelSetupControllerJBean.proceedWithSimulation();



        } //if (evt.getPropertyName().equals(IDSSAppConstants.proceedWithSimulation))



        if(evt.getPropertyName().equals(IDSSAppConstants.createSimNode)) {

            Vector simVector = (Vector)evt.getNewValue();

            if(simVector != null) {

                Grid dem = (Grid)simVector.elementAt(0);
                LCGrid2 lcGrid2 = (LCGrid2)simVector.elementAt(1);
                Hashtable tidalModelsHashtable = (Hashtable)simVector.elementAt(2);
                int isostatic = ((Integer)simVector.elementAt(3)).intValue();
                ClientDataSet slr = (ClientDataSet)simVector.elementAt(4);

                modelSetupTree.createSimNode(dem,lcGrid2,tidalModelsHashtable,isostatic,slr);

            } //if(simVector != null)

        } //if(evt.getPropertyName().equals(IDSSAppConstants.createSimNode))


        if(evt.getPropertyName().equals(IDSSAppConstants.showMessage)) {

            Vector v = (Vector)evt.getNewValue();

            if(v!=null) {

                MessageHandler.showMessage(v);

            } //if(v!=null)


        } //if(evt.getPropertyName().equals(IDSSAppConstants.showMessage))


        if(evt.getPropertyName().equals(IDSSAppConstants.setStatusBean)) {

            StatusJBean statusJBean = (StatusJBean)evt.getNewValue();

            if(statusJBean != null) {
                modelSetupTree.setStatusBean(statusJBean);
            }

        } //if(evt.getPropertyName().equals(IDSSAppConstants.setStatusBean))


        if(evt.getPropertyName().equals(IDSSAppConstants.setClassTypes)) {

            Vector landClasses = (Vector)evt.getNewValue();

            if(landClasses != null) {

                modelSetupTree.setClassTypes(landClasses);

            } //if(landClasses != null)

        } //if(evt.getPropertyName().equals(IDSSAppConstants.setClassTypes))






    } //public void propertyChangeEvent(PropertyChangeEvent evt)








    public static void main(String[] args) {

        ModelSetupController controller = new ModelSetupController();

    } //public static void main(String[] args)





} //public class ModelSetupController

