package iDSS;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;




import iDSS.*;
import iDSS.utils.*;
import iDSS.disp.*;
//import iDSS.beans2.*;




public class Status extends DisplayFrame implements ActionListener,PropertyChangeListener {



    private JLabel demLabel,lcGridLabel,tidalModelsLabel,isoMovLabel,
                    vegModLabel,slrScenLabel;

    private JTextField demTextField,lcGridTextField,tidalModelsTextField,isoMovTextField,
                    vegModTextField,slrScenTextField;


    private JButton proceedWithSimButton;
    private JButton exitButton;

    //private StatusJBean statusJBean;




    public Status() {


        super(IDSSAppConstants.modelSetupStatus,false,false,false,true,null);
        //statusJBean = new StatusJBean();
        //statusJBean.addPropertyChangeListener(this);


        demLabel = new JLabel(IDSSAppConstants.modelSetupDigitalElevationModel);
        lcGridLabel = new JLabel(IDSSAppConstants.modelSetupLandcoverTypes);
        tidalModelsLabel = new JLabel(IDSSAppConstants.modelSetupTidalData);
        isoMovLabel = new JLabel(IDSSAppConstants.modelSetupIsostaticMovement);
        vegModLabel = new JLabel(IDSSAppConstants.modelSetupVegetationModels);
        slrScenLabel = new JLabel(IDSSAppConstants.modelSetupSlrScenario);


        demTextField = new JTextField(20);
        lcGridTextField = new JTextField(20);
        tidalModelsTextField = new JTextField(20);
        isoMovTextField = new JTextField(20);
        vegModTextField = new JTextField(20);
        slrScenTextField = new JTextField(20);

        demTextField.setEditable(false);
        lcGridTextField.setEditable(false);
        tidalModelsTextField.setEditable(false);
        isoMovTextField.setEditable(false);
        vegModTextField.setEditable(false);
        slrScenTextField.setEditable(false);

        proceedWithSimButton = new JButton(IDSSAppConstants.proceedWithSimButtonText);
        proceedWithSimButton.setActionCommand(IDSSAppConstants.proceedWithSimButtonCommand);
        proceedWithSimButton.addActionListener(this);
        proceedWithSimButton.setEnabled(false);

        exitButton = new JButton(IDSSAppConstants.exitButtonText);
        exitButton.setActionCommand(IDSSAppConstants.exitButtonCommand);
        exitButton.addActionListener(this);
        exitButton.setEnabled(true);


        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new GridLayout(6,1));
        labelPanel.add(demLabel);
        labelPanel.add(lcGridLabel);
        labelPanel.add(tidalModelsLabel);
        labelPanel.add(isoMovLabel);
        labelPanel.add(vegModLabel);
        labelPanel.add(slrScenLabel);

        JPanel textPanel = new JPanel();
        textPanel.setLayout(new GridLayout(6,1));
        textPanel.add(demTextField);
        textPanel.add(lcGridTextField);
        textPanel.add(tidalModelsTextField);
        textPanel.add(isoMovTextField);
        textPanel.add(vegModTextField);
        textPanel.add(slrScenTextField);

        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel,BoxLayout.X_AXIS));
        buttonPanel.add(exitButton);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(proceedWithSimButton);

        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel,BoxLayout.X_AXIS));
        topPanel.add(Box.createHorizontalStrut(5));
        topPanel.add(labelPanel);
        topPanel.add(Box.createHorizontalStrut(5));
        topPanel.add(textPanel);

        getContentPane().setLayout(new BoxLayout(getContentPane(),BoxLayout.Y_AXIS));
        getContentPane().add(topPanel);
        getContentPane().add(buttonPanel);

        getContentPane().setBackground(Color.lightGray);

        pack();
        setVisible(true);


    } //public Status()







        public void setDemText(String s) {

            demTextField.setText(s);
            fireStatusNotice();

        } //


        public void setLcGridText(String s) {

            lcGridTextField.setText(s);
            fireStatusNotice();

        } //


        public void setTidalModelsText(String s) {

            tidalModelsTextField.setText(s);
            fireStatusNotice();

        } //


        public void setIsoMovText(String s) {

            isoMovTextField.setText(s);
            fireStatusNotice();

        } //


        public void setVegModText(String s) {

            vegModTextField.setText(s);
            fireStatusNotice();

        } //


        public void setSlrScenText(String s) {

            slrScenTextField.setText(s);
            fireStatusNotice();

        } //






        private void fireStatusNotice() {


            boolean status = checkStatus();
            System.out.println("Status.fireStatusNotice(), status : " + status);


            if(status) {
                //firePropertyChange(IDSSAppConstants.proceedWithSimulation,new Boolean(false),new Boolean(true));

                JOptionPane.showMessageDialog(null,"Status.fireStatusNotice(), " +
                                                IDSSAppConstants.proceedWithSimulation,
                                                "Information",JOptionPane.INFORMATION_MESSAGE);

                proceedWithSimButton.setEnabled(true);

            } //if(status)


        } //private void fireStatusNotice()





        public boolean checkStatus() {


            boolean status = true;

            if (demTextField.getText().equals(IDSSAppConstants.notDoneText))
                status = false;

            else if (lcGridTextField.getText().equals(IDSSAppConstants.notDoneText))
                status = false;

            else if (tidalModelsTextField.getText().equals(IDSSAppConstants.notDoneText))
                status = false;

            else if (isoMovTextField.getText().equals(IDSSAppConstants.notDoneText))
                status = false;

            else if (vegModTextField.getText().equals(IDSSAppConstants.notDoneText))
                status = false;

            else if (slrScenTextField.getText().equals(IDSSAppConstants.notDoneText))
                status = false;


            return status;

        } //public boolean checkStatus()




    public void actionPerformed(ActionEvent ae) {


        if(ae.getActionCommand().equals(IDSSAppConstants.proceedWithSimButtonCommand)) {

                firePropertyChange(IDSSAppConstants.proceedWithSimulation,new Boolean(false),new Boolean(true));

        } //if(ae.getActionCommand().equals(IDSSAppConstants.proceedWithSimButtonCommand))



        if(ae.getActionCommand().equals(IDSSAppConstants.exitButtonCommand)) {

                System.exit(0);

        } //if(ae.getActionCommand().equals(IDSSAppConstants.exitButtonCommand))


    } //public void actionPerformed(ActionEvent ae)





    public void propertyChange(PropertyChangeEvent evt) {


        if(evt.getPropertyName().equals(IDSSAppConstants.setDemStatus)) {

            String s = (String)evt.getNewValue();

            if(s != null)
                setDemText(s);

        } //if(evt.getPropertyName().equals(IDSSAppConstants.setDemStatus))



        if(evt.getPropertyName().equals(IDSSAppConstants.setLcGridStatus)) {

            String s = (String)evt.getNewValue();

            if(s != null)
                setLcGridText(s);

        } //if(evt.getPropertyName().equals(IDSSAppConstants.setLcGridStatus))



        if(evt.getPropertyName().equals(IDSSAppConstants.setTidalModelsStatus)) {

            String s = (String)evt.getNewValue();

            if(s != null)
                setTidalModelsText(s);

        } //if(evt.getPropertyName().equals(IDSSAppConstants.setTidalModelsStatus))


        if(evt.getPropertyName().equals(IDSSAppConstants.setIsoMovStatus)) {

            String s = (String)evt.getNewValue();

            if(s != null)
                setIsoMovText(s);

        } //if(evt.getPropertyName().equals(IDSSAppConstants.setIsoMovStatus))


        if(evt.getPropertyName().equals(IDSSAppConstants.setVegModStatus)) {

            String s = (String)evt.getNewValue();

            if(s != null)
                setVegModText(s);

        } //if(evt.getPropertyName().equals(IDSSAppConstants.setVegModStatus))


        if(evt.getPropertyName().equals(IDSSAppConstants.setSlrScenStatus)) {

            String s = (String)evt.getNewValue();

            if(s != null)
                setSlrScenText(s);

        } //if(evt.getPropertyName().equals(IDSSAppConstants.setSlrScenStatus))


        if(evt.getPropertyName().equals(IDSSAppConstants.proceedWithSimulation)) {

            proceedWithSimButton.setEnabled(true);

        } //if(evt.getPropertyName().equals(IDSSAppConstants.proceedWithSimulation))


    } //public void propertyChange(PropertyChangeEvent evt)







} //public class Status extends DisplayFrame implements ActionListener,PropertyChangeListener

