package iDSS.beans;

import java.io.*;
import java.beans.*;
import java.sql.Timestamp;
import java.util.*;
import java.util.Properties; 

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;



import java.rmi.RemoteException;


import iDSS.*;
import iDSS.grids.*;
import iDSS.utils.*;

//Serverside packages
import helpers.*;
import ejb.lcGrids.*;






public class LCGridsJBean implements Serializable {


    private PropertyChangeSupport pcs;
    private String ejbName;

    private LCGridsHome gridsHome;
    private LCGrids grids;
    String serverGridTable;



    public LCGridsJBean() {

        pcs = new PropertyChangeSupport(this);

    } //public LCGridsJBean()



    public void addPropertyChangeListener(PropertyChangeListener l) {

        pcs.addPropertyChangeListener(l);

    } //public void addPropertyChangeListener(PropertyChangeListener l)




    public void removePropertyChangeListener(PropertyChangeListener l) {

        pcs.removePropertyChangeListener(l);

    } //public void removePropertyChangeListener(PropertyChangeListener l)




    public String getEjbName() {

        return ejbName;

    }//public String getEjbName()




    public void setEjbName(String s,String dataTable) {

        try {
            ejbName = s;
            serverGridTable = dataTable;

            if(IDSSAppConstants.debug) {
                System.out.println("LCGridsJBean.setEjbName(), ejbName = " + ejbName);
                System.out.println("LCGridsJBean.setEjbName(), serverGridTable = " + serverGridTable);
            }//if(IDSSAppConstants.debug)


            Properties props = new Properties(); 
            //props.put(Context.DNS_URL, "130.159.78.177:1050");
            props.put(Context.DNS_URL, IDSSAppConstants.serverURL);

            Context initial = new InitialContext(props);


            Object objref = initial.lookup(ejbName);
            gridsHome = (LCGridsHome)PortableRemoteObject.narrow(objref,LCGridsHome.class);
        } //try

        catch(Exception ex) {
            System.out.println("LCGridsJBean.setEjbName(), Caught an exception");
            ex.printStackTrace();
        } //catch();

    }//public void setEjbName()




    public void saveOnServer(Grid g,String ip, String fileName) {


        try {
            ServerGrid sg = g.getServerGrid();
            Timestamp t = new Timestamp(System.currentTimeMillis());
            String ipFileName = ip + "," + fileName;
            grids = gridsHome.create(ipFileName,ip,fileName,t,sg);
        } //try

        catch(Exception ex) {
            System.out.println("LCGridsJBean.create(), Caught an exception");
            ex.printStackTrace();
        } //catch();

    } //public void saveOnServer(Grid g,String ip, String fileName)



    public Grid findByPrimaryKey(String ip,String fileName) {

        Grid g = null;

        try {
            String ipFile = ip + "," + fileName;
            g = new Grid("",0,0,null);
            grids = gridsHome.findByPrimaryKey(ipFile);
            ServerGrid sg = grids.getGrid();
            g.readServerGrid(sg);
        } //try

        catch(Exception ex) {
            System.out.println("LCGridsJBean.findByPrimaryKey(), Caught an exception");
            ex.printStackTrace();
        } //catch();

        return g;

    } //public Grid findByPrimaryKey(String ip,String fileName)



    public Collection findInRange(Timestamp start,Timestamp end) {

        Collection result = null;

        try {

            Collection sgColl = gridsHome.findInRange(start,end);
            result = sgToGCol(sgColl);

        } //try

        catch(Exception ex) {
            System.out.println("LCGridsJBean.findInRange(), Caught an exception");
            ex.printStackTrace();
        } //catch();

        return result;

    } //public Collection findInRange(Timestamp start,Timestamp end)





    public Collection findByIp(String ip) {

        Collection result = null;

        try {

            Collection sgColl = gridsHome.findByIp(ip);
            result = sgToGCol(sgColl);

        } //try

        catch(Exception ex) {
            System.out.println("LCGridsJBean.findByIp(), Caught an exception");
            ex.printStackTrace();
        } //catch();

        return result;

    } //public Collection findByIp(String ip)




    public Collection findAll() {

        Collection result = null;

        try {

            Collection sgColl = gridsHome.findAll();
            result = sgToGCol(sgColl);

        } //try

        catch(Exception ex) {
            System.out.println("LCGridsJBean.findAll(), Caught an exception");
            ex.printStackTrace();
        } //catch();

        return result;

    } //public Collection findAll()






    private Collection sgToGCol(Collection sgColl) {

        Iterator i = sgColl.iterator();

        ArrayList result = new ArrayList();

        try {

            while(i.hasNext()) {

                LCGrids grids = (LCGrids)i.next();
                ServerGrid sg = (ServerGrid)grids.getGrid();
                Grid g = new Grid("",0,0,null);
                g.readServerGrid(sg);
                result.add(g);

            } //while(i.hasNext())

        }//try

        catch(RemoteException e) {

            System.out.println("LCGridsJBean.sgToGCol(), Caught a RemoteException");
            e.printStackTrace();

        }//catch(RemoteException e)

        return result;

    } //private Collection sgToGCol(Collection sgColl)




} //public class LCGridsJBean implements Serializable


