package iDSS.beans;

import java.io.*;
import java.beans.*;
import java.sql.Timestamp;
import java.util.*;
import java.util.Properties; 

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;



import java.rmi.RemoteException;


import iDSS.*;
import iDSS.utils.*;

//Serverside packages

import ejb.slrData.*;



public class SLRDataJBean implements Serializable {


    private PropertyChangeSupport pcs;
    private String ejbName;

    private SLRDataHome slrDataHome;
    private SLRData slrData;



    public SLRDataJBean() {

        pcs = new PropertyChangeSupport(this);

    } //public SLRDataJBean()



    public void addPropertyChangeListener(PropertyChangeListener l) {

        pcs.addPropertyChangeListener(l);

    } //public void addPropertyChangeListener(PropertyChangeListener l)




    public void removePropertyChangeListener(PropertyChangeListener l) {

        pcs.removePropertyChangeListener(l);

    } //public void removePropertyChangeListener(PropertyChangeListener l)






    public String getEjbName() {

        return ejbName;

    }//public String getEjbName()




    public void setEjbName(String s) {

        try {
            ejbName = s;

            if(IDSSAppConstants.debug) {
                System.out.println("SLRDataJBean.setEjbName(), ejbName = " + ejbName);
            }//if(IDSSAppConstants.debug)


            Properties props = new Properties(); 
            props.put(Context.DNS_URL, IDSSAppConstants.serverURL);
            Context initial = new InitialContext(props);


            Object objref = initial.lookup(ejbName);
            slrDataHome = (SLRDataHome)PortableRemoteObject.narrow(objref,SLRDataHome.class);
        } //try

        catch(Exception ex) {
            System.out.println("SLRDataJBean.setEjbName(), Caught an exception");
            ex.printStackTrace();
        } //catch();

    }//public void setEjbName()




    public Vector findAll() {

        Vector v = new Vector();

        try {

            Collection c = slrDataHome.findAll();
            Iterator i=c.iterator();

            while (i.hasNext()) {

                Vector oneRow = new Vector();

                SLRData t = (SLRData)i.next();

                oneRow.add(0,t.getScenarioName());
                oneRow.add(1,new Integer(t.getYear()));
                oneRow.add(2,new Double(t.getSens1_5()));
                oneRow.add(3,new Double(t.getSens4_5()));
                oneRow.add(4,new Double(t.getSens2_5()));
                oneRow.add(5,new Double(t.getSens2_5nosulf()));

                v.add(oneRow);

            } //while (i.hasNext())

        } //try

        catch (Exception ex) {

            System.err.println("SLRDataJBean.findAll(), Caught an exception." );
            ex.printStackTrace();

        } //catch (Exception ex)

        return v;

    } //public Vector findAll()






    public Vector findByPrimaryKey(String scenarioName,int year) {

        Vector v = new Vector();

        try {

            SLRData t = slrDataHome.findByPrimaryKey(scenarioName,year);

            v.add(0,t.getScenarioName());
            v.add(1,new Integer(t.getYear()));
            v.add(2,new Double(t.getSens1_5()));
            v.add(3,new Double(t.getSens4_5()));
            v.add(4,new Double(t.getSens2_5()));
            v.add(5,new Double(t.getSens2_5nosulf()));

        } //try

        catch (Exception ex) {

            System.err.println("SLRDataJBean.findByPrimaryKey(), Caught an exception." );
            ex.printStackTrace();

        } //catch (Exception ex)

        return v;


    }//public Vector findByPrimaryKey(String scenarioName,int year)







    public Vector findByScenarioName(String scenarioName) {

        Vector v = new Vector();

        try {

            Collection c = slrDataHome.findByScenarioName(scenarioName);
            Iterator i=c.iterator();

            while (i.hasNext()) {

                Vector oneRow = new Vector();

                SLRData t = (SLRData)i.next();

                oneRow.add(0,t.getScenarioName());
                oneRow.add(1,new Integer(t.getYear()));
                oneRow.add(2,new Double(t.getSens1_5()));
                oneRow.add(3,new Double(t.getSens4_5()));
                oneRow.add(4,new Double(t.getSens2_5()));
                oneRow.add(5,new Double(t.getSens2_5nosulf()));

                v.add(oneRow);

            } //while (i.hasNext())

        } //try

        catch (Exception ex) {

            System.err.println("SLRDataJBean.findByScenarioName(), Caught an exception." );
            ex.printStackTrace();

        } //catch (Exception ex)

        return v;


    } //public Vector findByScenarioName(String scenarioName)





}//public class SLRDataJBean implements Serializable

