package iDSS.beans;

import java.io.*;
import java.beans.*;
import java.sql.Timestamp;
import java.util.*;
import java.util.Properties; 

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import javax.ejb.*;


import java.rmi.RemoteException;


import iDSS.*;
import iDSS.utils.*;
import iDSS.tidalData.*;

//Serverside packages

import ejb.dataAccess.*;
import ejb.tide.*;



public class TidalDataJBean implements Serializable {


    private PropertyChangeSupport pcs;
    private String ejbName;

    private TidalDataHome tidalDataHome;



    public TidalDataJBean() {

        pcs = new PropertyChangeSupport(this);

    } //public TidalDataJBean()



    public void addPropertyChangeListener(PropertyChangeListener l) {

        pcs.addPropertyChangeListener(l);

    } //public void addPropertyChangeListener(PropertyChangeListener l)




    public void removePropertyChangeListener(PropertyChangeListener l) {

        pcs.removePropertyChangeListener(l);

    } //public void removePropertyChangeListener(PropertyChangeListener l)






    public String getEjbName() {

        return ejbName;

    }//public String getEjbName()




    public void setEjbName(String s) {

        try {
            ejbName = s;

            if(IDSSAppConstants.debug) {
                System.out.println("TidalDataJBean.setEjbName(), ejbName = " + ejbName);
            }//if(IDSSAppConstants.debug)


            Properties props = new Properties(); 
            props.put(Context.DNS_URL, IDSSAppConstants.serverURL);
            Context initial = new InitialContext(props);


            Object objref = initial.lookup(ejbName);
            tidalDataHome = (TidalDataHome)PortableRemoteObject.narrow(objref,TidalDataHome.class);
        } //try

        catch(Exception ex) {
            System.out.println("TidalDataJBean.setEjbName(), Caught an exception");
            ex.printStackTrace();
        } //catch();

    }//public void setEjbName()






    public ClientDataSet select(String table,Timestamp start,Timestamp end,String dbName) {

        ClientDataSet cds = null;
        DataSet ds = null;

        try {
            TidalData tidalData = tidalDataHome.create();
            ds = tidalData.select(table,start,end,dbName);

            if(ds != null) {

                Vector columns = ds.getColumnNamesVector();
                Vector rows = ds.getRowsOfDataVector();
                String sql = table + "," + start.toString() + "," +
                             end.toString();

                cds = new ClientDataSet(sql,table,start,end,columns,rows);

            }//if(ds != null)


        } //try

        catch(RemoteException re) {

            System.out.println("TidalDataJBean.select(), RemoteException occured");
            re.printStackTrace();

        } //catch(RemoteException re)

        catch(CreateException re) {

            System.out.println("TidalDataJBean.select(), CreateException occured");
            re.printStackTrace();

        } //catch(RemoteException re)

        return cds;

    } //public ClientDataSet select(String table,Timestamp start,Timestamp end,String dbName)




}//public class TidalDataJBean implements Serializable

