package iDSS.beans;

import java.io.*;
import java.beans.*;
import java.sql.Timestamp;
import java.util.*;
import java.util.Properties; 

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;



import java.rmi.RemoteException;


import iDSS.*;
import iDSS.utils.*;

//Serverside packages
//import helpers.*;
import ejb.stations.*;



public class TidalStationsJBean implements Serializable {


    private PropertyChangeSupport pcs;
    private String ejbName;

    private TidalStationsHome tidalStationsHome;
    private TidalStations tidalStations;



    public TidalStationsJBean() {

        pcs = new PropertyChangeSupport(this);

    } //public TidalStationsJBean()



    public void addPropertyChangeListener(PropertyChangeListener l) {

        pcs.addPropertyChangeListener(l);

    } //public void addPropertyChangeListener(PropertyChangeListener l)




    public void removePropertyChangeListener(PropertyChangeListener l) {

        pcs.removePropertyChangeListener(l);

    } //public void removePropertyChangeListener(PropertyChangeListener l)






    public String getEjbName() {

        return ejbName;

    }//public String getEjbName()




    public void setEjbName(String s) {

        try {
            ejbName = s;

            if(IDSSAppConstants.debug) {
                System.out.println("TidalStationsJBean.setEjbName(), ejbName = " + ejbName);
            }//if(IDSSAppConstants.debug)


            Properties props = new Properties(); 
            props.put(Context.DNS_URL, IDSSAppConstants.serverURL);
            Context initial = new InitialContext(props);


            Object objref = initial.lookup(ejbName);
            tidalStationsHome = (TidalStationsHome)PortableRemoteObject.narrow(objref,TidalStationsHome.class);
        } //try

        catch(Exception ex) {
            System.out.println("TidalStationsJBean.setEjbName(), Caught an exception");
            ex.printStackTrace();
        } //catch();

    }//public void setEjbName()




    public Vector findAll() {

        Vector v = new Vector();

        try {

            Collection c = tidalStationsHome.findAll();
            Iterator i=c.iterator();

            while (i.hasNext()) {

                Vector oneRow = new Vector();

                TidalStations t = (TidalStations)i.next();
                oneRow.add(0,t.getStationName());
                oneRow.add(1,t.getStartDate());
                oneRow.add(2,t.getEndDate());
                oneRow.add(3,t.getDataTable());

                v.add(oneRow);

            } //while (i.hasNext())

        } //try

        catch (Exception ex) {

            System.err.println("Caught an exception." );
            ex.printStackTrace();

        } //catch (Exception ex)

        return v;

    } //public Vector findAll()





}//public class TidalStationsJBean implements Serializable

