package iDSS.beans2;

import java.util.*;
import java.sql.*;
import java.beans.*;


import iDSS.*;
import iDSS.utils.*;
import iDSS.tidalData.*;
import iDSS.beans.*;



public class ScenarioDetailJBean {


    private PropertyChangeSupport pcs;
    private String scenarioName;
    private Vector scenarioDetail;




    public ScenarioDetailJBean() {


        pcs = new PropertyChangeSupport(this);


    }//public ScenarioDetailJBean()




    public void addPropertyChangeListener(PropertyChangeListener l) {

        pcs.addPropertyChangeListener(l);

    } //public void addPropertyChangeListener(PropertyChangeListener l)




    public void removePropertyChangeListener(PropertyChangeListener l) {

        pcs.removePropertyChangeListener(l);

    } //public void removePropertyChangeListener(PropertyChangeListener l)





    public void setScenarioName(String name) {

        scenarioName = name;

        iDSS.beans.SLRDataJBean slrDataBean = new iDSS.beans.SLRDataJBean();
        slrDataBean.setEjbName(IDSSAppConstants.slrDataBean);

        scenarioDetail = slrDataBean.findByScenarioName(scenarioName);

    } //public void setScenarioName(String name)




    public Vector getScenarioDetail() {

        return scenarioDetail;

    } //public Vector getScenarioDetail()








    public ClientDataSet makeSLRDataSet(int selectedCol,int yearCol) {

        ClientDataSet scenarioDataSet = null;
        Vector columns = new Vector();
        Vector rows = new Vector();

        columns.add("Year");
        columns.add("Sea level rise (cm)");

        Calendar startCal = Calendar.getInstance();
        //Long year = new Long(aTable.getValueAt(0,yearCol).toString());

        Vector oneRow = (Vector)scenarioDetail.elementAt(0);
        Long year = new Long(oneRow.elementAt(yearCol).toString());

        startCal.set(year.intValue(),0,1,0,0,0);

        Timestamp start = new Timestamp(startCal.getTime().getTime());

        Calendar endCal = Calendar.getInstance();

        oneRow = (Vector)scenarioDetail.elementAt(scenarioDetail.size()-1);
        year = new Long(oneRow.elementAt(yearCol).toString());

        endCal.set(year.intValue(),0,1,0,0,0);
        Timestamp end = new Timestamp(endCal.getTime().getTime());

        System.out.println("ScenarioDetailJBean.makeSLRDataSet(), Start : " + start.toString() + ", End : " + end.toString());


        if (selectedCol > 1) {

            //for(int i=0;i<aTable.getRowCount();i++) {
            for(int i=0;i<scenarioDetail.size();i++) {

                //System.out.println(aTable.getValueAt(i,yearCol) + ", " + aTable.getValueAt(i,selectedCol).toString());

                Calendar cal = Calendar.getInstance();
                //year = new Long(aTable.getValueAt(i,yearCol).toString());

                oneRow = (Vector)scenarioDetail.elementAt(i);
                year = new Long(oneRow.elementAt(yearCol).toString());

                cal.set(year.intValue(),0,1,0,0,0);
                Timestamp timestamp = new Timestamp(cal.getTime().getTime());

                Vector currentRow = new Vector();
                //currentRow.add(timestamp);
                currentRow.add(year);

                //currentRow.add((Double)aTable.getValueAt(i,selectedCol));
                currentRow.add((Double)oneRow.elementAt(selectedCol));

                rows.add(currentRow);

            } //for(int i=0;i<aTable.getRowCount();i++)


            int startYear = startCal.get(Calendar.YEAR);
            int endYear = endCal.get(Calendar.YEAR);


            Vector interpolatedRows = new Vector();

            for(int iYear=startYear;iYear<=endYear;iYear++) {

                Double value;
                boolean notFound = true;
                int rowNum = 0;
                while(notFound) {

                    Vector v = (Vector) rows.elementAt(rowNum);
                    Long y = (Long) v.elementAt(0);
                    if (y.intValue() >= iYear)
                        notFound = false;
                    else
                        rowNum++;
                } //while(notFound)

                if(rowNum == 0) {
                    Vector v = (Vector) rows.elementAt(rowNum);
                    value = (Double) v.elementAt(1);
                } //if(rowNum == 0)
                else {

                    Vector v = (Vector) rows.elementAt(rowNum-1);
                    Double s1 = (Double) v.elementAt(1);
                    Long y1 = (Long) v.elementAt(0);

                    v = (Vector) rows.elementAt(rowNum);
                    Double s2 = (Double) v.elementAt(1);
                    Long y2 = (Long) v.elementAt(0);

                    double iYearD = (double) iYear;
                    double v1 = s1.doubleValue();
                    double v2 = s2.doubleValue();
                    double year1 = y1.doubleValue();
                    double year2 = y2.doubleValue();
                    
                    value = new Double (v1+(iYearD-year1)*(v2-v1)/(year2-year1));

                } //else

                Calendar cal = Calendar.getInstance();
                cal.set(iYear,0,1,0,0,0);
                Timestamp timestamp = new Timestamp(cal.getTime().getTime());

                Vector currentRow = new Vector();
                currentRow.add(timestamp);
                currentRow.add(value);
                interpolatedRows.add(currentRow);

            } //for(int iYear=startYear;iYear<=endYear;iYear++)


            scenarioDataSet =
                    new ClientDataSet(scenarioName,start,end,columns,interpolatedRows);


            scenarioDataSet.setStationName(scenarioName);


        } //if (selectedCol != 0)


        return scenarioDataSet;

    } //public ClientDataSet makeSLRDataSet()






} //public class ScenarioDetailJBean extends DisplayFrame implements ActionListener

