package iDSS.beans2;

import java.util.*;
import java.io.*;
import java.net.*;
import java.beans.*;



import iDSS.*;
import iDSS.disp.*;
import iDSS.utils.*;
import iDSS.tables.*;
import iDSS.sm.*;



public class SurvivalModelsListJBean {



    private Hashtable survivalModelsHashtable;

    private File currentPath;

    //private final char backSlash = 92;
    private final char backSlash = File.separatorChar;
    private final char foreSlash = 47;

    private PropertyChangeSupport pcs;

    private Vector smModelNames;
    private Vector columnNames;
    private Vector classTypes;
    
    private Hashtable customClasses;

    public SurvivalModelsListJBean() {

        pcs = new PropertyChangeSupport(this);

        classTypes = new Vector();

        columnNames = new Vector();
        columnNames.add("Landcover Class");
        columnNames.add("Survival Model");

        Vector rowsOfData = new Vector();

        survivalModelsHashtable = new Hashtable();


        System.out.println("SurvivalModelsListJBean.constructor(), this.getClass().toString() : " + this.getClass().toString());
        smModelNames = ConfigData.readURLProperties(IDSSAppConstants.configDir,IDSSAppConstants.smModelsFile,this.getClass());


        //Reading local survival models, if present

        Vector localSM = ConfigData.readProperties(IDSSAppConstants.configDir,IDSSAppConstants.smModelsFile);

        if(localSM != null) {

            for(int i=0;i<localSM.size();i++) {

                String s = (String)localSM.elementAt(i);
                smModelNames.add(s);

            } //for(int i=0;i<localSM.size();i++)

        } //if(localSM != null)

        //smModelNames = ConfigData.readProperties(IDSSAppConstants.configDir,IDSSAppConstants.smModelsFile);



        customClasses = new Hashtable();

      }//public SurvivalModelsListJBean(int row, int column)









    public void addCustomClasses(String path,Vector classNames) {


        if(path != null) {


            if(classNames != null) {

                for(int i=0;i<classNames.size();i++) {

                    String s = (String)classNames.elementAt(i);
                    customClasses.put(s,path);

                } //for(int i=0;i<classNames.size();i++)

            } //if(classNames != null)


            else {

                System.out.println("SurvivalModelsListJBean.addCustomClasses(), classNames is null");

            } //else


        } //if(path != null)

        else {

            System.out.println("SurvivalModelsListJBean.addCustomClasses(), path is null");

        } //


    } //public void addCustomClasses(String path,Vector classNames)











    public void addPropertyChangeListener(PropertyChangeListener l) {

        pcs.addPropertyChangeListener(l);

    } //public void addPropertyChangeListener(PropertyChangeListener l)




    public void removePropertyChangeListener(PropertyChangeListener l) {

        pcs.removePropertyChangeListener(l);

    } //public void removePropertyChangeListener(PropertyChangeListener l)






    public void setClassTypes(Vector v) {

        if(v != null)
            classTypes = v;

    } //public void setClassTypes(Vector v)





    public Vector getClassTypes() {

        return classTypes;

    } //public Vector getClassTypes()





    public Vector getColumnNames() {

        return columnNames;

    } //public Vector getColumnNames()




    public Vector getSmModelNames() {

        return smModelNames;

    } //public Vector getSmModelNames()




    public int getHashtableSize() {

        return survivalModelsHashtable.size();

    } //public int getHashtableSize()









    public SurvivalModel showDetails(String classType,boolean edit) {

        String s = (String)survivalModelsHashtable.get(classType);
        File file = new File(s);
        SurvivalModel sm = null;

        if(file != null) {

            Thread t = Thread.currentThread();
            ClassLoader cl = t.getContextClassLoader();
            System.out.println("SurvivalModelsListJBean.showDetails(), ClassLoader : " + cl.toString());


            sm = (SurvivalModel) ObjectReadWrite.read(file);

        } //if(file != null)

        return sm;

    } //public SurvivalModel showDetails(File file)




















/**
    public SurvivalModel showDetails(String classType,boolean edit) {

        String s = (String)survivalModelsHashtable.get(classType);
        File file = new File(s);
        SurvivalModel sm = null;

        if(file != null) {

            sm = (SurvivalModel) ObjectReadWrite.read(file);

        } //if(file != null)

        return sm;

    } //public SurvivalModel showDetails(File file)

**/





    public SurvivalModel define(String currentModel) {

        SurvivalModel sm = null;

        System.out.println("ClassLoader test");
        String extDir = System.getProperty("java.ext.dirs");
        System.out.println("SurvivalModelsListJBean.define(), extDir : " + extDir);


        try {



            //sm = (SurvivalModel)Class.forName(currentModel).newInstance();

            Thread t = Thread.currentThread();
            ClassLoader cl = t.getContextClassLoader();

            //Class aClass = cl.loadClass(currentModel);
            //sm = (SurvivalModel)aClass.newInstance();


            System.out.println("SurvivalModelsListJBean.define(), ClassLoader : " + cl.toString());

            sm = (SurvivalModel)Class.forName(currentModel,true,cl).newInstance();


        } //try


        catch(ClassNotFoundException e) {

            Vector messageVector = new Vector();
            messageVector.add("Error");
            messageVector.add("ClassNotFoundException\n" + e.toString());
            messageVector.add(new Integer(IDSSAppConstants.errorMessage));

            pcs.firePropertyChange(IDSSAppConstants.showMessage,null,messageVector);

        } //catch(ClassNotFoundException e)


        catch(InstantiationException e) {

            Vector messageVector = new Vector();
            messageVector.add("Error");
            messageVector.add("InstantiationException\n" + e.toString());
            messageVector.add(new Integer(IDSSAppConstants.errorMessage));

            pcs.firePropertyChange(IDSSAppConstants.showMessage,null,messageVector);


        } //catch(InstantiationException e)


        catch(IllegalAccessException e) {

            Vector messageVector = new Vector();
            messageVector.add("Error");
            messageVector.add("IllegalAccessException\n" + e.toString());
            messageVector.add(new Integer(IDSSAppConstants.errorMessage));

            pcs.firePropertyChange(IDSSAppConstants.showMessage,null,messageVector);


        } //catch(IllegalAccessException e)

        return sm;


    } //public SurvivalModel define(String currentModel)






/**

    public SurvivalModel define(String currentModel) {

        SurvivalModel sm = null;

        try {

            String currentPath = (String)customClasses.get(currentModel);
            if(currentPath == null) {

                sm = (SurvivalModel)Class.forName(currentModel).newInstance();

            } //

            else {

                Simple1_2ClassLoader cl = new Simple1_2ClassLoader(getClass().getClassLoader());
                Class c = cl.findClass(currentModel,currentPath);
                sm = (SurvivalModel)c.newInstance();

            } //else


        } //try


        catch(ClassNotFoundException e) {

            Vector messageVector = new Vector();
            messageVector.add("Error");
            messageVector.add("ClassNotFoundException\n" + e.toString());
            messageVector.add(new Integer(IDSSAppConstants.errorMessage));

            pcs.firePropertyChange(IDSSAppConstants.showMessage,null,messageVector);

        } //catch(ClassNotFoundException e)


        catch(InstantiationException e) {

            Vector messageVector = new Vector();
            messageVector.add("Error");
            messageVector.add("InstantiationException\n" + e.toString());
            messageVector.add(new Integer(IDSSAppConstants.errorMessage));

            pcs.firePropertyChange(IDSSAppConstants.showMessage,null,messageVector);


        } //catch(InstantiationException e)


        catch(IllegalAccessException e) {

            Vector messageVector = new Vector();
            messageVector.add("Error");
            messageVector.add("IllegalAccessException\n" + e.toString());
            messageVector.add(new Integer(IDSSAppConstants.errorMessage));

            pcs.firePropertyChange(IDSSAppConstants.showMessage,null,messageVector);


        } //catch(IllegalAccessException e)

        return sm;


    } //public SurvivalModel define(String currentModel)


**/































    public void addToHashtable(String className,String modelFileName) {

        if (survivalModelsHashtable.containsKey(className)) {

            survivalModelsHashtable.remove(className);

        } //if (survivalModelsHashtable.containsKey(className))

        survivalModelsHashtable.put(className,modelFileName);

    } //public void addToHashtable(String className,String modelFileName)




    public void removeFromHashtable(String className) {

        survivalModelsHashtable.remove(className);

    } //public void removeFromHashtable(String className)




    public boolean containsClass(String className) {

        return survivalModelsHashtable.containsKey(className);

    } //public boolean containsClass(String className)



    public String getSurvivalModel(String className) {

        String smFileName = (String)survivalModelsHashtable.get(className);
        return smFileName;

    } //public String getSurvivalModel(String className)




    public boolean saveSurvivalModels(File file) {

        //File file = writeToFile(survivalModelsHashtable);

        boolean success = writeToFile(survivalModelsHashtable,file);

        if(success) {

            Vector messageVector = new Vector();
            messageVector.add("Information");
            messageVector.add("Models saved in " + file.toString());
            messageVector.add(new Integer(IDSSAppConstants.informationMessage));

            pcs.firePropertyChange(IDSSAppConstants.showMessage,null,messageVector);

        } //if(file != null)

        else {

            Vector messageVector = new Vector();
            messageVector.add("Warning");
            messageVector.add("Models not saved");
            messageVector.add(new Integer(IDSSAppConstants.warningMessage));

            pcs.firePropertyChange(IDSSAppConstants.showMessage,null,messageVector);

        } //else

        return success;

    } //public boolean saveSurvivalModels()





    public Hashtable getSurvivalModels() {

        return survivalModelsHashtable;

    } //public Hashtable getSurvivalModels()







    public Hashtable pickAll(File file) {

        //Vector rows = new Vector();

        if (file != null) {

            Object o = ObjectReadWrite.read(file);

            if(o != null) {
                if(o instanceof Hashtable) {

                    survivalModelsHashtable = (Hashtable)o;

               } //if(o instanceof Hashtable)

               else {

                    survivalModelsHashtable = new Hashtable();

                    Vector messageVector = new Vector();
                    messageVector.add("Error");
                    messageVector.add("That was not a Hashtable");
                    messageVector.add(new Integer(IDSSAppConstants.errorMessage));

                    pcs.firePropertyChange(IDSSAppConstants.showMessage,null,messageVector);

               } //else
            }

            else {

                survivalModelsHashtable = new Hashtable();

                Vector messageVector = new Vector();
                messageVector.add("Error");
                messageVector.add("That was a null object");
                messageVector.add(new Integer(IDSSAppConstants.errorMessage));

                pcs.firePropertyChange(IDSSAppConstants.showMessage,null,messageVector);


            }//else

        } //if (inFile != null)

        //return rows;
        return survivalModelsHashtable;

    } //public Vector pickAll()





/**

    public void setSurvivalModel(SurvivalModel sm,String currentClassType,File file) {

        boolean success = writeToFile(sm,file);

        if(!success) {

            Vector messageVector = new Vector();
            messageVector.add("Warning");
            messageVector.add("Model not saved");
            messageVector.add(new Integer(IDSSAppConstants.warningMessage));

            pcs.firePropertyChange(IDSSAppConstants.showMessage,null,messageVector);

        } //else

        return success;

    } //public void setSurvivalModel(SurvivalModel sm)

**/




    public boolean setNewSurvivalModel(File file,SurvivalModel sm) {

        boolean success = writeToFile(sm,file);

        if(!success) {

            Vector messageVector = new Vector();
            messageVector.add("Warning");
            messageVector.add("Model not saved");
            messageVector.add(new Integer(IDSSAppConstants.warningMessage));

            pcs.firePropertyChange(IDSSAppConstants.showMessage,null,messageVector);

        } //if(!success)


        return success;

    } //public boolean setNewSurvivalModel(File file,SurvivalModel sm)







    private boolean writeToFile(Object sm,File aFile) {

        boolean success = false;

        if (aFile != null) {

            success = ObjectReadWrite.write(aFile,sm);

        } //if (aFile != null)


        return success;

    } //private boolean writeToFile(Object sm)





} //public class SurvivalModelsListJBean
