package iDSS.beans2;


import java.beans.*;
import java.util.*;




import iDSS.*;
import iDSS.utils.*;
import iDSS.tidalData.*;





public class TidalModelsListJBean implements PropertyChangeListener {




    private Hashtable tidalModelHashtable;
    PropertyChangeSupport pcs;




    public TidalModelsListJBean() {


        tidalModelHashtable = new Hashtable();
        pcs = new PropertyChangeSupport(this);


    }//public TidalModelsListJBean()




    public void addPropertyChangeListener(PropertyChangeListener l) {

        pcs.addPropertyChangeListener(l);

    } //public void addPropertyChangeListener(PropertyChangeListener l)





    public void removePropertyChangeListener(PropertyChangeListener l) {

        pcs.removePropertyChangeListener(l);

    } //public void removePropertyChangeListener(PropertyChangeListener l)





    public boolean addTM(Vector tmVector) {

        boolean success = false;
        String key = (String)tmVector.elementAt(0);

        if(!tidalModelHashtable.containsKey(key)) {

            TidalModel tm = (TidalModel)tmVector.elementAt(1);

            tidalModelHashtable.put(key,tm);
            success = true;

        } //if(!tidalModelHashtable.containsKey(key))

        return success;

    } //public boolean addTM(Vector tmVector)








    public Hashtable getTidalModelHashtable() {

        return tidalModelHashtable;

    } //public Hashtable getTidalModelHashtable()






    public void setModelWeightage(String modelName,int wt) {


        TidalModel aTM = (TidalModel) tidalModelHashtable.get(modelName);
        aTM.setWeightage(wt);


    } //public void setModelWeightage(String modelName,int wt)





    public void propertyChange(PropertyChangeEvent evt) {


        if(evt.getPropertyName().equals(IDSSAppConstants.setTidalModel)) {

            Vector tmVector = (Vector)evt.getNewValue();

            if(tmVector != null) {
                addTM(tmVector);
            } //if(tmVector != null)

        } //if(evt.getPropertyName().equals(IDSSAppConstants.setTidalModel))



    } //public void propertyChange(PropertyChangeEvent evt)


}//public class TidalModelsListJBean implements PropertyChangeListener
