package iDSS.beans2;

import java.util.*;
import java.sql.Timestamp;
import java.beans.*;
import java.io.*;



import iDSS.utils.*;
import iDSS.database.*;
import iDSS.beans.*;
import iDSS.tidalData.*;







public class TidalStationsLocalJBean {


    private String dataCategory,dataType,dataSet,dataTable,dataLocation;
    private Timestamp startDate,endDate;
    private Vector history;

    private String userName;
    private String password;
    private String databaseDriver;
    private String dsn;

    private Vector remoteStations;

    private Vector databaseDrivers;
    private Vector dataSourceNames;

    private PropertyChangeSupport pcs;






    public TidalStationsLocalJBean() {

        history = new Vector();

        remoteStations = getTidalStations();     //This is necessary for remote stations only


        //databaseDrivers =
            //ConfigData.readProperties(IDSSAppConstants.configDir,IDSSAppConstants.databaseDriversFile);

        databaseDrivers =
            ConfigData.readURLProperties(IDSSAppConstants.configDir,
                                            IDSSAppConstants.databaseDriversFile,
                                            this.getClass());


        //dataSourceNames = ConfigData.readProperties(
                            //IDSSAppConstants.configDir,IDSSAppConstants.dataSourceNamesFile);

        dataSourceNames =
            ConfigData.readURLProperties(IDSSAppConstants.configDir,
                                        IDSSAppConstants.dataSourceNamesFile,
                                        this.getClass());



        //Reading local database drivers, if present

        Vector localDrivers =
            ConfigData.readProperties(IDSSAppConstants.configDir,IDSSAppConstants.databaseDriversFile);

        if(localDrivers != null) {

            for(int i=0;i<localDrivers.size();i++) {

                String s = (String)localDrivers.elementAt(i);
                databaseDrivers.add(s);

            } //for(int i=0;i<localDrivers.size();i++)

        } //if(localDrivers != null)




        //Reading local data source names, if present

        Vector localDSN =
            ConfigData.readProperties(IDSSAppConstants.configDir,IDSSAppConstants.dataSourceNamesFile);

        if(localDSN != null) {

            for(int i=0;i<localDSN.size();i++) {

                String s = (String)localDSN.elementAt(i);
                dataSourceNames.add(s);

            } //for(int i=0;i<localDSN.size();i++)

        } //if(localDSN != null)











        pcs = new PropertyChangeSupport(this);


        userName = "";
        password = "";
        databaseDriver = "";
        dsn = "";

    }//public TidalStationsLocalJBean()




    public void addPropertyChangeListener(PropertyChangeListener l) {

        pcs.addPropertyChangeListener(l);

    } //public void addPropertyChangeListener(PropertyChangeListener l)



    public void removePropertyChangeListener(PropertyChangeListener l) {

        pcs.removePropertyChangeListener(l);

    } //public void removePropertyChangeListener(PropertyChangeListener l)






    public Vector getTidalStations() {

        iDSS.beans.TidalStationsJBean tsBean = new iDSS.beans.TidalStationsJBean();

        //tsBean.setEjbName("TidalStationsEJB");
        tsBean.setEjbName(IDSSAppConstants.tidalStationsBean);

        Vector stations = tsBean.findAll();

        Vector stations2 = setLocation(stations,IDSSAppConstants.dataLocationRemote);
        return stations2;

    } //public Vector getTidalStation()




    private Vector setLocation(Vector v,String s) {         //remote or local

        Vector v2 = new Vector();

        for(int i=0;i<v.size();i++) {

            Vector oneRow = (Vector)v.elementAt(i);
            oneRow.add(s);
            v2.add(oneRow);            

        }//for(int i=0;i<v.size();i++)

        return v2;

    } //private Vector setLocation(Vector v,String s)









    public Vector getRemoteStations() {

        return remoteStations;

    } //



    public Vector getDataSourceNames() {

        return dataSourceNames;

    } //public Vector getDataSourceNames()



    public Vector getDatabaseDrivers() {

        return databaseDrivers;

    } //public Vector getDatabaseDrivers()








    public void setUserName(String s) {

        userName = s;

    } //public void setUserName(String s)



    public String getUserName() {

        return userName;

    } //public String getUserName()



    public void setPassword(String s) {

        password = s;

    } //public void setPassword(String s)



    public String getPassword() {

        return password;

    } //public String getPassword()





    public void setDatabaseDriver(String s) {

        databaseDriver = s;

    } //public void setDatabaseDriver(String s)


    public String getDatabaseDriver() {

        return databaseDriver;

    } //public String getDatabaseDriver()




    public void setDsn(String s) {

        dsn = s;

    } //public void setDsn(String s)



    public String getDsn() {

        return dsn;

    } //public String getDsn()








    public Vector getLocalStations(String driver,String dsn,String table,String pw,String user) {

        Vector rows = new Vector();

        String query = "select * from " + table;
        DatabaseAccess da = new DatabaseAccess(query,dsn,user,pw,driver);
        rows = da.getRowDataVector();
        da.shutDown();

        Vector rows2 = setLocation(rows,IDSSAppConstants.dataLocationLocal);
        return rows2;


    } //public Vector getLocalStations()




    private boolean checkHistory(String stationName,Timestamp startDate,Timestamp endDate) {

        boolean proceed = true;

        for (int i=0;i<history.size();i++) {
            Vector currentRow = (Vector) history.elementAt(i);
            String station = (String) currentRow.elementAt(0);
            Timestamp start = (Timestamp) currentRow.elementAt(1);
            Timestamp end = (Timestamp) currentRow.elementAt(2);
            //String dataTable = (String) currentRow.elementAt(3);
            //String location = (String) currentRow.elementAt(4);

            if(stationName.equals(station)) {

                //if(dataLocation.equals(location)) {

                    //if(dataTable.equals(table)) {

                        if((startDate.after(start)) || (startDate.equals(start))) {

                            if((endDate.before(end)) || (endDate.equals(end))) {

                                proceed = false;

                            } //if((endDate.before(end)) || (endDate.equals(end)))

                        }//if((startDate.after(start)) || (startDate.equals(start)))

                    //} //if(dataTable.equals(table))

                //} //if(dataLocation.equals(location))

            }

        } //for (int i=0;i<history.size();i++)

        return proceed;


    } //private boolean checkHistory(String stationName,Timestamp startDate,Timestamp endDate,String dataLocation)






    public void fetchData(String stationName,Timestamp startDate,Timestamp endDate,
                                String dataTable,String dataLocation) {


        if (!startDate.after(endDate)) {

            //boolean proceed = checkHistory(stationName,startDate,endDate,dataLocation,dataTable);
            boolean proceed = checkHistory(stationName,startDate,endDate);

            if (!proceed) {

                String message = "You already have a superset of this data.";
                String messageTitle = "Warning";
                Vector v = new Vector();
                v.add(messageTitle);
                v.add(message);
                v.add(new Integer(IDSSAppConstants.warningMessage));

                pcs.firePropertyChange(IDSSAppConstants.showMessage,new Boolean(false),v);
                return;

            } //if(!proceed)


            else {      //if (!proceed)


                ClientDataSet cds = new ClientDataSet();

                if(dataLocation.equals(IDSSAppConstants.dataLocationRemote)) {

                    cds = fetchRemoteData(dataTable,startDate,endDate);

                } //if

                else {

                    cds = fetchLocalData(dataTable,startDate,endDate);

                } //else


                if(cds != null) {

                    cds.setStationName(stationName);
                    pcs.firePropertyChange(IDSSAppConstants.tidalData,new Boolean(false),cds);

                    Vector currentRow = new Vector();
                    currentRow.add(stationName);
                    currentRow.add(startDate);
                    currentRow.add(endDate);
                    //currentRow.add(dataTable);
                    //currentRow.add(dataLocation);
                    history.add(currentRow);

                } //if(cds != null)

            } //else // if (!proceed)

        } //if (!startDate.after(endDate))

    }//public void fetchData(String stationName,Timestamp startDate,Timestamp endDate,
                                //String dataTable,String dataLocation)






    public void disposeData(Vector dataVector) {


        if(history.contains(dataVector))
            history.removeElement(dataVector);


    } //public void disposeData(Vector dataVector)









    private ClientDataSet fetchRemoteData(String dataTable,Timestamp start,Timestamp end) {

        iDSS.beans.TidalDataJBean tdBean = new iDSS.beans.TidalDataJBean();

        //tdBean.setEjbName("TidalDataEJB");
        tdBean.setEjbName(IDSSAppConstants.tidalDataBean);

        //String dbName = "java:comp/env/jdbc/idss";
        String dbName = IDSSAppConstants.tidalDatabaseName;

        ClientDataSet cds = tdBean.select(dataTable,start,end,dbName);
        return cds;

    } //private ClientDataSet fetchRemoteData(String dataTable,Timestamp start,Timestamp end)







    private ClientDataSet fetchLocalData(String table,Timestamp start,Timestamp end) {


        ClientDataSet cds = null;

        if(databaseDriver.length() == 0 || dsn.length() == 0 ||
                        password.length() == 0 || userName.length() == 0) {

            cds = null;

            String message = "Missing atleast one of userName, password, databaseDriver or dsn";
            String messageTitle = "Incomplete information";
            Vector v = new Vector();
            v.add(messageTitle);
            v.add(message);
            v.add(new Integer(IDSSAppConstants.errorMessage));

            pcs.firePropertyChange(IDSSAppConstants.showMessage,new Boolean(false),v);


        } //if(...)

        else {

            String query = "select * from " + table + " where " +
                                    "observ_date>='" + start.toString() + "' and " +
                                    "observ_date<='" + end.toString() + "'";

            DatabaseAccess da = new DatabaseAccess(query,dsn,userName,password,databaseDriver);
            Vector rows = da.getRowDataVector();
            Vector cols = da.getColumnNamesVector();

            cds = new ClientDataSet(query,table,start,end,cols,rows);

            da.shutDown();

        } //else



        return cds;

    } //private ClientDataSet fetLocalData(String dataTable,Timestamp start,Timestamp end)




} //public class TidalStationsLocalJBean
