package iDSS.disp;

import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import java.util.*;
import javax.swing.table.*;


import iDSS.*;
import iDSS.utils.*;
import iDSS.tables.*;



public class TabularDisplay extends DisplayFrame {

  private JTable aTable;
  private JScrollPane aScrollPane;

  private Vector components;


  public TabularDisplay(int row, int column) {

    super ("Table View",true,true,true,true,null);
    aTable = new JTable (row,column);

    aTable.setPreferredScrollableViewportSize(new Dimension(300,100));

    //aScrollPane = new JScrollPane(aTable);

    aScrollPane = new JScrollPane(aTable,JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED,JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);

    getContentPane().add(aScrollPane);
    pack();
    setVisible(true);

  }//public TabularDisplay(int row, int column)








  public TabularDisplay(Vector row, Vector column) {

    super ("Table View",true,true,true,true,null);
    aTable = new JTable (row,column);

    aTable.setPreferredScrollableViewportSize(new Dimension(300,100));

    //aScrollPane = new JScrollPane(aTable);

    aScrollPane = new JScrollPane(aTable,JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED,JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);

    getContentPane().add(aScrollPane);
    pack();
    setVisible(true);

  }//public TabularDisplay(int row, int column)





  public TabularDisplay(String title, GeneralTableModel tm) {

    super (title,true,true,true,true,null);
    aTable = new JTable (tm);
    aTable.setPreferredScrollableViewportSize(new Dimension(300,300));

    //aScrollPane = new JScrollPane(aTable);

    aScrollPane = new JScrollPane(aTable,JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED,JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);

    getContentPane().add(aScrollPane);
    pack();
    setVisible(true);

  }//public TabularDisplay(String title, GeneralTableModel tm)





  public TabularDisplay(String title,GeneralTableModel tm,Vector c) {

    super (title,true,true,true,true,null);
    aTable = new JTable (tm);
    aTable.setPreferredScrollableViewportSize(new Dimension(300,300));

    if (c != null) {
        components = c;
        JPanel cPanel = new JPanel();
        cPanel.setLayout(new BoxLayout(cPanel,BoxLayout.X_AXIS));

        for(int i=0;i<components.size();i++) {
            cPanel.add((JComponent) components.elementAt(i));
        } //for(int i=0;i<components.size();i++)



        aScrollPane = new JScrollPane(aTable,JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED,JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);

        getContentPane().setLayout(new BoxLayout(getContentPane(),BoxLayout.Y_AXIS));
        getContentPane().add(aScrollPane);
        getContentPane().add(cPanel);

    } //if (c != null)

    else {
        aScrollPane = new JScrollPane(aTable,JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED,JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
        getContentPane().add(aScrollPane);
    } //else

    pack();
    setVisible(true);

  }//public TabularDisplay(String title,GeneralTableModel tm,Vector c)








    public void setScrollWindow(int width,int height) {

        aTable.setPreferredScrollableViewportSize(new Dimension(width,height));
        aTable.setSize(new Dimension(width,height));

    } //public void setScrollWindow(int width,int height)




    public TableColumnModel getColumnModel() {

        return aTable.getColumnModel();

    } //public TableColumnModel getColumnModel()



  public static void main(String args[]) {

    JFrame aFrame = new JFrame("TabularDisplay test");

    aFrame.addWindowListener(new WindowAdapter() {
      public void windowClosing(WindowEvent we) {
        System.exit(0);
      }
    });


    TabularDisplay aTable = new TabularDisplay(5,5);

    JDesktopPane dPane = new JDesktopPane();

    dPane.putClientProperty("JDesktopPane.dragMode", "outline");
    dPane.add(aTable);
    aFrame.setContentPane(dPane);

    aFrame.pack();
    aFrame.setSize(500,400);
    aFrame.setVisible(true);

  }//main()


}
