package iDSS.tables;

import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import java.util.*;
import javax.swing.table.*;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.ListSelectionEvent;
import java.sql.Timestamp;
import java.beans.*;



import iDSS.utils.*;





public class ScrollingTable {



    private JScrollPane scrollPane;
    private JTable table;
    private Vector columns,rows;
    private boolean ALLOW_ROW_SELECTION;
    private boolean ALLOW_COL_SELECTION;
    private PropertyChangeSupport pcs;



    public ScrollingTable(Vector columns,Vector rows,int width,int height,
                            boolean allowRowSelection,boolean allowColSelection) {

        pcs = new PropertyChangeSupport(this);

        this.columns = columns;
        this.rows = rows;
        ALLOW_ROW_SELECTION = allowRowSelection;
        ALLOW_COL_SELECTION = allowColSelection;

        GeneralTableModel tm = new GeneralTableModel(rows,columns);
        table = new JTable(tm);

        table.setPreferredScrollableViewportSize(new Dimension(width,height));
        table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);

        handleRowSelection();
        handleColSelection();

        scrollPane = new JScrollPane(table,JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED,
                                        JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);

    } //public ScrollingTable()






    private void handleRowSelection() {


        if (ALLOW_ROW_SELECTION) {
            ListSelectionModel rowSM = table.getSelectionModel();
            rowSM.addListSelectionListener(new ListSelectionListener() {
                public void valueChanged(ListSelectionEvent e) {
                    //Ignore extra messages.
                    if (e.getValueIsAdjusting()) return;
                
                    ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                    if (lsm.isSelectionEmpty()) {
                        System.out.println("ScrollingTable.handleRowSelection(), No rows are selected.");
                        pcs.firePropertyChange(IDSSAppConstants.noRowsSelected,null,new Vector());


                    } else {
                        int selectedRow = lsm.getMinSelectionIndex();
                        System.out.println("ScrollingTable.handleRowSelection(), Row " + selectedRow
                                           + " is now selected.");

                        GeneralTableModel tm = (GeneralTableModel)table.getModel();
                        Vector row = tm.getRow(selectedRow);

                        pcs.firePropertyChange(IDSSAppConstants.oneRowSelected,null,row);


                    }
                }
            });
        } else {
            table.setRowSelectionAllowed(false);
        }



    } //private void handleRowSelection()





    private void handleColSelection() {


        if (ALLOW_COL_SELECTION) { 
            if (ALLOW_ROW_SELECTION) {
                //We allow both row and column selection, which
                //implies that we *really* want to allow individual
                //cell selection.
                table.setCellSelectionEnabled(true);
            } 
            table.setColumnSelectionAllowed(ALLOW_COL_SELECTION);
            ListSelectionModel colSM =
                table.getColumnModel().getSelectionModel();
            colSM.addListSelectionListener(new ListSelectionListener() {
                public void valueChanged(ListSelectionEvent e) {
                    //Ignore extra messages.
                    if (e.getValueIsAdjusting()) return;

                    ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                    if (lsm.isSelectionEmpty()) {
                        System.out.println("ScrollingTable.handleColSelection(), No columns are selected.");
                        pcs.firePropertyChange(IDSSAppConstants.noColsSelected,null,new Integer(-1));

                    } else {
                        int selectedCol = lsm.getMinSelectionIndex();
                        System.out.println("ScrollingTable.handleColSelection(), Column " + selectedCol
                                           + " is now selected.");

                        pcs.firePropertyChange(IDSSAppConstants.oneColSelected,null,new Integer(selectedCol));


                    }
                }
            });
        }


    } //private void handleColSelection()




    public Vector getColumns() {

        GeneralTableModel tm = (GeneralTableModel)table.getModel();
        columns = tm.getColumns();
        return columns;

    } //public Vector getColumns()



    public void setEditableColumn(int col) {

        GeneralTableModel tm = (GeneralTableModel)table.getModel();
        tm.setEditableColumn(col);

    } //public void setEditableColumn(int col)




    public void setEditableColumn(Vector cols) {

        GeneralTableModel tm = (GeneralTableModel)table.getModel();
        tm.setEditableColumn(cols);

    } //public void setEditableColumn(Vector cols)



    public int getNumberOfRows() {

        GeneralTableModel tm = (GeneralTableModel)table.getModel();
        return tm.getNumberOfRows();

    } //public int getNumberOfRows()




    public void addRow(Vector newRow) {

        GeneralTableModel tm = (GeneralTableModel)table.getModel();
        tm.addRow(newRow);
        table.setModel(tm);

    }//public void addRow(Vector newRow) 



    public void addRows(Vector rows) {


        for(int i=0;i<rows.size();i++) {

            Vector oneRow = (Vector)rows.elementAt(i);
            addRow(oneRow);

        } //for(int i=0;i<rows.size();i++)


    }//public void addRows(Vector rows) 




    public void removeRow(Vector rowToRemove) {

        GeneralTableModel tm = (GeneralTableModel)table.getModel();
        tm.removeRow(rowToRemove);
        table.setModel(tm);

    } //public void removeRow(Vector rowToRemove)



    public Vector getRowsVector() {

        GeneralTableModel tm = (GeneralTableModel)table.getModel();
        Vector rows = tm.getRowsVector();
        return rows;

    }//public Vector getRowsVector()





    public Vector getRow(int rowNum) {

        GeneralTableModel tm = (GeneralTableModel)table.getModel();
        Vector row = tm.getRow(rowNum);
        return row;

    } //public Vector getRow(int rowNum)






    public int getColumnCount() {
        GeneralTableModel tm = (GeneralTableModel)table.getModel();
        return tm.getColumnCount();
    }
    



    public int getRowCount() {
        GeneralTableModel tm = (GeneralTableModel)table.getModel();
        return tm.getRowCount();
    }




    public String getColumnName(int col) {
        GeneralTableModel tm = (GeneralTableModel)table.getModel();
        return tm.getColumnName(col);
    }





    public Object getValueAt(int row, int col) {
        GeneralTableModel tm = (GeneralTableModel)table.getModel();
        return tm.getValueAt(row,col);
    }



    public void setValueAt(Object value, int row, int col) {

        GeneralTableModel tm = (GeneralTableModel)table.getModel();
        tm.setValueAt(value,row,col);
        table.setModel(tm);

    } //public void setValueAt(Object value, int row, int col) {






    public JScrollPane getScrollPane() {

        return scrollPane;

    } //public JScrollPane getScrollPane()





    public void addPropertyChangeListener(PropertyChangeListener l) {

        pcs.addPropertyChangeListener(l);

    } //public void addPropertyChangeListener(PropertyChangeListener l)




    public void removePropertyChangeListener(PropertyChangeListener l) {

        pcs.removePropertyChangeListener(l);

    } //public void removePropertyChangeListener(PropertyChangeListener l)








} //public class ScrollingTable extends JScrollPane
